// Initialize bxslider
$(document).ready(function(){
    $('.dictation-notes .item .note-slider').bxSlider({
        pager: false,
        controls: true,
        infiniteLoop: false,
        hideControlOnEnd: true,
        touchEnabled: false,
        adaptiveHeight: true,
        swipeThreshold: 50,

        nextText: '<i class="fa-solid fa-chevron-right"></i>',
        prevText: '<i class="fa-solid fa-chevron-left"></i>'
    });
});



// Editor UI initialization script
$(document).ready(function(){

    $(".live-edit,.ai-generated").liveEdit({
        toolbar: ['bold', 'italic', 'underline', 'strikethrough', 'quote', 'undo', 'redo'],
        allowedTags: ['h3']
    });

});


// AI Enhance
$(document).ready(function(){


    // AI Enhance Button
    $('#ai-enhance').click(function(){

        var dictationText = $('#dictation-text').val();

        // Get streaming response from the API and display it as it comes. Use Jquery AJAX
        var originalText = $('.live-edit .editable-section').html();

        $.ajax({
            url: "https://doctorai.online/api/ai/llm/notes",
            type: "POST",
            data: originalText,
            contentType: "application/json",
            beforeSend: function() {

                // Remove existing indicators
                $('.indicator').remove();

                // Remove Clone Button
                $('.editor-controls .right').find('.clone').remove();

                $('.tooltip-element').remove();
                $('.editor-container').addClass('split');
                $('.single-dictation .inner').addClass('full');
                $('.item.sidebar').hide();
                $('.ai-generated').show();
                $('.live-edit').prepend('<h6 class="indicator">Provider Dictation</h6>');
                $('.ai-generated').prepend('<h6 class="indicator">AI Enhanced Notes</h6>');
                $('#ai-enhance').html('<i class="fa-solid fa-spinner fa-spin-pulse"></i>');

            },
            xhrFields: {
                onprogress: function(e) {
                    var response = e.currentTarget.response;

                    // Process results
                    let lines = response.split("\n");
                    var output = "";
                    
                    for (let line of lines) {
                        if (line.trim().length === 0) {
                            continue;
                        }
                        if (line.trim() === "Plan:" || line.trim() === "Progress Note:") {
                            output += `<h3 contenteditable="false">${line}</h3>`;
                        } else if (line.trim().endsWith(":")) {
                            output += `<p><strong>${line}</strong></p>`;
                        } else {
                            output += `<p>${line}</p>`;
                        }
                    }

                    // Keep scrolling to the bottom
                    $('.ai-generated .editable-section').scrollTop($('.ai-generated .editable-section')[0].scrollHeight);

                    // Output results
                    $('.ai-generated .editable-section').html(output);

                }
            },
            success: function(data) {

                // Save AI Generated Note to Database
                var aiText = $('.ai-generated .editable-section').html();
                var dictation_id = $('body').data('dictation-note-id');
                $.ajax({
                    type: 'POST',
                    url: 'process/save-ai-note.php',
                    data: {
                        dictation_id: dictation_id,
                        note: aiText
                    },
                    success: function(response) {

                        // Get saved note id from response and set it as data attribute in body
                        $('body').attr('data-ai-note-id', response.ai_note_id);

                        // Add Clone Button
                        $('.editor-controls .right').prepend('<button class="button clone tooltip" data-tooltip="Copy to Clipboard">Copy</button>');

                        // Add Save Button
                        // $('.editor-controls .right').prepend('<button class="button tooltip" id="save-ai-note" data-tooltip="Save AI Generated Note"><i class="fa-regular fa-floppy-disk"></i></button>');

                        // Add Report Button
                        $('.editor-controls .right').prepend('<button class="button tooltip" id="report-ai-note" data-tooltip="Report Hallucination">Report</button>');

                        // Add AI Generate Button
                        $('#ai-enhance').remove();

                    },
                    error: function(xhr, status, error) {
                        console.error("Error:", status, error);
                    }
                });

            },
            error: function(xhr, status, error) {

                // Show appropriate error message related to the error status
                if (status == 'timeout') {
                    var message = 'Error: Gateway Timeout';
                } else if (status == 'error') {
                    var message = 'Error: Internal Server Error';
                } else {
                    var message = 'Error: Unknown Error';
                }

                // Show Sweet Alert
                Swal.fire({
                    icon: 'error',
                    title: 'AI Note Generation Failed',
                    text: message
                });

                // Revert back to original editor state
                $('.ai-generated').hide();
                $('.indicator').remove();
                $('.editor-controls .right').find('.clone').remove();
                $('.editor-container').removeClass('split');
                $('.single-dictation .inner').removeClass('full');
                $('.item.sidebar').show();
                $('#ai-enhance').html('AI Note');

            }
        });

    });

    // Update Original Dictation Note
    $('#update-note').click(function(){

        var OriginalText = $('.live-edit .editable-section').html();
        var dictation_id = $('body').data('dictation-note-id');

        $.ajax({
            type: 'POST',
            url: 'process/update-dictation-note.php',
            data: {
                dictation_id: dictation_id,
                note: OriginalText
            },

            success: function (response) {

                const Toast = Swal.mixin({
                    toast: true,
                    position: "bottom-end",
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                      toast.onmouseenter = Swal.stopTimer;
                      toast.onmouseleave = Swal.resumeTimer;
                    }
                });

                Toast.fire({
                    icon: response.icon,
                    title: response.title,
                    text: response.message
                });

                // Show Edit Button
                $('#edit-note').show();

                // Hide Save Button
                $('#update-note').hide();

                // Hide Cancel Button
                $('#cancel-edit').hide();

                // Disable Text Editor
                $('.live-edit .editable-section').attr('contenteditable', 'false');

            },
        
            error: function (error) {
                console.error('Error:', error);
            }
        });

    });

    // Copy AI Note to Clipboard
    $(document).on('click', '.clone', function(){

        var aiText = $('.ai-generated .editable-section').html();

        // Create a textarea element
        var textarea = document.createElement('textarea');

        // Set the value of the text area
        textarea.value = aiText;

        // Append the textarea to the body
        document.body.appendChild(textarea);

        // Select the text
        textarea.select();

        // Copy the text to the clipboard
        document.execCommand('copy');

        // Remove the textarea
        document.body.removeChild(textarea);

        // Show Toast
        const Toast = Swal.mixin({
            toast: true,
            position: "bottom-end",
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
              toast.onmouseenter = Swal.stopTimer;
              toast.onmouseleave = Swal.resumeTimer;
            }
        });

        Toast.fire({
            icon: 'success',
            title: 'AI Note Copied to Clipboard'
        });

    });

    // Delete Dictation Note
    $('.editor-controls .delete').click(function(){

        var dictation_id = $('body').data('dictation-note-id');

        // Sweet Alert, Confirm Delete
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {

            if (result.isConfirmed) {

                $.ajax({
                    type: 'POST',
                    url: 'process/delete-dictation-note.php',
                    data: {
                        dictation_id: dictation_id
                    },

                    success: function (response) {

                        const Toast = Swal.mixin({
                            toast: true,
                            position: "bottom-end",
                            showConfirmButton: false,
                            timer: 3000,
                            timerProgressBar: true,
                            didOpen: (toast) => {
                            toast.onmouseenter = Swal.stopTimer;
                            toast.onmouseleave = Swal.resumeTimer;
                            }
                        });

                        Toast.fire({
                            icon: response.icon,
                            title: response.title
                        });

                        // Redirect to Dictation Notes
                        window.location.href = "dictation-notes.php";


                    },
                
                    error: function (error) {
                        console.error('Error:', error);
                    }
                });

            }
            
        });

    });

    // Load AI Note
    $('.single-dictation .entry-list ul li').click(function(){

        var ai_note_id = $(this).data('ai-note-id');
        var note_date = $(this).children('span').html();
        var note = $(this).children('.complete-note').html();

        // Show AI note Editor and populate with note
        $('.ai-generated .editable-section').html(note);

        // Set data attribute for AI Note ID
        $('body').attr('data-ai-note-id', ai_note_id);

        // Hide Sidebar
        $('.item.sidebar').hide();

        // Show AI Note
        $('.ai-generated').show();

        // Add Split View
        $('.editor-container').addClass('split');
        $('.single-dictation .inner').addClass('full');

        // Add Indicator
        $('.live-edit').prepend('<h6 class="indicator">Provider Dictation</h6>');
        $('.ai-generated').prepend('<h6 class="indicator">AI Enhanced Notes - '+note_date+'</h6>');

        // Add Clone Button
        $('.editor-controls .right').prepend('<button class="button clone tooltip" data-tooltip="Copy to Clipboard">Copy</button>');

    });

    // Report AI Note
    $(document).on('click', '#report-ai-note', function(){

        var ai_note_id = $('body').data('ai-note-id');

        // Sweet Alert, Confirm Delete
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to report this note as hallucination!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, report it!'
        }).then((result) => {

            if (result.isConfirmed) {

                $.ajax({
                    type: 'POST',
                    url: 'process/report-ai-note.php',
                    data: {
                        ai_note_id: ai_note_id
                    },

                    success: function (response) {

                        const Toast = Swal.mixin({
                            toast: true,
                            position: "bottom-end",
                            showConfirmButton: false,
                            timer: 3000,
                            timerProgressBar: true,
                            didOpen: (toast) => {
                            toast.onmouseenter = Swal.stopTimer;
                            toast.onmouseleave = Swal.resumeTimer;
                            }
                        });

                        Toast.fire({
                            icon: response.icon,
                            title: response.title,
                            text: response.message
                        });

                        // Remove the report button
                        $('#report-ai-note').remove();

                    },
                
                    error: function (error) {
                        console.error('Error:', error);
                    }
                });

            }
            
        });

    });

});


$(document).ready(function() {
    // Use event delegation to handle hover for static and dynamically generated elements
    $(document).on('mouseenter', '.tooltip', function() {
        // Get the tooltip text from the "data-tooltip" attribute
        var tooltipText = $(this).attr('data-tooltip');
        
        // Create a new tooltip element
        var tooltipElement = $('<div class="tooltip-element">' + tooltipText + '</div>');
        
        // Append the tooltip element to the body
        $('body').append(tooltipElement);
        
        // Position the tooltip element relative to the document
        var offset = $(this).offset();
        var tooltipWidth = tooltipElement.outerWidth();
        var elementWidth = $(this).outerWidth();
        
        tooltipElement.css({
            top: offset.top - tooltipElement.outerHeight() - 5, // Position above with 5px margin
            left: offset.left + (elementWidth / 2) - (tooltipWidth / 2)
        });
    });

    $(document).on('mouseleave', '.tooltip', function() {
        // Remove the tooltip element when the mouse leaves
        $('.tooltip-element').remove();
    });
});




// Expand and Collapse
$(document).ready(function(){

    // Expand
    $('.dictation-notes .item .note-text .more').click(function(e){

        e.preventDefault();

        // Get data-note-id attribute from anchor tag
        var note_id = $(this).data('note-id');

        // Show the note with the corresponding note_id
        $('#expanded_note_'+note_id).show();

        // Hide the more original note
        $('#compressed_note_'+note_id).hide();

    });

});



$(document).ready(function(){

    // Edit link
    $('.dictation-list .link.edit').click(function(e){

        // Prevent default behaviour
        e.preventDefault();

        // Hide Content
        $(this).parent().hide();

        // Show editor
        $(this).parent().siblings().show();

        // Reset Placeholder
        $('.aienhanced-placeholder').html();

        // Hide placeholder
        $('.aienhanced-placeholder').hide();

        // Hide Alt Buttons
        $(".plain.aienhanceBtn").hide();
        $(".plain.aienhanceloading").hide();

    });

    // Cancel button
    $('.dictation-list .link.cancel').click(function(e){
        
        // Prevent default behaviour
        e.preventDefault();

        var original_content = $(this).parent().siblings().children('p').html();

        // Restore the original content
        $(this).siblings('.text-editor').val(original_content);

        // Hide editor
        $(this).parent().hide();

        // Show content
        $(this).parent().siblings().show();

        // Show Alt Buttons
        $(".plain.aienhanceBtn").show();

    });

    // Save button
    $('.dictation-list .link.save').click(function(e){
        
        // Prevent default behaviour
        e.preventDefault();

        // Variables
        var dictation_id = $(this).parent().parent().parent().data('id');
        var text_content = $(this).siblings('.text-editor').val();

        $.ajax({
            type: 'POST',
            url: 'process/edit-dictation.php',
            data: {
                dictation_id: dictation_id,
                text_content: text_content
            },

            success: function (response) {
                
                if( response.result == true ){

                    // Retain content into the placeholder
                    $('#dictation_'+dictation_id+' .view-container p').html(text_content);

                    // Hide editor
                    $('#dictation_'+dictation_id+' .edit-container').hide();

                    // Show Content
                    $('#dictation_'+dictation_id+' .view-container').show();

                }

                const Toast = Swal.mixin({
                    toast: true,
                    position: "bottom-end",
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                      toast.onmouseenter = Swal.stopTimer;
                      toast.onmouseleave = Swal.resumeTimer;
                    }
                });

                Toast.fire({
                    icon: response.icon,
                    title: response.title
                });

            },
        
            error: function (error) {
                console.error('Error:', error);
            }
        });

    });

    // AI Enhanced: Editor
    $('.editor.aienhanceBtn').click(function(){
        
        var dictationText = $(this).siblings('.text-editor').val();
        var dictation_id = $(this).parent().parent().parent().attr('id');

        $.ajax({
            url: 'https://doctorai.online/api/ai/llm/notes',
            type: 'POST',
            data: dictationText,

            beforeSend: function(){

                // Hide button & Show loading
                $('#'+dictation_id+' .aienhanceBtn').hide();
                $('#'+dictation_id+' .aienhanceloading').show();

            },

            success: function (response) {

                // Process results
                let lines = response.split("\n");
                var output = "";
                for (let line of lines) {
                    if (line.trim().length === 0) {
                    continue;
                    }
                    if (line.trim().endsWith(":")) {
                    output += `<p style="font-weight: bold;">${line}</p>`;
                    } else {
                    output += `<p>${line}</p>`;
                    }
                }

                const Toast = Swal.mixin({
                    toast: true,
                    position: "bottom-end",
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                      toast.onmouseenter = Swal.stopTimer;
                      toast.onmouseleave = Swal.resumeTimer;
                    }
                });

                Toast.fire({
                    icon: 'success',
                    title: 'AI Notes Completed'
                });

                // Output results
                $('#'+dictation_id+' .aienhanced-placeholder').html(output);

                // Show placeholder
                $('#'+dictation_id+' .aienhanced-placeholder').show();

                // Secretly change value of the textarea
                $('#'+dictation_id+' .text-editor').val(response);

                // Hide Text Editor
                $('#'+dictation_id+' .text-editor').hide();

                // Bring back the button & Hide loading
                $('#'+dictation_id+' .aienhanceBtn').show();
                $('#'+dictation_id+' .aienhanceloading').hide();

            }
            
        });

    });

    // AI Enhanced: Plain
    $('.plain.aienhanceBtn').click(function(){
        
        var dictationText = $(this).siblings('.edit-container').children('.text-editor').val();
        var dictation_id = $(this).parent().parent().attr('id');

        $.ajax({
            url: 'https://doctorai.online/api/ai/llm/notes',
            type: 'POST',
            data: dictationText,

            beforeSend: function(){

                // Show loading
                $('#'+dictation_id+' .plain.aienhanceloading').show();
                $('#'+dictation_id+' .plain.aienhanceBtn').hide();

                $('#'+dictation_id+' .view-container .edit').hide();

            },

            success: function (response) {

                // Process results
                let lines = response.split("\n");
                var output = "";
                for (let line of lines) {
                    if (line.trim().length === 0) {
                    continue;
                    }
                    if (line.trim().endsWith(":")) {
                    output += `<p style="font-weight: bold;">${line}</p>`;
                    } else {
                    output += `<p>${line}</p>`;
                    }
                }

                const Toast = Swal.mixin({
                    toast: true,
                    position: "bottom-end",
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                      toast.onmouseenter = Swal.stopTimer;
                      toast.onmouseleave = Swal.resumeTimer;
                    }
                });

                Toast.fire({
                    icon: 'success',
                    title: 'AI Notes Completed'
                });

                // Output results
                $('#'+dictation_id+' .view-container p').html(output);

                // Show placeholder
                $('#'+dictation_id+' .aienhanced-placeholder').show();

                // Hide loading
                $('#'+dictation_id+' .aienhanceloading').hide();

            }
            
        });

    });

    // Edit Editor Button
    $('.editor-controls #edit-note').click(function(){

        // Hide Edit Button
        $(this).hide();

        // Show Save Button
        $('#update-note').show();

        // Show Cancel Button
        $('#cancel-edit').show();

        // Enable Text Editor
        $('.live-edit .editable-section').attr('contenteditable', 'true');

        // Focus on the Text Editor
        $('.live-edit .editable-section').focus();

    });

    // Cancel Edit Button
    $('.editor-controls #cancel-edit').click(function(){

        // Show Edit Button
        $('#edit-note').show();

        // Hide Save Button
        $('#update-note').hide();

        // Hide Cancel Button
        $('#cancel-edit').hide();

        // Disable Text Editor
        $('.live-edit .editable-section').attr('contenteditable', 'false');

        // Revert back to original content
        var original_content = $('.original-note').html();
        $('.live-edit .editable-section').html(original_content);

    });

});