$(document).ready(function(){
    
    // Select close button
    $('.selectsearch .close').click(function(){
        
        $('.selectsearch .search-result').hide();
        $('.searchBox').val('');
        
    });
    
    
    // Show dropdown when stated typing
    $(".selectsearch .searchBox").on('change keyup paste', function() {
        
        $('.selectsearch .search-result').show();
        
        if( $(this).val() === '' ){
            $('.selectsearch .search-result').hide();
        }
        
        //Show hide button
        $('.meeting-form-container .form-container .selectsearch .close').show();
        
        
        
        var search_qry = $(this).val();
        
        $.ajax({
            type: "POST",
            url: 'process/MeetingSearchProvider.php',
            
            data:{
                search_qry: search_qry
            },
            
            success: function(data){
                
                // Reset Result
                $('.selectsearch .search-result').html('');
                
                var x;
                var i;
                var arrayLength = data.length;
                var ItemsLength;
                var Item;
                
                for (i = 0; i < arrayLength; i++) {
                    
                    var label = data[i].label;
                    var result = data[i].result;
                    
                    if( result === true ){
                    
                        $('.selectsearch .search-result').append('<li class="label">'+label+'</li>');
                        
                        ItemsLength = data[i].items.length;
                        Item = data[i].items;
                        
                        for (x = 0; x < ItemsLength; x++) {
                            
                            $('.selectsearch .search-result').append('<li class="item" data-user-type="'+Item[x].user_type+'" data-id="'+Item[x].id+'" data-user-id="'+Item[x].userid+'">'+Item[x].first_name+' '+Item[x].last_name+'</li>');
                            
                            
                        }
                    
                    }
                    
                    
                }
                
            }
        
        });
        
    });
    
    
    // Select Attendee
    $('body').on('click', '.selectsearch .search-result li.item', function() {
        
        var text = $(this).text();
        var userID = $(this).attr('data-user-id');
        var user_type = $(this).attr('data-user-type');
        
        // Insert into placeholder
        $('.selectsearch .placeholder').append('<span class="item" data-user-type="'+user_type+'" data-type="user_id" data-contact-source="'+userID+'">'+text+'<ion-icon name="close-outline"></ion-icon></span>');
        
        // Reset the search field
        $('.meeting-form-container .form-container .selectsearch .searchBox').val('');
        
        // Hide close button
        $('.meeting-form-container .form-container .selectsearch .close').hide();
        
        // Hide search results
        $('.selectsearch .search-result').hide();
        
    });
    
    
    // Remove Attendee
    $('body').on('click', '.selectsearch .placeholder .item', function() {
        $(this).remove();
    });
    
    
    // Custom Attendee
    $('.add-custom-attendee').click(function(){
        $('.attendeeOption-group').show();
        $('.searchBox-group').hide();
    });
    
    
    // Switch to search attendee
    $('.switch-to-search').click(function(){
        $('.attendeeOption-group').hide();
        $('.searchBox-group').show();
    });
    
    
    // Add custom attendee
    $('.meeting-form-container .form-container .selectsearch .attendeeOption-group .add').click(function(){
        
        var customAttendee = '';
        var AttendeeType = '';
        
        if( $('.meeting-form-container .form-container .selectsearch .attendeeOption-group .add-textbox.phone').val() !== '' ){
            
            var country = $('.meeting-form-container .form-container .selectbox.isoCode').find(":selected").val();
            customAttendee = country+$('.meeting-form-container .form-container .selectsearch .attendeeOption-group .add-textbox.phone').val();
            AttendeeType = 'phone';
            userID = country+$('.meeting-form-container .form-container .selectsearch .attendeeOption-group .add-textbox.phone').val();
            
        }else if( $('.meeting-form-container .form-container .selectsearch .attendeeOption-group .add-textbox.email').val() !== '' ){
            
            customAttendee = $('.meeting-form-container .form-container .selectsearch .attendeeOption-group .add-textbox.email').val();
            AttendeeType = 'email';
            userID = $('.meeting-form-container .form-container .selectsearch .attendeeOption-group .add-textbox.email').val();
            
        }else{
            customAttendee = '';
            
            Swal.fire({
                icon: 'error',
                title: 'Invalid Contact',
                text: 'Please fill up one of the contact fields before trying to add a contact.',
            });
            
        }
        
        // Reset Values
        $('.meeting-form-container .form-container .selectsearch .attendeeOption-group .add-textbox.phone').val('');
        $('.meeting-form-container .form-container .selectsearch .attendeeOption-group .add-textbox.email').val('');
        
        // Insert info placeholder
        $('.selectsearch .placeholder').append('<span class="item" data-user-type="none" data-type="'+AttendeeType+'" data-contact-source="'+userID+'">'+customAttendee+'<ion-icon name="close-outline"></ion-icon></span>');
        
    });
    
    
    // Reset values when writing new contact
    $(".meeting-form-container .form-container .selectsearch .attendeeOption-group .add-textbox.email").on('change keyup paste', function() {
        $('.meeting-form-container .form-container .selectsearch .attendeeOption-group .add-textbox.phone').val('');
    });
    
    $(".meeting-form-container .form-container .selectsearch .attendeeOption-group .add-textbox.phone").on('change keyup paste', function() {
        $('.meeting-form-container .form-container .selectsearch .attendeeOption-group .add-textbox.email').val('');
    });
    
    
    // Enable Meeting Occurances
    $('body').on('click', '.rec-toggle.off', function() {
        
        $(this).removeClass('off');
        $(this).addClass('on');
        
        $(this).attr('src','assets/images/switch-on.svg');
        $(this).attr('data-reccuring-meeting','on');
        
        $('.recurrence').show();
        
        // Reset Select value for Recurrence
        $('.select-recurrence').val('daily');
        $(".select-recurrence").val('daily').change();
        
    });
    
    
    // Disable Meeting Occurances
    $('body').on('click', '.rec-toggle.on', function() {
        
        $(this).removeClass('on');
        $(this).addClass('off');
        
        $(this).attr('src','assets/images/switch-off.svg');
        $(this).attr('data-reccuring-meeting','off');
        
        $('.recurrence').hide();
        $('.rec_group').hide();
        
    });
    
    
    // Select Recurrence
    $('.select-recurrence').on('change', function() {
        
        // Hide Others
        $('.rec_group').hide();
        
        if( $(this).find(":selected").val() === 'weekly' ){
            $('.rec_group.weekly').show();
        }else if( $(this).find(":selected").val() === 'monthly' ){
            $('.rec_group.monthly').show();
        }
        
    });
    
    
    /* Create Meeting Schedule */
    $('.create-meeting-form').submit(function(e){
        
        // Prevent form from submitting
        e.preventDefault();
        
        var attendeeList = [];
        
        var owner_id = $('body').data('user-id');
        var meetingTitle = $('.meetingTitle').val();
        var selectDate = $('.selectDate').val();
        var selectTime = $('.selectTime').find(":selected").val();
        var selectPeriod = $('.selectPeriod').find(":selected").val();
        var durationHour = $('.durationHour').find(":selected").val();
        var durationMinute = $('.durationMinute').find(":selected").val();
        var timezone = $('.timezone').find(":selected").val();
        var attendees = $('.placeholder').html();
        var meeetingNotes = $('.meeetingNotes').val();
        
        $('.meeting-form-container .placeholder span.item').each(function(){
            
            var contactUserType = $(this).attr('data-user-type');
            var contactType = $(this).attr('data-type');
            var contactSource = $(this).attr('data-contact-source');
            
            attendeeList.push({
                "contact_type": contactType,
                "contact_source": contactSource,
                "contactUserType": contactUserType
            });
            
        });
        attendeeList = JSON.stringify(attendeeList);
        
        if( meetingTitle === '' || selectDate === '' || selectTime === '' || selectPeriod === '' || durationHour === '' || durationMinute === '' || timezone === '' || attendees === '' ){
            
            Swal.fire({
                icon: 'error',
                title: 'Empty Fields',
                text: 'Some fields are empty, please fill all of them before submitting.'
            });
            
        }else{
            
            $.ajax({
                type: "POST",
                url: 'process/create-meeting.php',
                
                data:{
                    owner_id:owner_id,
                    meetingTitle:meetingTitle,
                    selectDate: selectDate,
                    selectTime: selectTime,
                    selectPeriod: selectPeriod,
                    durationHour: durationHour,
                    durationMinute:durationMinute,
                    timezone:timezone,
                    attendeeList:attendeeList,
                    meeetingNotes:meeetingNotes
                },
                
                success: function(data){
                    
                    if( data.result === true ){
                        
                        Swal.fire({
                            title: data.title,
                            text: data.text,
                            icon: data.icon,
                            showCancelButton: false,
                            confirmButtonColor: '#3085d6',
                            confirmButtonText: 'Done'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                window.location.replace("videocall-meetings.php");
                            }
                        });
                        
                    }else{
                        
                        Swal.fire({
                            icon: data.icon,
                            title: data.title,
                            text: data.text,
                        });
                        
                    }
                    
                }
            
            });
            
        }
        
        // Validation red border in input forms
        $(".selectbox").each(function(){
            
            if( $(this).find(":selected").val() === '' ){
                $(this).addClass('required');
            }
            
        });
        $(".textbox").each(function(){
            
            if( $(this).val() == '' ){
                $(this).addClass('required');
            }
            
        });
        
        if( $('.placeholder').html() == '' ){
            $('.searchBox').addClass('required');
        }
        
        
    });
    
    
    /* Reset Values for textbox */
    $(".textbox").on('input change paste keyup', function() {
        $(this).removeClass('required');
    });
    
    
    /* Reset Values for selectbox */
    $('.selectbox').on('change click active', function() {
        $(this).removeClass('required');
    });
    
    
    $(".searchBox").on('input change paste keyup', function() {
        $('.searchBox').removeClass('required');
    });
    
    
});


