jQuery(document).ready(function($){

	$('.form-container').on('click', '.transfer-container .transfer.right', function() {
		
		var existing_list = [];
		var new_list = [];
		var combined_list = [];
		var i = 0;

		var user_id = $(this).data('id');
		var data_diag;
        
        // Store list from textbox
		$(".search-diagnosis-container .textbox").each(function(){
			if( $(this).val() !== '' && $(this).val().includes("follow-up") === true ){
				new_list[i++] = $(this).val();
			}
		});
		
		// Store list from existing list
		$('.diaglosis-list-container ul li').each(function(){
		    existing_list[i++] = $(this).text();
		});
        
        // Combine Two Arrays
        combined_list = existing_list.concat(new_list);
        
        // Remove Duplicates
        combined_list = combined_list.filter( function( item, index, inputArray ) {
           return inputArray.indexOf(item) == index;
        });
        
        // Convert array into string
		var data_diag = combined_list.toString();

		// Start Condition
		if( $('.search-1').val() != '' || $('.search-2').val() != '' || $('.search-3').val() != '' || $('.search-4').val() != '' || $('.search-5').val() != '' ){

			// Transfer Search Queries
			$('.diaglosis-list-container ul').html('');
	    	
	    	// Apend to list
	    	for( var x = 0; x <= combined_list.length; x++ ){
	    	    if( combined_list[x] != undefined ){
	    	        
	    	        $('.diaglosis-list-container ul').append( '<li>'+combined_list[x]+'</li>' );
	    	        
	    	    }
	    	}

			// Reset Searchbox
			$('.textbox').val('');

			// Start Ajax
			$.ajax({
				type: 'POST',
				url: 'process/history_medical.php',

				data: {
					user_id:user_id,
					data_diag:data_diag
				},

				beforeSend: function() {
				    
					// Do Something
					
				},
				success: function(response) {
				    
					Swal.fire({
						position: 'center',
						icon: response.status,
						title: response.message,
						showConfirmButton: false,
						timer: 1500
					});
					
				},	
				fail: function(response){
				    
					// Do Something
					
				}

			});
			// End Ajax

		}else{

            Swal.fire({
              icon: 'error',
              title: 'Search boxes are empty!',
              text: 'Please enter atleast 1 medical condition before submitting.'
            });

		}
		// End Condition

	});

	$('.diaglosis-list-container').on('click', 'ul li img', function() {
        
		var diag_id = $(this).data('diagnosis-id');
		var history = $(this).closest('ul').data('base');

		// Start Ajax
		$.ajax({
			type: 'POST',
			url: 'process/history_medical_delete.php',

			data: {
				diag_id:diag_id,
				history:history
			},

			beforeSend: function() {
				// Do Something
			},
			success: function(response) {
				
				if(response.result == true){

					// Remove Diagnosis from List
					$("#diagnosis_"+diag_id).remove();

				}

			},	
			fail: function(response){
				// Do Something
				alert('false');
			}

		});
		// End Ajax

	});
	
	/* ----------------------------------------------- */
	/* Search Symptoms */
	/* ----------------------------------------------- */
	$('.search_symptom_qry').keyup(function(){
        
        var search_qry = $(this).val();
        var selectedID = $(this).attr('id');
        var tempItem = '';
        
        // Reset Result
        $('.search-result-container ul').html('');
        
        // Start Ajax
		$.ajax({
			type: 'POST',
			url: 'process/search-diagnosis.php',

			data: {
				search_qry:search_qry
			},

			beforeSend: function() {
				// Do Something
			},
			success: function(response) {
			    
				if(response.result == true){
                    
                    for (let i = 0; i < response.items.length; i++) {
                        tempItem = tempItem+'<li>'+response.items[i].symptom_name+'</li>';
                    }
                    
                    //$('#'+selectedID).siblings('.search-result-container ul').html(tempItem);
                    $('.search-result-container.'+selectedID+' ul').html(tempItem);
                    
				}
				
			},	
			fail: function(response){
				// Do Something
				//alert('false');
			}

		});
		// End Ajax
        
    });
    
    
    /* ----------------------------------------------- */
	/* Select Search */
	/* ----------------------------------------------- */
	//$('.search-result-container ul li').click(function(){
	$(document).on('click', '.search-result-container ul li', function(){
	    
	    var selectedSearch = $(this).text();
	    
	    // Insert selected value into text/search bar
	    //$('.search_symptom_qry').val(selectedSearch);
	    $(this).parent().parent().siblings('.textbox').val(selectedSearch);
        
        // Remove Search Result
        $('.search-result-container ul').html('');
        	    
	});
	
});