jQuery(document).ready(function($){

	function process_vitals(){
		var encounter_id = $('.encounter_id').data('vitals-encounter');
		var systolicbp = $('#systolicBP').val();
		var diastolicbp = $('#diastolicBP').val();
		var heartrate = $('#heartRate').val();
		var respiratoryrate = $('#respRate').val();
		var pulseox = $('#pulseOX').val();
		var temperature = $('#temp').val();
        console.log(systolicbp, diastolicbp, heartrate);
		$.ajax({
			type: 'POST',
			url: 'process/update_vitals.php',

			data: {
				encounter_id:encounter_id,
				systolicbp:systolicbp,
				diastolicbp:diastolicbp,
				heartrate:heartrate,
				respiratoryrate:respiratoryrate,
				pulseox:pulseox,
				temperature:temperature
			},

			beforeSend: function() {
			    // Do Something
			},
			success: function(response) {
				//alert('Update Successful!');
				console.log(response);
			},
			
			fail: function(response){
				//alert('Update Failed!');
			}

		});

	}

	/* ----------------------------------------------- */
	/* Update Social Status */
	/* ----------------------------------------------- */
	$('.selectbox.social-status').change(function() {

		var user_id = $(this).closest('.diagnosis-container').data('id');
		var social_type = $(this).attr('name');
		var social_value = $(this).val();

		// Start Ajax
		$.ajax({
			type: 'POST',
			url: 'process/update_social.php',

			data: {
				user_id:user_id,
				social_type:social_type,
				social_value:social_value
			},

			beforeSend: function() {
				// Do Something
			},
			success: function(response) {
				// Do Something
				if(response == 'true'){
					//alert('success');
				}else{
					//alert('false');
				}
			},	
			fail: function(response){
				// Do Something
				//alert('false');
			}

		});
		// End Ajax
		
	});
	
	
    /* ----------------------------------------------- */
	/* Search Symptoms */
	/* ----------------------------------------------- */
	/*
	$('.search_symptom_qry').keyup(function(){
        
        var search_qry = $(this).val();
        var tempItem = '';
        
        // Reset Result
        $('.search-result-container ul').html('');
        
        // Start Ajax
		$.ajax({
			type: 'POST',
			url: 'process/search-diagnosis.php',

			data: {
				search_qry:search_qry
			},

			beforeSend: function() {
				// Do Something
			},
			success: function(response) {
			    
				if(response.result == true){
                    
                    for (let i = 0; i < response.items.length; i++) {
                        tempItem = tempItem+'<li>'+response.items[i].symptom_name+'</li>';
                    }
                    
                    $('.search-result-container ul').html(tempItem);
                    
				}
				
			},	
			fail: function(response){
				// Do Something
				//alert('false');
			}

		});
		// End Ajax
        
    });
	*/

	$('.search_symptom_qry').keyup(function(){
        
        var search_qry = $(this).val();
        var selectedID = $(this).parent().parent().attr('id');
        var tempItem = '';
        
        // Reset Result
        $('.search-result-container ul').html('');
        
        // Start Ajax
		$.ajax({
			type: 'POST',
			url: 'process/search-diagnosis.php',

			data: {
				search_qry:search_qry
			},

			beforeSend: function() {
				// Do Something
			},
			success: function(response) {
			    
				if(response.result == true){
                    
                    for (let i = 0; i < response.items.length; i++) {
                        tempItem = tempItem+'<li>'+response.items[i].symptom_name+'</li>';
                    }

                    $('#'+selectedID+' .search-result-container ul').html(tempItem);
                    
				}
				
			},	
			fail: function(response){
				// Do Something
				//alert('false');
			}

		});
		// End Ajax
        
    });
    
    
    /* ----------------------------------------------- */
	/* Select Search */
	/* ----------------------------------------------- */
	$(document).on('click', '.search-result-container ul li', function(){
	    
	    var selectedSearch = $(this).text();
		var selectedID = $(this).parent().parent().parent().parent().attr('id');
	    
	    // Insert selected value into text/search bar
		$('#'+selectedID+' .symptoms_search_box').val(selectedSearch);
        
        // Remove Search Result
        $('.search-result-container ul').html('');
        	    
	});


    $('#saveVitals').on({ 'click' : function(){
		
		var patient_id = $('body').data('patient-id');
		var systolicBP = $('#systolicBP').val();
		var diastolicBP = $('#diastolicBP').val();
		var heartRate = $('#heartRate').val();
		var respRate = $('#respRate').val();
		var pulseOX = $('#pulseOX').val();
		var temp = $('#temp').val();
		
		$.ajax({
			type: 'POST',
			url: 'process/patient_add_vitals.php',

			data: {
			    patient_id:patient_id,
				systolicBP:systolicBP,
				diastolicBP:diastolicBP,
				heartRate:heartRate,
				respRate:respRate,
				pulseOX:pulseOX,
				temp:temp
			},

			beforeSend: function() {
			    // Do Something
			},
			success: function(response) {
				Swal.fire({
					  type: response.rstatus,
					  title: response.rstatus,
					  text: response.desc
				});
				
				if( response.rstatus == 'success' ){
				    $('.textbox.vitals').val('');
				}
				
			},
			
			fail: function(response){
				
				Swal.fire({
					  type: 'error',
					  title: 'Error',
					  text: 'Something went wrong, please try again'
				});
				
			}

		});
		
    }});
    
    
	$('.add_medical').on({ 'click' : function(){
	    
		var inputbox = $(this).siblings('.textbox').val();
		var patient_id = $('body').data('patient_id');

		if( inputbox == '' || inputbox == ' ' ){
			Swal.fire({
			  type: 'error',
			  title: 'Oops...',
			  text: "You can't submit an empty field",
			  timer: 2000
			});
		}else{

			$.ajax({
				type: 'POST',
				url: 'process/submit_medical.php',

				data: {
					inputbox:inputbox,
					patient_id:patient_id
				},

				beforeSend: function() {
					// Do Something
				},
				success: function(response) {

					Swal.fire({
						  type: response.status,
						  title: response.title,
						  text: response.message,
						  timer: 2000
					});

					$('.dynamical_entry.medical').append('<label class="pending"><span>'+inputbox+'</span><strong>Pending</strong></label>');
					$('.txt_medical').val('');

				},
						
				fail: function(response){
					//alert('Update Failed!');
				}
			});
		}
	}});


	$('.add_surgical').on({ 'click' : function(){

		var inputbox = $('.txt_surgical').val();
		var patient_id = $('body').data('patient_id');

		if( inputbox == '' || inputbox == ' ' ){
			Swal.fire({
			  type: 'error',
			  title: 'Oops...',
			  text: "You can't submit an empty field",
			  timer: 2000
			});
		}else{

			$.ajax({
				type: 'POST',
				url: 'process/submit_surgical.php',

				data: {
					inputbox:inputbox,
					patient_id:patient_id
				},

				beforeSend: function() {
					// Do Something
				},
				success: function(response) {

					Swal.fire({
						type: response.status,
						title: response.title,
						text: response.message,
						timer: 2000
				  });

					$('.dynamical_entry.surgical').append('<label class="pending"><span>'+inputbox+'</span><strong>Pending</strong></label>');
					$('.txt_surgical').val('');
                    
                    console.log(response);
                    
				},
						
				fail: function(response){
					//alert('Update Failed!');
				}
			});
		}
	}});


	$('.add_family').on({ 'click' : function(){
		var inputbox = $('.txt_family').val();
		var patient_id = $('body').data('patient_id');

		if( inputbox == '' || inputbox == ' ' ){
			Swal.fire({
			  type: 'error',
			  title: 'Oops...',
			  text: "You can't submit an empty field",
			  timer: 2000
			});
		}else{

			$.ajax({
				type: 'POST',
				url: 'process/submit_family.php',

				data: {
					inputbox:inputbox,
					patient_id:patient_id
				},

				beforeSend: function() {
					// Do Something
				},
				success: function(response) {

					Swal.fire({
						type: response.status,
						title: response.title,
						text: response.message,
						timer: 2000
				  	});

					$('.dynamical_entry.family').append('<label class="pending"><span>'+inputbox+'</span><strong>Pending</strong></label>');
					$('.txt_family').val('');

				},
						
				fail: function(response){
					//alert('Update Failed!');
				}
			});
		}
	}});


	$('.add_allergy').on({ 'click' : function(){
		var inputbox = $('.txt_allergy').val();
		var patient_id = $('body').data('patient_id');

		if( inputbox == '' || inputbox == ' ' ){
			Swal.fire({
			  type: 'error',
			  title: 'Oops...',
			  text: "You can't submit an empty field",
			  timer: 2000
			});
		}else{

			$.ajax({
				type: 'POST',
				url: 'process/submit_allergy.php',

				data: {
					inputbox:inputbox,
					patient_id:patient_id
				},

				beforeSend: function() {
					// Do Something
				},
				success: function(response) {

					Swal.fire({
						  type: 'success',
						  title: 'Submitted',
						  text: "Please wait for a doctor to approve your entry",
						  timer: 2000
					});

					$('.dynamical_entry.allergy').append('<label class="pending"><span>'+inputbox+'</span><strong>Pending</strong></label>');
					$('.txt_allergy').val('');

				},
						
				fail: function(response){
					//alert('Update Failed!');
				}
			});
		}
	}});
    

	$('.add_medication').on({ 'click' : function(){
		var inputbox = $('.txt_medication').val();
		var patient_id = $('body').data('patient_id');

		if( inputbox == '' || inputbox == ' ' ){
			Swal.fire({
			  type: 'error',
			  title: 'Oops...',
			  text: "You can't submit an empty field",
			  timer: 2000
			});
		}else{

			$.ajax({
				type: 'POST',
				url: 'process/submit_medication.php',

				data: {
					inputbox:inputbox,
					patient_id:patient_id
				},

				beforeSend: function() {
					// Do Something
				},
				success: function(response) {

					Swal.fire({
						  type: 'success',
						  title: 'Submitted',
						  text: "Please wait for a doctor to approve your entry",
						  timer: 2000
					});

					$('.dynamical_entry.medication').append('<label class="pending"><span>'+inputbox+'</span><strong>Pending</strong></label>');
					$('.txt_medication').val('');

				},
						
				fail: function(response){
					//alert('Update Failed!');
				}
			});
		}
	}});
    
    
	// Connection for Cardiowell
    $('body').on('click', '.cardiowell .blue.disconnected', function() {
        
		var swal_title = '';
        var machine = $(this).attr('data-machine');
        var patient_id = $('body').data('patient-id');
        
		if( machine == 'anyhub' ){
			swal_title = 'Connect your device using serial number';
		}else{
			swal_title = 'Connect your device using IMEI number';
		}

        Swal.fire({
            title: swal_title,
            allowOutsideClick: false,
            input: 'text',
            inputAttributes: {
                autocapitalize: 'off'
            },
            showCancelButton: true,
            confirmButtonText: 'Connect',
            showLoaderOnConfirm: true,
            
            preConfirm: (imei_number) => {
                
                $.ajax({
    				type: 'POST',
    				url: 'process/cardiowell-add-imei.php?machine='+machine,
    				data: {
    				    patient_id:patient_id,
    					imei_number:imei_number
    				},
    				beforeSend: function() {
    					// Do Something
    				},
    				success: function(response) {
                        
                        if( response.status_code == '200' ){
                            
                            if( machine == 'bp' ){
                                $('.cardiowell.bloodpressure .button').attr("data-imei", imei_number);
                                $('.cardiowell.bloodpressure .status').removeClass('disconnected');
                                $('.cardiowell.bloodpressure .status').addClass('connected');
                                $('.cardiowell.bloodpressure .status').html('Connected');
                               
                                $('.cardiowell.bloodpressure .button').removeClass('blue');
                                $('.cardiowell.bloodpressure .button').removeClass('disconnected');
                                $('.cardiowell.bloodpressure .button').addClass('red');
                                $('.cardiowell.bloodpressure .button').addClass('connected');
                                $('.cardiowell.bloodpressure .button').html('Disconnect and remove data');
                            }
                           
                            if( machine == 'weight' ){
                                $('.cardiowell.weighingscale .button').attr("data-imei", imei_number);
                                $('.cardiowell.weighingscale .status').removeClass('disconnected');
                                $('.cardiowell.weighingscale .status').addClass('connected');
                                $('.cardiowell.weighingscale .status').html('Connected');
                               
                                $('.cardiowell.weighingscale .button').removeClass('blue');
                                $('.cardiowell.weighingscale .button').removeClass('disconnected');
                                $('.cardiowell.weighingscale .button').addClass('red');
                                $('.cardiowell.weighingscale .button').addClass('connected');
                                $('.cardiowell.weighingscale .button').html('Disconnect and remove data');
                            }

							if( machine == 'anyhub' ){
								$('.cardiowell.anyhub .button').attr("data-imei", imei_number);
								$('.cardiowell.anyhub .status').removeClass('disconnected');
								$('.cardiowell.anyhub .status').addClass('connected');
								$('.cardiowell.anyhub .status').html('Connected');

								$('.cardiowell.anyhub .button').removeClass('blue');
								$('.cardiowell.anyhub .button').removeClass('disconnected');
								$('.cardiowell.anyhub .button').addClass('red');
								$('.cardiowell.anyhub .button').addClass('connected');
								$('.cardiowell.anyhub .button').html('Disconnect and remove data');
							}
                        
                        }else if( response.status_code == '403' ){
                            
                            Swal.fire({
                                icon: 'error',
                                title: 'Duplicate Entry',
                                text: 'The IMEI number('+imei_number+') is already registered with patient('+response.patient_fullname+'). Please disconnect the IMEI number first to proceed',
                            });
                            
                        }
                        
    				},
    				fail: function(response){
    				    // Do Something
    				}
    			});
                
            },
        })
         
    });
    
    
	// Disconnection for Cardiowell
    $('body').on('click', '.cardiowell .red.connected', function() {
        
		var swal_title = '';
        var machine = $(this).attr('data-machine');
        var patient_id = $('body').data('patient-id');
        var imei_number = $(this).data('imei');
        
		if( machine == 'anyhub' ){
			swal_title = 'Remove Serial Number?';
		}else{
			swal_title = 'Remove IMEI?';
		}

        Swal.fire({
            
            // title: 'Are you sure?',
            // text: "You won't be able to revert this!",
            // icon: 'warning',
            // showCancelButton: true,
            // confirmButtonColor: '#3085d6',
            // cancelButtonColor: '#d33',
            // confirmButtonText: 'Yes, delete it!'
            
            title: swal_title,
            text: "Do you want to remove the RPM device from this account?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Remove'
            
        }).then((result) => {
            if (result.value) {
                
                $.ajax({
    				type: 'POST',
    				url: 'process/cardiowell-remove-imei.php?machine='+machine,
    				//url: 'process/cardiowell-remove-imei-request.php',
    				data: {
    				    patient_id:patient_id,
    					imei_number:imei_number
    			    },
    			    beforeSend: function() {
    				    // Do Something
    			    },
        			success: function(response) {
                         
                        if( response.status_code == '200' ){
                            
                            if( machine == 'bp' ){
                                $('.cardiowell.bloodpressure .button').attr("data-imei", '');
                                $('.cardiowell.bloodpressure .status').addClass('disconnected');
                                $('.cardiowell.bloodpressure .status').removeClass('connected');
                                $('.cardiowell.bloodpressure .status').html('Disconnected');
                                   
                                $('.cardiowell.bloodpressure .button').addClass('blue');
                                $('.cardiowell.bloodpressure .button').addClass('disconnected');
                                $('.cardiowell.bloodpressure .button').removeClass('red');
                                $('.cardiowell.bloodpressure .button').removeClass('connected');
                                $('.cardiowell.bloodpressure .button').html('Connect and sync data');
                            }
                               
                            if( machine == 'weight' ){
                                $('.cardiowell.weighingscale .button').attr("data-imei", '');
                                $('.cardiowell.weighingscale .status').addClass('disconnected');
                                $('.cardiowell.weighingscale .status').removeClass('connected');
                                $('.cardiowell.weighingscale .status').html('Disconnected');
                                   
                                $('.cardiowell.weighingscale .button').addClass('blue');
                                $('.cardiowell.weighingscale .button').addClass('disconnected');
                                $('.cardiowell.weighingscale .button').removeClass('red');
                                $('.cardiowell.weighingscale .button').removeClass('connected');
                                $('.cardiowell.weighingscale .button').html('Connect and sync data');
                            }

							if( machine == 'anyhub' ){
								$('.cardiowell.anyhub .button').attr("data-imei", '');
								$('.cardiowell.anyhub .status').addClass('disconnected');
								$('.cardiowell.anyhub .status').removeClass('connected');
								$('.cardiowell.anyhub .status').html('Disconnected');
								   
								$('.cardiowell.anyhub .button').addClass('blue');
								$('.cardiowell.anyhub .button').addClass('disconnected');
								$('.cardiowell.anyhub .button').removeClass('red');
								$('.cardiowell.anyhub .button').removeClass('connected');
								$('.cardiowell.anyhub .button').html('Connect and sync data');
							}
                            
                        }
                            
        			},
        			fail: function(response){
        				// Do Something
        			}
    		    });
            }
        });
        
    });


	// Connection for Anyhub
	/*
	$('body').on('click', '.anyhub .blue.disconnected', function() {
        
        var machine = $(this).attr('data-machine');
        var patient_id = $('body').data('patient-id');
        
        Swal.fire({
            title: 'Connect your device using imei number',
            allowOutsideClick: false,
            input: 'text',
            inputAttributes: {
                autocapitalize: 'off'
            },
            showCancelButton: true,
            confirmButtonText: 'Connect',
            showLoaderOnConfirm: true,
            
            preConfirm: (imei_number) => {
                
                $.ajax({
    				type: 'POST',
    				url: 'process/cardiowell-add-imei.php?machine='+machine,
    				data: {
    				    patient_id:patient_id,
    					imei_number:imei_number
    				},
    				beforeSend: function() {
    					// Do Something
    				},
    				success: function(response) {
                        
                        if( response.status_code == '200' ){
                            
                            if( machine == 'bp' ){
                                $('.cardiowell.bloodpressure .button').attr("data-imei", imei_number);
                                $('.cardiowell.bloodpressure .status').removeClass('disconnected');
                                $('.cardiowell.bloodpressure .status').addClass('connected');
                                $('.cardiowell.bloodpressure .status').html('Connected');
                               
                                $('.cardiowell.bloodpressure .button').removeClass('blue');
                                $('.cardiowell.bloodpressure .button').removeClass('disconnected');
                                $('.cardiowell.bloodpressure .button').addClass('red');
                                $('.cardiowell.bloodpressure .button').addClass('connected');
                                $('.cardiowell.bloodpressure .button').html('Disconnect and remove data');
                            }
                           
                            if( machine == 'weight' ){
                                $('.cardiowell.weighingscale .button').attr("data-imei", imei_number);
                                $('.cardiowell.weighingscale .status').removeClass('disconnected');
                                $('.cardiowell.weighingscale .status').addClass('connected');
                                $('.cardiowell.weighingscale .status').html('Connected');
                               
                                $('.cardiowell.weighingscale .button').removeClass('blue');
                                $('.cardiowell.weighingscale .button').removeClass('disconnected');
                                $('.cardiowell.weighingscale .button').addClass('red');
                                $('.cardiowell.weighingscale .button').addClass('connected');
                                $('.cardiowell.weighingscale .button').html('Disconnect and remove data');
                            }
                        
                        }else if( response.status_code == '403' ){
                            
                            Swal.fire({
                                icon: 'error',
                                title: 'Duplicate Entry',
                                text: 'The IMEI number('+imei_number+') is already registered with patient('+response.patient_fullname+'). Please disconnect the IMEI number first to proceed',
                            });
                            
                        }
                        
    				},
    				fail: function(response){
    				    // Do Something
    				}
    			});
                
            },
        })
         
    });
	*/
    
}); // End of Jquery