<?php
    session_start();
    if(!isset($_SESSION['userid']) || !isset($_SESSION['userType']) || $_SESSION['userType'] != 'nurse') {
        header("Location: provider_login.php");
        die();
    }
    date_default_timezone_set('America/Chicago');
    include('includes/database_include.php');
?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    
    
    
	<title>Nurse Messenger</title>

	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
	<link rel="stylesheet" type="text/css" href="assets/css/grid.css">
	<link rel="stylesheet" type="text/css" href="assets/css/chat-icon/flaticon.css">
	<link rel="stylesheet" type="text/css" href="assets/css/chat.css">
	<script src="/socket.io/socket.io.js"></script>
	
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
	<script type="text/javascript" src="assets/js/nurse_chat_2.js"></script>
	<script type="text/javascript">
	    var socket = io.connect('https://patient.ddxrx.com:8080', {secure: true});
        socket.on('chat', (data) => {
          console.log(data);
        });
        socket.emit('chat', 'test teest');
	</script>
</head>
<body data-provider-id="<?php echo $_SESSION['userid']; ?>">
    
    <!-- Search Doctor -->
    <div class="search-form-container">
        <div class="search-form">
            <h6>Invite Physician</h6>
            <ul class="physician-list">
                
            </ul>
        </div>
    </div>
    <!-- Search Doctor -->
    
    
	<!-- Chat Sidebar -->
	<div class="chat-sidebar">
		<div class="inner">
			
			<!-- List -->
			<div class="sidebar-list">
			    
			    <div class="button-controls">
        			<a href="javascript:;" class="button gray icon contacts"><i class="flaticon-contacts"></i></a>
        			<a href="javascript:;" class="button green icon messages"><i class="flaticon-comment"></i></a>
        			<div class="clear"></div>
			    </div>
			    
			    
			    <div class="innerList">
			        
			        <!-- Message List -->
    			    <ul class="messageList">
    			        <li>
    			            <i class="flaticon-user"></i>
    			            <div class="desc">
    			                <strong>Jonathan Cabato</strong>
    			                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
    			            </div>
    			        </li>
    			    </ul>
    			    <!-- Message List -->
    			    
			    </div>
			    
			</div>
			<!-- List -->
			

		</div>
	</div>
	<!-- Chat Sidebar -->

	<!-- Messenger -->
	<div class="messenger-container">
		<div class="inner">

			<!-- User Meta -->
			<div class="user-meta" data-user-id="">
			    <span class="status online"></span>
			    <h1>Jonathan Cabato</h1>
			    <ul class="controls">
			        <li class="add-physician"><a href="javascript:;"><i class="flaticon-followers"></i></a></li>
			        <li><a href="javascript:;"><i class="flaticon-video-camera camera"></i></a></li>
			    </ul>
			</div>
			<!-- User Meta -->
			
			<!-- Message List Container -->
			<div class="messageListContainer">
			
    			<ul class="message-list">
    			    <li>
    			        <div class="userAvatar"><i class="flaticon-user"></i></div>
    			        <div class="desc">
        			        <strong>Jonathan First</strong>
        			        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed at sapien et felis lacinia pellentesque vitae a mauris. Integer vehicula eleifend sodales. Maecenas orci nunc, ornare vitae convallis eu, condimentum vitae lorem.</p>
    			        </div>
    			        <div class="time">December 12, 2019</div>
    			        <div class="clear"></div>
    			    </li>
    			</ul>
			
			</div>
			<!-- Message List Container -->
			
			<!-- Messenger Controls -->
    		<div class="messenger-controls-container">
    	        <div class="messengerTxtContainer"><textarea placeholder="Type a message" id="messageBlock"></textarea></div>
    		    <a href="javascript:;" class="send-message"><span><i class="flaticon-send"></i></span></a>
    		    <div class="clear"></div>
    		</div>
    			<!-- Messenger Controls -->
			
			<div class="clear"></div>
			
		</div>
	</div>
	<!-- Messenger -->

	<div class="clear"></div>

</body>
</html>