<?php

    // Require Global Config File for Getting Asset Version 
    require_once "config.php";


    session_start();
    if(!isset($_SESSION['userid']) || !isset($_SESSION['userType']) || $_SESSION['userType'] != 'nurse') {
        header("Location: provider_login.php");
        die();
    }
    
    date_default_timezone_set('America/Chicago');
    include('includes/database_include.php');

?>

<!DOCTYPE html>
<html>
<head>
    
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    
    
	<title>Nurse Messenger</title>

	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
	<link rel="stylesheet" type="text/css" href="assets/css/grid.css">
	<link rel="stylesheet" type="text/css" href="assets/css/chat-icon/flaticon.css">
	<link rel="stylesheet" type="text/css" href="assets/css/chat-icon/v2/flaticon-2.css">
	<link rel="stylesheet" type="text/css" href="assets/css/chat.css">
	
	<style>
	    #google_translate_element {
            position: static!important;
        }
        
        /* Remove G Icon on google translate */
        .goog-te-gadget-icon{
          display:none!important;
        }
        .goog-te-gadget-simple .goog-te-menu-value:hover{
            font-weight:500;
        }
        
        /* Google Translation */
        .goog-te-banner-frame.skiptranslate {
            display: none !important;
        }
        #goog-gt-tt{
            display:none!important;
        }
        .goog-te-gadget .goog-te-combo {
            margin: 0;
            border: none;
            color: #666 !important;
            border-radius: 50px; padding: 5px 0px 5px 35px;
            background: #fff;
            -moz-appearance: none;
            appearance: none;
            -webkit-appearance: none;
        }
        .goog-te-gadget {
            color:transparent!important;
        }
        #:0.targetLanguage {
            color: #666;
        }
        .skiptranslate.goog-te-gadget span {
            display:none;
        }
        .skiptranslate.goog-te-gadget span a {
            display:none;
        }
                
        #google_translate_element{
            position: static!important;
        }
        .goog-te-gadget .goog-te-combo{
            width: 100%!important;
            margin: 0px!important;
            padding:15px!important;
            border-radius: 0px!important;
            outline: none!important;
            border-bottom: 1px solid #DDDDDD;
        }
    </style>
	
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
	<script type="text/javascript" src="assets/js/jquery.tap.js"></script>
	<script type="text/javascript" src="assets/js/nurse_chat.js<?php echo getAssetVersion(); ?>"></script>
    
    <script type="text/javascript">
    function googleTranslateElementInit() {
        new google.translate.TranslateElement({pageLanguage: 'en', 
        layout:     google.translate.TranslateElement.InlineLayout.VERTICAL,
        autoDisplay: false, 
        includedLanguages: ''}, 'google_translate_element');}
    </script>
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
    
</head>
<body data-provider-id="<?php echo $_SESSION['userid']; ?>">
    
    <div id="google_translate_element"></div>
    
    <!-- Search Doctor -->
    <div class="search-form-container">
        <div class="search-form">
            
            <a href="javascript:;" class="close">x</a>
            
            <h6>Invite Physician</h6>
            
            <ul class="physician-list"></ul>
            
        </div>
    </div>
    <!-- Search Doctor -->
    
    
	<!-- Chat Sidebar -->
	<div class="chat-sidebar">
		<div class="inner">
			
			<!-- List -->
			<div class="sidebar-list">
			    
			    <div class="button-controls">
                    <!--
			        <a href="javascript:;" class="button gray icon contacts-nurse">
			            <i class="flaticon-2-nurse" style="font-weight: 500"></i>
			            <span>Nurse<strong> Directory</strong></span>
			        </a>
			        
        			<a href="javascript:;" class="button gray icon contacts">
        			    <i class="flaticon-contacts"></i>
        			    <span>Patient<strong> Directory</strong></span>
        			</a>
        			-->
        			
        			<a href="javascript:;" class="button green icon messages">
        			    <i class="flaticon-comment"></i>
        			    <span><strong>Active </strong>Chat</span>
        			</a>
        			
        			<div class="clear"></div>
			    </div>
			    
			    
			    <div class="innerList">
			        
			        <!-- Message List -->
    			    <ul class="messageList">
    			    </ul>
    			    <!-- Message List -->
    			    
			    </div>
			    
			</div>
			<!-- List -->
            
		</div>
	</div>
	<!-- Chat Sidebar -->

	<!-- Messenger -->
	<div class="messenger-container">
		<div class="inner">

			<!-- User Meta -->
			<div class="user-meta" data-user-id="">
			    <!--<span class="status online"></span>-->
			    <h1></h1>
			    <ul class="controls">
			        <li class="add-physician" data-count="1"><a href="javascript:;"><i class="flaticon-followers"></i></a></li>
			        <li><a href="javascript:;"><i class="flaticon-video-camera camera"></i></a></li>
			    </ul>
			</div>
			<!-- User Meta -->
			
			<!-- Message List Container -->
			<div class="messageListContainer">
			
    			<ul class="message-list">
    			    <li><center><h6>No Recent Message</h6><p>Select message on the left to start sending messages</p></center></li>
    			</ul>
			
			</div>
			<!-- Message List Container -->
			
			<!-- Messenger Controls -->
    		<div class="messenger-controls-container">
    	        <div class="messengerTxtContainer"><textarea placeholder="Type a message" id="messageBlock"></textarea></div>
    	        
    		    <a href="javascript:;" id="send_message" class="send-message"><span><i class="flaticon-send"></i></span></a>
    		    <a href="nurse_default.php" class="close-message"><span><i class="flaticon-2-add"></i></span></a>
    		    
    		    <div class="clear"></div>
    		</div>
    			<!-- Messenger Controls -->
			
			<div class="clear"></div>
			
		</div>
	</div>
	<!-- Messenger -->

	<div class="clear"></div>

</body>

<script>
    var send_message = document.getElementById("messageBlock");
        send_message.addEventListener("keyup", function(event) {
            
            // Update by THS:: April 14,2021
            if (event.keyCode === 13 && (event.shiftKey == false && event.ctrlKey==false && event.altKey==false)) {
                event.preventDefault();
                
                document.getElementById("send_message").click();
            }
            
        });
</script>
</html>