<?php

// Include functions
include('functions.php');

// Start the session
session_start();

// Check if the login_session key exists in $_SESSION
if (isset($_SESSION['login_session']) && !empty($_SESSION['login_session'])) {
    // Set session variables
    $session = $_SESSION['login_session'];

    if (isset($session['username'])) {
        // Do something with $session['username']
    }
} else {
    // Handle the case where the login_session key doesn't exist in $_SESSION
}

if( isset($session['username']) ){
    header('Location: index.php');
}

// Add header
$settings = array(
    'title' => 'Login to chat',
    'css' => array('forms.css'),
    'js_external' => array(
        'https://cdn.jsdelivr.net/npm/sweetalert2@11'
    ),
    'js' => array(
        'forms.js'
    ),
    'disable_style' => true,
);
get_header($settings);

?>



    <!-- Form -->
    <div class="mt-50">
        <div class="formWrapper">
            <div class="form-container login small">
                <div class="inner">
                    
                    <form class="login-form" method="POST" action="process/checklogin.php">
                        <label>
                            <span>Username</span>
                            <input type="text" class="textbox username" placeholder="Enter Login username">
                        </label>
                        
                        <label>
                            <span>Password</span>
                            <input type="password" class="textbox password" placeholder="Enter Password">
                        </label>
                        
                        <input type="submit" class="submitBtn" value="Login">
                        <a href="create-account.php" class="submitBtn create-account">Create Account</a>
                        <a href="forgot-password" class="forgotpassword">Forgot Password?</a>
                    </form>
                    
                </div>
            </div>
        </div>
    </div>
    <!-- Form -->
        
<?php get_footer(); ?>