<!DOCTYPE html>
<html>
    <head>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <!--<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">-->
        <style>
        /**
         * The CSS shown here will not be introduced in the Quickstart guide, but shows
         * how you can use CSS to style your Element's container.
         */
        .StripeElement {
          box-sizing: border-box;
        
          height: 40px;
        
          padding: 10px 12px;
        
          border: 1px solid transparent;
          border-radius: 4px;
          background-color: white;
        
          box-shadow: 0 1px 3px 0 #e6ebf1;
          -webkit-transition: box-shadow 150ms ease;
          transition: box-shadow 150ms ease;
        }
        
        .StripeElement--focus {
          box-shadow: 0 1px 3px 0 #cfd7df;
        }
        
        .StripeElement--invalid {
          border-color: #fa755a;
        }
        
        .StripeElement--webkit-autofill {
          background-color: #fefde5 !important;
        }

        .StripeElement {
          height: 40px;
          padding: 10px 12px;
        
          color: #32325d;
          background-color: white;
          border: 1px solid transparent;
          border-radius: 4px;
        
          box-shadow: 0 1px 3px 0 #e6ebf1;
          -webkit-transition: box-shadow 150ms ease;
          transition: box-shadow 150ms ease;
        }
        
        .StripeElement--focus {
          box-shadow: 0 1px 3px 0 #cfd7df;
        }
        
        .StripeElement--invalid {
          border-color: #fa755a;
        }
        
        .StripeElement--webkit-autofill {
          background-color: #fefde5 !important;
        }
        button {
          border: none;
          border-radius: 4px;
          outline: none;
          text-decoration: none;
          color: #fff;
          background: #32325d;
          white-space: nowrap;
          display: inline-block;
          height: 40px;
          line-height: 40px;
          padding: 0 14px;
          box-shadow: 0 4px 6px rgba(50, 50, 93, .11), 0 1px 3px rgba(0, 0, 0, .08);
          border-radius: 4px;
          font-size: 15px;
          font-weight: 600;
          letter-spacing: 0.025em;
          text-decoration: none;
          -webkit-transition: all 150ms ease;
          transition: all 150ms ease;
          float: left;
          margin-left: 12px;
          margin-top: 28px;
        }
        
        button:hover {
          transform: translateY(-1px);
          box-shadow: 0 7px 14px rgba(50, 50, 93, .10), 0 3px 6px rgba(0, 0, 0, .08);
          background-color: #43458b;
        }
        </style>
    </head>
    <body><!-- Load Stripe.js on your website. -->
        <script src="https://js.stripe.com/v3/"></script>
        <form action="/create_subscription.php" method="post" id="payment-form">
          <div class="form-row inline">
            <div class="col">
              <label for="name">
                Name
              </label>
              <input id="name" name="name" placeholder="Jenny Rosen" required>
            </div>
            <div class="col">
              <label for="email">
                Email Address
              </label>
              <input id="email" name="stripeEmail" type="email" placeholder="jenny.rosen@example.com" required>
            </div>
          </div>
        
          <div class="form-row">
            <label for="iban-element">
              Credit or debit card
            </label>
            <div id="card-element">
              <!-- A Stripe Element will be inserted here. -->
            </div>
          </div>
        
          <button>Submit Payment</button>
        
          <!-- Used to display form errors. -->
          <div id="error-message" role="alert"></div>
        </form>
        <script>
            // Create a Stripe client.
            var stripe = Stripe('pk_test_vtuAOjwWO0WKTGxkW8isBtqJ000WWmMHkW');
            
            // Create an instance of Elements.
            var elements = stripe.elements();
            
            // Custom styling can be passed to options when creating an Element.
            // (Note that this demo uses a wider set of styles than the guide below.)
            var style = {
              base: {
                color: '#32325d',
                fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
                fontSmoothing: 'antialiased',
                fontSize: '16px',
                '::placeholder': {
                  color: '#aab7c4'
                }
              },
              invalid: {
                color: '#fa755a',
                iconColor: '#fa755a'
              }
            };
            
            // Create an instance of the card Element.
            var card = elements.create('card', {style: style});
            
            // Add an instance of the card Element into the `card-element` <div>.
            card.mount('#card-element');
            
            // Handle real-time validation errors from the card Element.
            card.addEventListener('change', function(event) {
              var displayError = document.getElementById('card-errors');
              if (event.error) {
                displayError.textContent = event.error.message;
              } else {
                displayError.textContent = '';
              }
            });
            
            // Handle form submission.
            var form = document.getElementById('payment-form');
            form.addEventListener('submit', function(event) {
              event.preventDefault();
            
              stripe.createToken(card).then(function(result) {
                if (result.error) {
                  // Inform the user if there was an error.
                  var errorElement = document.getElementById('card-errors');
                  errorElement.textContent = result.error.message;
                } else {
                  // Send the token to your server.
                  stripeTokenHandler(result.token);
                }
              });
            });
            
            // Submit the form with the token ID.
            function stripeTokenHandler(token) {
              // Insert the token ID into the form so it gets submitted to the server
              var form = document.getElementById('payment-form');
              var hiddenInput = document.createElement('input');
              hiddenInput.setAttribute('type', 'hidden');
              hiddenInput.setAttribute('name', 'stripeToken');
              hiddenInput.setAttribute('value', token.id);
              form.appendChild(hiddenInput);
            
              // Submit the form
              form.submit();
            }
        </script>
    </body>
<html>