<?php
    
    session_start();
    if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
        header("Location: provider_login.php");
        die();
    }
    date_default_timezone_set('America/Chicago');
    
    // Include the functions file
    include('process/functions.php');

    // Check if the session has expired
    checkSessionTimeout();

    // Get patient and note data from database using note id parameter
    $note_id = $_GET['note_id'];

    // Single query with joins to get note and patient data
    $sql = "SELECT 
        nd.id,
        nd.dictation_id,
        nd.patient_id,
        nd.provider_id,
        nd.message,
        nd.date,
        nd.patient_name,
        nd.provider_name,
        p.patient_fname,
        p.patient_lname,
        p.patient_dob,
        ph.physician_fname,
        ph.physician_lname
    FROM notes_dictation nd
    LEFT JOIN patients p ON nd.patient_id = p.patient_id
    LEFT JOIN physician ph ON nd.provider_id = ph.user_id
    WHERE nd.id = '$note_id'";

    // Execute query and get result
    $result = mysqli_query(ddxrxDBConnect(), $sql);
    $note = mysqli_fetch_assoc($result);

    // Check if note exists
    if(!$note) {
        header("Location: dictation-notes.php");
        die();
    }

    $note_date = date('F j, Y', strtotime($note['date']));
    $note_content = $note['message'];

    // Get patient name using joined data instead of function calls
    if( $note['patient_name'] != 'none' ){
        $fullname = decryptAES($note['patient_name']);
    }else{
        if( $note['patient_id'] != '0' && !empty($note['patient_fname']) && !empty($note['patient_lname']) ){
            $fullname = $note['patient_fname'] . ' ' . $note['patient_lname'];
        }else{
            $fullname = 'N/A';
        }
    }

    // Query to get all AI notes for this dictation note
    $sql = "SELECT * FROM `notes_dictation_ai` WHERE `dictation_id` = '$note_id' ORDER BY `created` DESC LIMIT 6";

    // Execute query and get result, use a unique result variable name to avoid conflict
    $ai_result = mysqli_query(ddxrxDBConnect(), $sql);

?>
<html>
    <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        
        <meta name="viewport" content="width=device-width, initial-scale=1">
        
        <title>Dictation Notes</title>
        
        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="assets/css/style.css">
        <link rel="stylesheet" type="text/css" href="assets/css/dashboard_responsive.css">
        <link rel="stylesheet" type="text/css" href="assets/css/top-bar.css">
        <link rel="stylesheet" type="text/css" href="assets/css/jquery-liveedit.css">
        <link rel="stylesheet" type="text/css" href="assets/css/jquery.bxslider.min.css">
	    <link rel="stylesheet" type="text/css" href="assets/css/vitals_history.css">
        <link rel="stylesheet" type="text/css" href="assets/css/dictation-notes.css">
        
        
        <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>        
        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script type="text/javascript" src="https://kit.fontawesome.com/e424c30ea6.js" crossorigin="anonymous"></script>
        <script type="text/javascript" src="assets/js/jquery-liveedit.js"></script>
        <script type="text/javascript" src="assets/js/faq.js"></script>
        <script type="text/javascript" src="assets/js/jquery.bxslider.min.js"></script>
        <script type="text/javascript" src="assets/js/dictation-list.js"></script>

    </head>
    <body class="patien-data-table dashboard-area" data-dictation-note-id="<?php echo $_GET['note_id']; ?>">

        <!-- Header -->
        <div class="header">
            
            <div class="container">
                <div class="col-md-12">
                    <div class="patient-info">
                        <h3 class="tabtitle">Dictation Notes</h3>
                        <div class="clear"></div>
                    </div>
                </div>
            </div>
            
            <?php if($_SESSION['userType'] == 'nurse' || $_SESSION['userType'] == 'doctor'){ ?>
                <div class="menu-container">
                    <div class="container">
                        <div class="col-md-12">
                        <ul class="dashboard-nav fix">
                            <li><a href="nurse_default.php">Home</a></li>
                            <li><a href="dashboard.php">Diagnosis</a></li>
                            <li class="current"><a href="dictation-notes.php">Dictation Notes</a></li>
                            <li><a href="vitals_dashboard.php">RPM</a></li>
                            <li><a href="ccm_dashboard.php">CCM</a></li>
                        </ul>
                        </div>
                    </div>
                </div>
            <?php } ?>
            
        </div>
        <!-- Header -->

        <!-- Start Dictation Notes Container -->
        <div class="container">
            <div class="col-md-12">

                <div class="single-dictation">

                    <div class="title-bar">
                        <span><?php echo $note_date; ?></span>
                        <h1><?php echo $fullname; ?></h1>
                    </div>

                    <div class="inner <?php if( $ai_result && mysqli_num_rows($ai_result) <= 0) { echo 'full'; } ?>">

                        <!-- Editor -->
                        <div class="item txtEditor">
                            <div class="editor-container">

                                <article class="live-edit" data-model="article" data-id="1" data-url="/articles">
                                    <div class="editable-section" data-editable="false" data-name="content" data-text-options="false">
                                        <?php echo $note_content; ?>
                                    </div>
                                    <div class="original-note" style="display: none"><?php echo $note_content; ?></div>
                                </article>

                                <article class="ai-generated" data-model="article" data-id="1" data-url="/articles" style="display: none">
                                    <div class="editable-section" data-editable="true" data-name="content" data-text-options="true"></div>
                                </article>

                            </div>

                            <?php if($_SESSION['userType'] == 'nurse' || $_SESSION['userType'] == 'doctor'){ ?>
                                <div class="editor-controls">
                                
                                    <div class="left">
                                        <button class="button tooltip" id="edit-note" data-tooltip="Edit the original dictation note">Edit</button>
                                        <button class="button tooltip" id="update-note" data-tooltip="Update the original dictation note">Save</button>
                                        <button class="button tooltip alert cancel" id="cancel-edit" data-tooltip="Cancel editing">Cancel</button>
                                        <!-- <button class="button alert delete tooltip" id="delete-note" data-tooltip="Once deleted, it can't be reversed">Delete</button> -->
                                    </div>

                                    <div class="right">
                                        <button class="button ai-enhance tooltip" id="ai-enhance" data-tooltip="Enhance note with A.I">AI Note</button>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                        <!-- Editor -->
                        
                        <?php if ($ai_result) { ?>
                            <?php if(mysqli_num_rows($ai_result) > 0) { ?>
                                <!-- Sidebar -->
                                <div class="item sidebar">
                                    <div class="entry-list">
                                        <h6 class="sidebar-title">Auto Saved Notes</h6>
                                        <div class="items">
                                            <ul>
                                                <?php
                                                while($ai_note = mysqli_fetch_assoc($ai_result)) {
                                                    $ai_note_date = date('F j, Y - h:i A', strtotime($ai_note['created']));
                                                    $ai_note_content = $ai_note['note'];
                                                    // Note remove HTML tags
                                                    $ai_note_content = strip_tags($ai_note_content);

                                                    // Limit note content to 100 characters
                                                    if(strlen($ai_note_content) > 100) {
                                                        $ai_note_content = substr($ai_note_content, 0, 100) . '...';
                                                    }else {
                                                        $ai_note_content = $ai_note_content;
                                                    }

                                                    echo '
                                                        <li data-ai-note-id="'.$ai_note['id'].'">
                                                            <span>' . $ai_note_date . '</span>
                                                            <h6>' . $ai_note_content . '</h6>
                                                            <div class="complete-note" style="display: none">'.$ai_note['note'].'</div>
                                                        </li>
                                                    ';
                                                }
                                                ?>
                                            </ul>
                                        </div>

                                    </div>
                                </div>
                                <!-- Sidebar -->
                            <?php } ?>
                        <?php } ?>

                    </div>

                </div>
            </div>
        </div>
        <!-- End Dictation Notes Container -->
        
        <?php provider_bottom_nav(); ?>

    </body>
</html>