<?php
    
    /**
     * DEPENDENCIES
     * - functions.php
     * - provider_login.php
     * - provider_bottom_nav.php
     * - dictation-notes-view.php
     * - dictation-notes-hallucinations.php
     * 
     * NOTE: This is used by installer and browser
     */

    session_start();
    if(!isset($_SESSION['userid']) || !isset($_SESSION['userType']) || ($_SESSION['userType'] != 'nurse' && $_SESSION['userType'] != 'doctor')) {
        header("Location: provider_login.php");
        die();
    }
    // if(!isset($_SESSION['userid']) || !isset($_SESSION['userType']) || $_SESSION['userType'] != 'nurse' || $_SESSION['userType'] != 'doctor') {
    //     header("Location: provider_login.php");
    //     die();
    // }
    date_default_timezone_set('America/Chicago');
    
    // Include the functions file
    include('process/functions.php');

    // Check if the session has expired
    checkSessionTimeout();
    
?>
<html>
    <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        
        <meta name="viewport" content="width=device-width, initial-scale=1">
        
        <title>Dictation Notes</title>
        
        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="assets/css/style.css">
        <link rel="stylesheet" type="text/css" href="assets/css/dashboard_responsive.css">
        <link rel="stylesheet" type="text/css" href="assets/css/top-bar.css">
        <link rel="stylesheet" type="text/css" href="assets/css/jquery.bxslider.min.css">
	    <link rel="stylesheet" type="text/css" href="assets/css/vitals_history.css">
        <link rel="stylesheet" type="text/css" href="assets/css/dictation-notes.css">
        
        
        <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>        
        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script type="text/javascript" src="https://kit.fontawesome.com/e424c30ea6.js" crossorigin="anonymous"></script>
        <script type="text/javascript" src="assets/js/faq.js"></script>
        <script type="text/javascript" src="assets/js/jquery.bxslider.min.js"></script>
        <script type="text/javascript" src="assets/js/dictation-list.js"></script>
        
    </head>
    <body class="patien-data-table dashboard-area">
        
        <!-- Header -->
        <div class="header">
            
            <div class="container">
                <div class="col-md-12">
                    <div class="patient-info">
                        <h3 class="tabtitle">Dictation Notes</h3>
                        <div class="clear"></div>
                    </div>
                </div>
            </div>
            
            <div class="menu-container">
                <div class="container">
                    <div class="col-md-12">
                    <ul class="dashboard-nav fix">
                        <li><a href="nurse_default.php">Home</a></li>
                        <li><a href="dashboard.php">Diagnosis</a></li>
                        <li class="current"><a href="dictation-notes.php">Dictation Notes</a></li>
                        <li><a href="vitals_dashboard.php">RPM</a></li>
                        <li><a href="ccm_dashboard.php">CCM</a></li>
                    </ul>
                    </div>
                </div>
            </div>
            
        </div>
        <!-- Header -->

        <!-- Start Dictation Notes Container -->
        <div class="container">
            <div class="col-md-12">

                <ul class="dictation-nav">
                    <li><a href="dictation-notes.php" class="active">Dictation</a></li>
                    <li><a href="dictation-notes-hallucinations.php">Hallucinations</a></li>
                </ul>

                <div class="dictation-notes full">

                    <?php

                    // Get the current version
                    $version = get_version();

                    // Query to get the latest note for each patient with joins to avoid function calls
                    $sql = "SELECT 
                        nd.id,
                        nd.dictation_id,
                        nd.patient_id,
                        nd.provider_id,
                        nd.message,
                        nd.date as note_date,
                        nd.patient_name,
                        nd.provider_name,
                        p.patient_fname,
                        p.patient_lname,
                        p.patient_dob as dob,
                        ph.physician_fname,
                        ph.physician_lname
                    FROM notes_dictation nd
                    LEFT JOIN patients p ON nd.patient_id = p.patient_id
                    LEFT JOIN physician ph ON nd.provider_id = ph.user_id
                    WHERE nd.group_id = '$version'
                    ORDER BY nd.date DESC";
                    
                    $result = ddxrxDBConnect()->query($sql); // Execute the query

                    // Store hex color codes in an array
                    $colors = array(
                        'a' => '#e870be',
                        'b' => '#70d4e8',
                        'c' => '#70e8de',
                        'd' => '#70e8dc',
                        'e' => '#e89870',
                        'f' => '#e87070',
                        'g' => '#e8708e',
                        'h' => '#e8a670',
                        'i' => '#70e872',
                        'j' => '#9FE870',
                        'k' => '#70e8bc',
                        'l' => '#7088e8',
                        'm' => '#7074e8',
                        'n' => '#e8d470',
                        'o' => '#e870da',
                        'p' => '#70b0e8',
                        'q' => '#c670e8',
                        'r' => '#e8707c',
                        's' => '#dc70e8',
                        't' => '#cee870',
                        'u' => '#8e70e8',
                        'v' => '#e8707c',
                        'w' => '#90e870',
                        'x' => '#70e8bc',
                        'y' => '#e870be',
                        'z' => '#9FE870'
                    );

                    // Check if there are any notes
                    if ($result->num_rows > 0) {

                        // output data of each row
                        while($row = $result->fetch_assoc()) {

                            $note_owner = $row['patient_name'];
                            $note_date = !empty($row['note_date']) ? $row['note_date'] : 'N/A';
                            $note_text = !empty($row['message']) ? $row['message'] : 'N/A';
                            $patient_birthdate = !empty($row['dob']) ? $row['dob'] : 'N/A';
                            $readMore = '<a href="dictation-notes-view.php?note_id='.$row['id'].'" class="open-note">Open Note <i class="fa-solid fa-arrow-up-right-from-square"></i></a>';

                            // Filter out the elements
                            $note_text = str_replace('<h3 contenteditable="false">Progress Note:</h3>', '', $note_text);
                            $note_text = str_replace('<h3 contenteditable="false"> Progress Note:</h3>', '', $note_text);
                            $note_text = str_replace('<h3 contenteditable="false">Plan:</h3>', '', $note_text);
                            $note_text = str_replace('<h3 contenteditable="false"> Plan:</h3>', '', $note_text);
                            $expanded_note_text = $note_text;

                            // Limit note text to 100 characters
                            if (strlen($note_text) > 300) {
                                $note_text = '<div id="compressed_note_'.$row['id'].'" class="previewText compressed">'.substr($note_text, 0, 300) . '... <a href="#" class="more" data-note-id="'.$row['id'].'">Read More</a></div>'.$readMore;
                            }else{
                                $note_text = '<div class="previewText">'.$note_text.'</div>'.$readMore;
                            }

                            $expanded_note = '<div id="expanded_note_'.$row['id'].'" class="previewText expanded-note">'.$expanded_note_text.'</div>';

                            // Get color based on first letter of patient's name
                            $first_letter = strtolower(substr($note_owner, 0, 1));
                            $color = $colors[$first_letter];
                            
                            if( $row['patient_name'] != 'none' && $row['provider_name'] != 'none' ){
                                
                                $note_owner = decryptAES($row['patient_name']);
                                $provider_name = decryptAES($row['provider_name']);

                            }else{

                                // Use joined data instead of function calls
                                if( $row['provider_id'] != '0' && !empty($row['physician_fname']) && !empty($row['physician_lname']) ){
                                    $provider_name = $row['physician_fname'] . ' ' . $row['physician_lname'];
                                }else{
                                    $provider_name = 'N/A';
                                }

                                if( $row['patient_id'] != '0' && !empty($row['patient_fname']) && !empty($row['patient_lname']) ){
                                    $note_owner = $row['patient_fname'] . ' ' . $row['patient_lname'];
                                }else{
                                    $note_owner = 'N/A';
                                }

                            }

                            echo '
                            <div class="item">
                                <div class="bullet"><div class="point" style="background-color: '.$color.'"></div></div>
                                <div class="innerNote">
                                    <div class="note-info">
                                        <div class="patient"><div>'.$note_owner.'</div><span>'.$note_date.'</span></div>
                                        <div class="details">
                                        <div class="patient-info"><i class="fa-regular fa-clipboard"></i>Provider: '.$provider_name.'</div>
                                        </div>
                                    </div>
                                    <div class="note-text">
                                        '.$expanded_note.'
                                        '.$note_text.'
                                    </div>
                                </div>
                            </div>
                            ';
                        
                        }
                    } else { // No notes found
                        echo '<h1>No dictation notes found.</h1>';
                    }
                    ?>

                </div>
            </div>
        </div>
        <!-- End Dictation Notes Container -->
        
        <?php provider_bottom_nav(); ?>
        
    </body>
</html>