<?php
    ob_start();
    session_start();
    
    include('process/functions.php');
    include ('includes/database_include.php');
    include ('analytics.php');

    if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
        header("Location: ios-launch.php");
        die();
    }
    
    $patient_id = null;
    if(isset($_SESSION['userid']) && isset($_SESSION['patient_id'])) {
        $patient_id = $_SESSION['userid'];
    } else if($_SESSION['userType']!="patient" && isset($_GET['id']) ) {
        $patient_id = $_GET['id'];
    }
    
    $user_id = $_SESSION['userid'];
    //$sql = "SELECT * FROM patients WHERE patients.user_id = '$user_id'LIMIT 1;";
    $sql = "select patients.user_id, patients.patient_fname, patients.mname, patients.patient_lname, patients.patient_gender, patients.epic_id, patients.ssn, patients.cell, patients.profilepicture, patients.patient_dob, all_users.email_address, all_users.username FROM patients INNER JOIN all_users ON patients.user_id = all_users.userid WHERE patients.user_id = '$user_id'";
    $result = mysqli_query($con, $sql);
    $user = mysqli_fetch_assoc($result);

    // print_r($_SESSION);
    
    //echo var_dump( $_SESSION );
    
?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	
	<!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-148409281-5"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
    
      gtag('config', 'UA-148409281-5');
    </script>

	
	<title>AI Based Health Care - DDxRx.com</title>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
    <?php if( basename($_SERVER['REQUEST_URI']) == 'ios-launch.php' ){ include('header-ios-launch.php'); } ?>
    <?php if( basename($_SERVER['REQUEST_URI']) == 'search_dd.php' ){ include('header-search-dd.php'); } ?>

	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
	<link rel="stylesheet" type="text/css" href="assets/css/grid.css">
	<link rel="stylesheet" type="text/css" href="assets/css/style.css">
	<link rel="stylesheet" type="text/css" href="assets/css/responsive.css">
	<link rel="stylesheet" type="text/css" href="assets/css/mobile.css">
	<link rel="stylesheet" type="text/css" href="assets/css/top-bar.css">
	<link rel="stylesheet" type="text/css" href="assets/css/faq.css">
    
    <style>
        .required-field{
            -webkit-box-shadow: 0 0 0 5px #FFA8A8!important;
            box-shadow: 0 0 0 5px #FFA8A8!important;
        }
    </style>
    
	<script type="text/javascript" src="assets/js/jquery.min.js"></script>
	<script type="text/javascript" src="assets/js/base64converter.js"></script>
	<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
	<script type="text/javascript" src="assets/js/save_profile.js"></script>
	<script type="text/javascript" src="assets/js/phone-call.js"></script>
    
</head>
<body class="user-profile" data-user-id="<?php echo $patient_id; ?>">
    
    <?php top_nav(); ?>
    
    <div class="profile-container">

        <?php include('profile-heading.php'); ?>

        <div class="container">
            <div class="col-md-12">
                <div class="profile-inner">

                    <!-- Form Container -->
                    <div class="form-container">
                        
                        <h1 class="header">Edit User Profile</h1>

                        <div class="row">

                            <div class="col-md-4">
                                <label>
                                    <span>First Name</span>
                                    <input type="text" class="textbox patient_fname" name="" value="<?php echo $user['patient_fname']; ?>" placeholder="Enter your given first name">
                                </label>
                            </div>

                            <div class="col-md-4">
                                <label>
                                    <span>Middle Name</span>
                                    <input type="text" class="textbox mname" name="" value="<?php echo $user['mname']; ?>" placeholder="Enter Middle name">
                                </label>
                            </div>

                            <div class="col-md-4">
                                <label>
                                    <span>Last Name</span>
                                    <input type="text" class="textbox patient_lname" name="" value="<?php echo $user['patient_lname']; ?>" placeholder="Enter Last Name">
                                </label>
                            </div>

                            <div class="col-md-4">
                                <label>
                                    <span>Gender</span>
                                    <input type="text" class="textbox patient_gender" name="" value="<?php if( $user['patient_gender'] == 'm' ){ echo 'Male'; }elseif( $user['patient_gender'] == 'f' ){ echo 'Female'; } ?>" placeholder="Gender">
                                </label>
                            </div>

                            <div class="col-md-4">
                                <label>
                                    <span>Date of Birth</span>
                                    <input type="text" class="textbox patient_dob" name="" value="<?php echo $user['patient_dob']; ?>" placeholder="Ex. June/01/1988">
                                </label>
                            </div>

                            <div class="col-md-4">
                                <label>
                                    <span>Social Security Number ( Optional )</span>
                                    <input type="text" class="textbox ssn" name="" value="<?php echo $user['ssn']; ?>" placeholder="### ## ####">
                                </label>
                            </div>

                            <div class="col-md-12"><h1 class="header">Contact Information</h1></div>

                            <div class="col-md-4">
                                <label>
                                    <span>Mobile Phone</span>
                                    <input type="text" class="textbox cell" name="" value="<?php echo $user['cell']; ?>" placeholder="(###) ### ####">
                                </label>
                            </div>

                            <div class="col-md-4">
                                <label>
                                    <span>Email Address</span>
                                    <input type="text" class="textbox email_id" name="" value="<?php echo $user['email_address']; ?>" placeholder="Email Address">
                                </label>
                            </div>

                            <!-- Password Reset -->
                            <div class="col-md-12">
                                <h1 class="header">Security Options</h1>
                            </div>

                            <div class="col-md-4">
                                <label>
                                    <span>Username</span>
                                    <input type="text" class="textbox" name="" value="<?php echo $_SESSION['username']; ?>" style="cursor: not-allowed;" disabled>
                                </label>
                            </div>

                            <div class="col-md-4">
                                <label>
                                    <span>Password</span>
                                    <input type="password" class="textbox password" name="" value="">
                                </label>
                            </div>
                            

                            <div class="col-md-12">
                                <input type="submit" value="Save Changes" data-role="none" class="button update_record">
                            </div>


                        </div>
                    </div>
                    <!-- Form Container -->

                    <div class="clear"></div>
                </div>
            </div>
        </div>
    </div>

<?php //include('footer.php'); ?>
</body>
</html>