$(document).ready(function(){
    
    function randomString(length, chars) {
        var result = '';
        for (var i = length; i > 0; --i) result += chars[Math.floor(Math.random() * chars.length)];
        return result;
    }
    
    $('#provider_login').click(function(){
		var user = $('#user').val();
		var pass = $('#pass').val();
		var user_type = $('input[name=user_type]:checked').val();
        
		$.ajax({
			url: 'check_login.php',
			data : {'user': user, 'pass': pass, 'user_type': user_type},
			type: 'POST',
			dataType: 'json',
			success: function success(msg) {
				if(msg.success === true) {
					// alert(msg.msg);
					if(msg.userType == '2') {
						//window.location = "physician_dashboard.php";
						window.location = "physician_default.php";
					} else if(msg.userType == '4') {
						//window.location = "dashboard.php";
						window.location = "nurse_default.php";
					}
				} else {
					alert(msg.msg);
					return false;
				}
			},
			error: function error(msg) {
				alert(msg.msg);
				console.log('error:', msg);
			},
		});
    });
	
	$('#patient_login').click(function(){
	    
	    $('.loading-screen').fadeIn();
	    
		var user = $('#email').val();
		var pass = $('#password').val();
        
		$.ajax({
			url: '/check_login.php',
			data : {'user': user, 'pass': pass, 'user_type': 3},
			type: 'POST',
			dataType: 'json',
			success: function success(msg) {
				if(msg.success === true) {
					// alert(msg.msg);
                    var patient = {};
                    patient.idKey = randomString(32, '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ');
                    patient.checkInTime = Date.now();
                    $.ajax({
                        url: 'save_search_entry.php',
                        data: {'guid': patient.idKey},
                        type: 'POST',
                        dataType: 'json',
                        success: function success(msg) {
                            patient.waitingroom_id = msg.waitingroom_id;
                            localStorage.setItem("patient", JSON.stringify(patient));
					        //window.location = "/home_default.php";
					        //window.location.href = "/chat-bot.php";
					        window.location.href = "/default.php";
			
                        },
                        error: function error(msg) {
                            console.log('error');
                        },
                    });
				} else {
				    $('#login-content').show();
				    $('.disclaimer-popup-container').fadeOut();
				    $('.loading-screen').fadeOut();
				    
					//alert(msg.msg);
					Swal.fire({
                        icon: 'warning',
                        title: 'Invalid Login',
                        text: msg.msg,
                    });
					return false;
				}
			},
			error: function error(msg) {
				alert(msg.msg);
				console.log('error:', msg);
			},
		});
    });
    
    // Radio Button
    $('.login-container .radio-group label').click(function(){
        $('.login-container .radio-group label img').attr("src","assets/images/radio-gray.svg");
        $('img', this).attr("src","assets/images/radio-green.svg");
        $('input:radio[name="type"]', this).prop("checked", true);
    });
    
});