<?php
session_start();

// Include the functions file
include('process/functions.php');

// Check if the session has expired
checkSessionTimeout();

if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
    header("Location: provider_login.php");
    die();
}

$patient_id = null;

if(isset($_SESSION['userid']) && isset($_SESSION['patient_id'])) {
    
    $patient_id = $_SESSION['patient_id'];
    
} else if($_SESSION['userType']!="patient" && isset($_GET['id']) ) {
    
    $patient_id = $_GET['id'];
    
}

if($patient_id != null) {

	$sql = "SELECT * FROM patients WHERE patient_id = '$patient_id' LIMIT 1";
	$result = mysqli_query(ddxrxDBConnect(), $sql) or die('SQL Error :: '.mysqli_error());
	$user = mysqli_fetch_assoc($result);
	
    function get_all_diagnosis($patient_id) {

    	$sql = "SELECT * FROM medical WHERE patient_id = '$patient_id' ORDER BY status ASC";
    
    	$result = mysqli_query(ddxrxDBConnect(), $sql);
    
    	if (mysqli_num_rows($result) > 0) {

    	    // output data of each row
    	    $counter = 0;

    	    while($row = mysqli_fetch_assoc($result)) {
    
    	    	$counter++;
                
                if( $row["status"] == 'pending' ){
                    $status = '<span class="pending">(Pending)</span>';
                    $approve = '<strong class="approve" data-approve-id="'.$row["id"].'">Approve</strong>';
                }else{
                    $status = '';
                    $approve = '';
                }
                
    	        echo '<li data-diagnosis-id="'.$row["id"].'" class="data_diag_'.$counter.'" id="diagnosis_'.$row["id"].'">'.$row["diagnosis"].$status.'<img src="assets/images/delete-diagnosis.png" data-diagnosis-id="'.$row["id"].'">'.$approve.'</li>';
                
                
                
    	    }

    	} else {
    	    echo "<p>No History Yet</p>";
    	}

    }
    

    $patient_id = null;
    if(isset($_SESSION['userid']) && isset($_SESSION['patient_id'])) {
        $patient_id = $_SESSION['patient_id'];
    } else if($_SESSION['userType']!="patient" && isset($_GET['id']) ) {
        $patient_id = $_GET['id'];
    }
    ?>
    
    <!DOCTYPE html>
    <html  class="ui-mobile">
        <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <title>DDXRX Medical History</title>
            
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            
            <script type="text/javascript" src="assets/js/jquery-3.3.1.min.js"></script>
            <script type="text/javascript" src="assets/js/jquery.slicknav.js"></script>
            <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
            <script type="text/javascript" src="assets/js/process/history_medical.js"></script>
            <script type="text/javascript" src="assets/js/admin.js"></script>
            <script type="text/javascript" src="assets/js/init.js"></script>
            <script type="text/javascript" src="assets/js/general-ui.js"></script>
            <script type="text/javascript" src="assets/js/mobile.js"></script>
            <script type="text/javascript" src="assets/js/faq.js"></script>
            
            <script type="text/javascript" src="assets/js/autocomplete/jquery.autocomplete.min.js"></script>
            <script type="text/javascript" src="assets/js/autocomplete/jquery.validate.min.js"></script>
            <script type="text/javascript" src="assets/js/autocomplete/socket.io.js"></script>
            
            <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
            <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
            <link rel="stylesheet" type="text/css" href="assets/css/main-menu.css">
            <link rel="stylesheet" type="text/css" href="assets/css/slicknav.css">
            <link rel="stylesheet" type="text/css" href="assets/css/style.css">
            <link rel="stylesheet" type="text/css" href="assets/css/responsive.css">
            <link rel="stylesheet" type="text/css" href="assets/css/patient-records.css">
            <link rel="stylesheet" type="text/css" href="assets/css/general-ui.css">
            <link rel="stylesheet" type="text/css" href="assets/css/autocomplete.css">
            <link rel="stylesheet" type="text/css" href="assets/css/mobile.css">
            <link rel="stylesheet" type="text/css" href="assets/css/faq.css">
            <link rel="stylesheet" type="text/css" href="assets/css/autocomplete/jquery.autocomplete.css">
            
            <style>
            body{
                top: 0px!important;
            }
            .goog-te-banner-frame.skiptranslate {
                display: none !important;
            }
            #goog-gt-tt{
                display:none!important;
            }
            #google_translate_element{
                position: fixed; left:20px; top: 20px; z-index: 9999999;
            }
            </style>
            
            <script type="text/javascript">
            function googleTranslateElementInit() {
                new google.translate.TranslateElement({pageLanguage: 'en', 
                layout:     google.translate.TranslateElement.InlineLayout.VERTICAL,
                autoDisplay: false, 
                includedLanguages: ''}, 'google_translate_element');}
            </script>
            <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
            
            <!-- Global site tag (gtag.js) - Google Analytics -->
            <script async src="https://www.googletagmanager.com/gtag/js?id=UA-148409281-5"></script>
            <script>
              window.dataLayer = window.dataLayer || [];
              function gtag(){dataLayer.push(arguments);}
              gtag('js', new Date());
            
              gtag('config', 'UA-148409281-5');
            </script>
            
        </head>
        <body data-user-id="<?php echo $patient_id; ?>">
            
            <div class="loading-screen"></div>
            
            <div id="google_translate_element"></div>
            
            <?php //include('dashboard_menu.php'); ?>
            
            <div class="container pb-100 optimized-container"<?php if( isset($_GET['id']) ){ echo ' data-user="'.$_GET['id'].'"'; } ?>>
                <div class="col-md-12">
                    <div id="toPrint">
                        <div class="form-container">
    
                            <div class="record-navigation-menu">
                                <?php include('emr_navigation.php'); ?>
                            </div>
                            
                            <div class="tab-content-container card">
                                <!-- Diagnosis List -->
                                <div class="diaglosis-list-container">
                                    	<h6>Medical History</h6>
                                    	<ul data-base="medical">
                                    		<?php get_all_diagnosis($patient_id, ddxrxDBConnect()); ?>
                                    	</ul>
                                    </div>
                                <!-- Diagnosis List -->
                                    
                                <!-- Switch Button -->
                                <div class="transfer-container">
                                    	<div class="inner">
                                           <a href="javascript:;" class="transfer left" data-id="<?php if(isset($_GET['id'])){ echo $_GET['id']; } ?>">&nbsp;</a>
                                           <a href="javascript:;" class="transfer right" data-id="<?php if(isset($_GET['id'])){ echo $_GET['id']; } ?>">&nbsp;</a>
    				                    </div>
    			                    </div>
    		                    <!-- Switch Button -->
                                    
                                <!-- Search Diagnosis Container -->
    	                        <div class="search-diagnosis-container">
    	                            
    	                            <form id="formddX" name="formddX" method="post" action="ddx_reports.php" data-ajax="false" onsubmit="return search(event);">
    	                                
        	                            <label>
        	                                <span>Enter Diagnosis</span>
        	                                <input type="text" class="textbox search-1 search_symptom_qry symptoms_0" id="symptoms_0" placeholder="Type to search diagnosis">
        	                                <div class="search-result-container symptoms_0"><ul></ul></div>
        	                            </label>
        
        	                            <label>
        	                                <span>Enter Diagnosis</span>
        	                                <input type="text" class="textbox search-2 search_symptom_qry symptoms_1" id="symptoms_1" placeholder="Type to search diagnosis">
        	                                <div class="search-result-container symptoms_1"><ul></ul></div>
        	                            </label>
        
        	                            <label>
        	                                <span>Enter Diagnosis</span>
        	                                <input type="text" class="textbox search-3 search_symptom_qry symptoms_2" id="symptoms_2" placeholder="Type to search diagnosis">
        	                                <div class="search-result-container symptoms_2"><ul></ul></div>
        	                            </label>
        
        	                            <label>
        	                                <span>Enter Diagnosis</span>
        	                                <input type="text" class="textbox search-4 search_symptom_qry symptoms_3" id="symptoms_3" placeholder="Type to search diagnosis">
        	                                <div class="search-result-container symptoms_3"><ul></ul></div>
        	                            </label>
        
        	                            <label>
        	                                <span>Enter Diagnosis</span>
        	                                <input type="text" class="textbox search-5 search_symptom_qry symptoms_4" id="symptoms_4" placeholder="Type to search diagnosis">
        	                                <div class="search-result-container symptoms_4"><ul></ul></div>
        	                            </label>
        
        	                            <div class="dynamic_textbox"></div>
        
        	                            <div class="add-more-container">
        	                                <a href="javascript:;">+ Add Diagnosis</a>
        	                            </div>
        
        	                            <!--<a href="javascript:;" class="button search-button">Push to Search</a>-->
                                    
                                    </form>
                                    
    	                        </div>
                                <!-- Search Diagnosis Container -->
                            </div>
    
                        </div>
                    </div>
                </div>
                <div class="clear"></div>
            </div>
    
            <?php
                if( $_SESSION['userType'] == 'nurse' ){
                    provider_bottom_nav();
                }elseif( $_SESSION['userType'] == 'doctor' ){
                    physician_bottom_nav();
                }else{
                    bottom_nav();
                }
            ?>
            
            <script>
                $(document).ready(function () {
            
                    var data = "Chest Pain*Cough, Acute*Fever*Headache*Shortness Of Breath*Sore Throat*".split("*");
                    $( "body" ).on( "keyup", ".symptoms_search_box", function() {
                        $(this).autocomplete(data, {
                            mustMatch: false,
                            autoFill: false,
                            matchContains: "word",
                            max: "40",
                            scrollHeight: "400px"
                        });
                    });
                });
            </script>
            
        </body>
    </html>

<?php } ?>