<?php 
session_start();
if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
    header("Location: index.php");
    die();
}
if($_SESSION['userType'] != 'nurse' && $_SESSION['userType'] != 'doctor') {
    header("Location: view_record.php");
    die();
}

function checkEnrollmentStatus($patient_id) {
    // Connect to the database
    $conn = ddxrxDBConnect();
    
    // Check if connection is successful
    if (!$conn) {
        die("Database connection failed");
    }
    
    // Prepare SQL query
    $query = "SELECT * FROM cardiowell_users WHERE patient_id = ?";
    
    // Prepare statement
    $stmt = $conn->prepare($query);
    
    // Bind parameter
    $stmt->bind_param("i", $patient_id);
    
    // Execute statement
    $stmt->execute();
    
    // Get result
    $result = $stmt->get_result();
    
    // Check if any rows are returned
    if ($result->num_rows > 0) {
        // Patient is enrolled
        return "Enrolled";
    } else {
        // Patient is not enrolled
        return "Not Enrolled";
    }
    
    // Close statement and connection
    $stmt->close();
    $conn->close();
}

include('process/functions.php');
    
$version = get_version();
$patientsResult = mysqli_query(ddxrxDBConnect(), "SELECT * FROM patients where user_id!=0 and active=1 AND groupid = '$version' order by patient_id desc");

?>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <title>DDxRx::Electronic Medical Record (EMR)</title>

        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="assets/css/emr_list.css">
        <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css">
	
        <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
        <script type="text/javascript" src="//cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js"></script>
        <script type="text/javascript" src="assets/js/emr_datatable.js"></script>
        
    </head>
    <body>
        
    <div class="header">
        <div class="container">
            <div class="padded">
                <div class="patient-info">
                    <h3 class="tabtitle">Electronic Medical Records</h3>
                    <div class="clear"></div>
                </div>
            </div>
        </div>
    </div>

        <div class="container">
            <div class="TableContainer">
                <table id="emr_list">
                    <thead>
                        <tr>
                            <td><strong>Last Name</strong></td>
                            <td><strong>First Name </strong></td>
                            <td><strong>Date of Birth </strong></td>
                            <td><strong>Gender</strong></td>
                            <td><strong>Phone</strong></td>
                            <td><strong>RPM IMEI</strong></td>
                            <td><strong>Action</strong></td>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while($row = mysqli_fetch_array( $patientsResult )) { ?>
                        <tr>
                            <td><p><?PHP echo ucwords($row['patient_lname']);?></p></td>
                            <td><p><?PHP echo ucwords($row['patient_fname']);?></p></td>
                            <td><p><?PHP echo $row['patient_dob']?></p></td>
                            <td><p><?PHP echo $gender = ($row['patient_gender'] == 'm') ? 'Male' : 'Female'; ?></p></td>
                            <td><p><?PHP echo $phone = !empty($row['cell']) ? $row['cell'] : 'Not Provided'; ?></p></td>
                            <td><p><?PHP echo checkEnrollmentStatus($row['patient_id']); ?></p></td>
                            <td><a href="view_record.php?id=<?PHP echo $row['patient_id']?>&uid=<?PHP echo $row['user_id']?>&patient_id=<?PHP echo $row['patient_id']?>" class="button">View Patient</a></td>
                        </tr>
                    <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>

        <?php
                
            if( $_SESSION['userType'] == 'nurse' ){
                    
                provider_bottom_nav();
                    
            }elseif( $_SESSION['userType'] == 'doctor' ){
                    
                physician_bottom_nav();
                    
            }else{
                    
                bottom_nav();
                    
            }
        ?>
        
    </body>
</html>
