<?php

session_start();

include('process/functions.php');

if( isset($_GET['patient_id']) ){

    $patient_id = $_GET['patient_id'];

    // SQL query
    $sql = "SELECT * FROM `patients` WHERE `patient_id` = '$patient_id' LIMIT 1";

    // Initiate sql
    $result = ddxrxDBConnect()->query($sql);

    // Associative array
    $user = $result->fetch_assoc();

    // Free result set
    $result -> free_result();

    // Close connection
    ddxrxDBConnect()->close();

}else{

    $user = '';

}

/*
if( isset($_POST['unique_id']) ){

    $unique_id = $_POST['unique_id'];

    // SQL query
    $sql_physician = "SELECT * FROM `all_users` INNER JOIN physician ON physician.user_id = all_users.userid WHERE all_users.unique_id = '$unique_id';";

    // Initiate sql
    $result_p = ddxrxDBConnect()->query($sql_physician);

    // Associative array
    $physician = $result_p->fetch_assoc();

    // Free result set
    $result_p->free_result();

    // Close connection
    ddxrxDBConnect()->close();

}else{

    $physician = '';

}
*/

if( isset($_POST['unique_id']) ){

    $unique_id = $_POST['unique_id'];

    // Connect to the database
    $db = ddxrxDBConnect();

    // SQL query for physician
    $sql_physician = "SELECT * FROM `all_users` INNER JOIN physician ON physician.user_id = all_users.userid WHERE all_users.unique_id = '$unique_id';";
    $result_p = $db->query($sql_physician);
    $physician = $result_p->fetch_assoc();
    $result_p->free_result();

    if ($physician) {
        // If physician record found
        $provider = $physician;
        $provider_fname = $physician['physician_fname'];
        $provider_lname = $physician['physician_lname'];
        $provider_userid = $physician['user_id'];
    } else {
        // SQL query for nurse
        $sql_nurse = "SELECT * FROM `all_users` INNER JOIN nurse ON nurse.user_id = all_users.userid WHERE all_users.unique_id = '$unique_id';";
        $result_n = $db->query($sql_nurse);
        $nurse = $result_n->fetch_assoc();
        $result_n->free_result();

        if ($nurse) {
            // If nurse record found
            $provider = $nurse;
            $provider_fname = $nurse['nurse_fname'];
            $provider_lname = $nurse['nurse_lname'];
            $provider_userid = $nurse['user_id'];
        } else {
            // No record found
            $provider = '';
            $provider_type = '';
        }
    }

    // Close connection
    $db->close();

}else{

    $provider = '';
    $provider_type = '';

}

?>
    
    <!DOCTYPE html>
    <html  class="ui-mobile">
        <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <title>DDXRX - Order History</title>
            
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            
            <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>
            <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
            <script type="text/javascript" src="assets/js/jquery.jqscribble.js"></script>
            <script type="text/javascript" src="assets/js/pencil.js"></script>
    
            <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
            <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
            <link rel="stylesheet" type="text/css" href="assets/css/style.css">
            <link rel="stylesheet" type="text/css" href="assets/css/responsive.css">
            <link rel="stylesheet" type="text/css" href="assets/css/mobile.css">
            <link rel="stylesheet" type="text/css" href="assets/css/order-app.css">

        </head>
        <body class="<?php if (empty($_GET['patient_id']) || empty($user) || empty($provider)) { echo 'white-bg'; } ?>" <?php if (!empty($_GET['patient_id']) && !empty($user) && isset($user['user_id'])) { echo 'data-user-id="'.$user['user_id'].'"'; } ?> data-patient-id="<?php echo $_GET['patient_id']; ?>">

            <?php if( isset($_GET['patient_id']) && !empty($_GET['patient_id']) ){ // Check if patient id is set ?>

                <?php if( !empty($user) ){ // Check if the patient exists ?>

                    <?php if( isset($_POST['unique_id']) && !empty($_POST['unique_id']) ){ // Check if unique id is set ?>

                        <?php if( !empty($provider) ){ ?>

                        <div class="container pb-100 optimized-container">
                            <div class="col-md-12">
                                <div id="toPrint">
                                    <div class="form-container">
                                        
                                        <ul class="patient-information">
                                            <li><strong>Patient Name: </strong> <span><?php echo $user['patient_fname'].' '.$user['patient_lname']; ?></span></li>
                                            <li><strong>Date of Birth: </strong> <?php echo $user['patient_dob']; ?></li>
                                            <li><strong>Gender: </strong><?php if( $user['patient_gender'] == 'M' || $user['patient_gender'] == 'm' ){ echo 'Male'; }elseif( $user['patient_gender'] == 'F' || $user['patient_gender'] == 'f' ){ echo 'Female';  } ?></li>
                                            <li><strong>Cell: </strong><?php echo $user['cell']; ?></li>
                                            <div class="clear"></div>
                                        </ul>
                                        
                                        <div class="tab-content-container no-border" style="margin-top: 30px;">
                                                
                                            <h6 style="font-weight: 700">Hand Written Order</h6>
                                                
                                            <div id="canvas-container"></div>

                                            <div class="order-controls">

                                                <label class="order-label">
                                                    <input type="checkbox" name="signature" value="true" class="signature">
                                                    <span style="position:relative; top: 3px;">Sign before submitting order <i class="order-date"><?php echo date('Y/m/d H:i:s'); ?></i></span>
                                                </label>

                                                <input type="hidden" id="provider_name" value="<?php echo $provider_fname.' '.$provider_lname; ?>">
                                                <input type="hidden" id="provider_id" value="<?php echo $provider_userid; ?>">
                                                <input type="hidden" id="patient_id" value="<?php echo $provider_userid; ?>">
                                                <a href="javascript:;" class="button large rounded solid gray open save" style="margin-bottom: 10px;">Submit Order</a>
                                                <a href="javascript:;" class="button large rounded solid blue clear_canvas">Reset</a>

                                            </div>
                                                
                                        </div>
                
                                    </div>
                                </div>
                            </div>
                            <div class="clear"></div>
                        </div>

                        <?php }else{ ?>

                            <div class="error-container">
                                <img src="assets/images/error-login.jpg" class="error-img">
                                <h1>ERROR! <span>Invalid Unique ID</span></h1>
                                <p>Please try again, physician does not exist!</p>
                                <a href="javascript:;" class="button refresh" data-patient-id="<?php echo $_GET['patient_id'];?>">Try Again</a>
                            </div>

                        <?php } ?>
                        
                    <?php }else{ // Show the Unique ID Form ?>

                        <div class="order-input-container">
                            <div class="inner">
                                <h1>Provider Authentication</h1>
                                <p>Please enter your unique ID to proceed so we can verify if you are a Provider.</p>
                                <div class="form-container">
                                    <form action="order-app.php?patient_id=<?php echo $_GET['patient_id']; ?>" method="post">
                                        <input type="number" name="unique_id" placeholder="Enter Unique ID" class="textbox">
                                        <input type="submit" name="submit" value="Submit" class="btn-submit-unique">
                                    </form>
                                </div>
                            </div>
                        </div>

                    <?php } ?>

                <?php }else{ // Show an error message if the patient does not exist ?>

                    <div class="error-container">
                        <img src="assets/images/error-login.jpg" class="error-img">
                        <h1>ERROR! <span>Patient Does Not Exist</span></h1>
                    </div>
                
                <?php } ?>

            <?php }else{ // Else show an error message if there are no parameters ?>

                <div class="error-container">
                    <img src="assets/images/error-login.jpg" class="error-img">
                    <h1>Error! <span>No Parameter Specified</span></h1>
                </div>
                
            <?php } ?>

        </body>
    </html>