<?php

/*
200 - Everything is OK
201 - Created Successfully
202 - Accepted
204 - No Content
301 - Moved Permanently
400 - Bad Request
401 - Unauthorized
404 - Not Found
500 - Internal Server Error
*/

// Set Content to json
header('Content-Type: application/json');

include('functions.php');

function sendDeleteReqEmail( $email_to = null, $username = null, $imei = null ){
    
    if( isset($email_to) && isset($username) && isset($imei) ){
    
        $date_formated=date('F j, Y, g:i a', strtotime($dateTime));
        $subject = "Doctor Ai: IMEI Delete Request";
        
        $message_contents = "
        <p>Hi $username,</p>
        <p>A patient is requesting to delete their IMEI number from the doctro AI platform. Please click the link below to confirm the delete request.</p>
        <p><a href='".get_version('url')."/imei_delete.php?imeiIdNumber=".$imei."'>https://".get_version('url')."/imei_delete.php?imeiIdNumber=".$imei."</a></p>
        ";
        
        $headers  = 'MIME-Version: 1.0' . "\r\n";
        $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
        
        // Additional headers
        $headers .= 'From: DDxRx Software <support@ddxrx.com>' . "\r\n";
        
        //echo mail($email_address_to, $subject, $message_contents, $headers);
        $from="support@ddxrx.com";
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=iso-8859-1" . "\r\n";
        $headers .= 'From: <'.$from.'>' . "\r\n";
        $return = '-f'.$from;
        
        mail($email_to, $subject, $message_contents, $headers, $return);
    
    }
    
}

if( isset($_POST['patient_id']) && isset($_POST['imei_number']) ){
    
    // Variables
    $imei = $_POST['imei_number'];
    $groupID = get_version();
    
    // Send Emails
    $sql = "SELECT * FROM `all_users` WHERE user_type = '4' and groupid = '$groupID'";
    $result = mysqli_query(ddxrxDBConnect(), $sql);
    if (mysqli_num_rows($result) > 0) {
        while($row = mysqli_fetch_assoc($result)) {
            
            sendDeleteReqEmail( $row['email_address'], $row['username'], $imei );
            
        }
    }
    
    // Change Status
    $update_sql = "UPDATE cardiowell_users SET status='pending' WHERE imei = '$imei'";
    mysqli_query(ddxrxDBConnect(), $update_sql);
    
    $result = array(
        'status_code' => '200',
        'status_description' => 'Everything is OK'
    );
    
}else{
    
    $result = array(
        'status_code' => '400',
        'status_description' => 'Bad Request'
    );
    
}

mysqli_close(ddxrxDBConnect());

echo json_encode($result);

?>