<?php
session_start();
error_reporting(E_ERROR | E_PARSE);

// Include necessary files
// require_once('../config.php');
require_once('functions.php');

// Set connection variable
$con = ddxrxDBConnect();

// Check if user is logged in
if (!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
    echo json_encode(array(
        'success' => false,
        'error' => 'User not logged in'
    ));
    exit;
}

// Get the waitingroom_id from localStorage (passed via POST)
$waitingroom_id = isset($_POST['waitingroom_id']) ? intval($_POST['waitingroom_id']) : 0;
$diagnosis_id = isset($_POST['diagnosis_id']) ? intval($_POST['diagnosis_id']) : 0;

if ($waitingroom_id == 0 || $diagnosis_id == 0) {
    echo json_encode(array(
        'success' => false,
        'error' => 'Missing waitingroom_id or diagnosis_id'
    ));
    exit;
}

// Get current waiting room record
$waiting_room_query = "SELECT * FROM waiting_room WHERE waitingroom_id = " . $waitingroom_id;
$waiting_room_result = mysqli_query($con, $waiting_room_query);
$waiting_room_data = mysqli_fetch_assoc($waiting_room_result);

if (!$waiting_room_data) {
    echo json_encode(array(
        'success' => false,
        'error' => 'Waiting room record not found'
    ));
    exit;
}

// Get decision support criteria for this diagnosis
$decision_support_query = "SELECT * FROM decision_supports WHERE differential_diagnose_id = " . $diagnosis_id . " AND deleted = 0";
$decision_support_result = mysqli_query($con, $decision_support_query);
$decision_support = mysqli_fetch_assoc($decision_support_result);

if (!$decision_support) {
    echo json_encode(array(
        'success' => false,
        'message' => 'Decision support criteria not found for this diagnosis. You can skip to the next diagnosis.',
        'error' => 'Decision support criteria not found for this diagnosis'
    ));
    exit;
}

// Get all questions for this diagnosis
$questions_query = "SELECT * FROM dd_questions WHERE differential_diagnose_id = " . $diagnosis_id . " ORDER BY serial";
$questions_result = mysqli_query($con, $questions_query);
$questions = array();
while ($row = mysqli_fetch_assoc($questions_result)) {
    $questions[] = $row;
}

// Function to extract symptom name from question text
function extractSymptomName($questionText) {
    // Extract symptom name from question text like "Fever (Do you have...)"
    $pos = strpos($questionText, '(');
    if ($pos !== false) {
        return trim(substr($questionText, 0, $pos));
    }
    return trim($questionText);
}

// Calculate total score from answered questions
$total_score = 0;
$positive_symptoms = array();
$negative_symptoms = array();

foreach ($questions as $question) {
    $question_id = $question['id'];
    $yes_weight = floatval($question['yes']);
    $no_weight = floatval($question['no']);
    $symptom_name = extractSymptomName($question['questions']);
    
    // Check if this question was answered
    if (isset($_POST[$question_id])) {
        $answer = $_POST[$question_id];
        
        // Parse the answer to get the symptom and response
        if (strpos($answer, '_y') !== false) {
            // Yes answer
            $total_score += $yes_weight;
            $positive_symptoms[] = $symptom_name . ' ';
        } elseif (strpos($answer, '_n') !== false) {
            // No answer
            $total_score += $no_weight;
            $negative_symptoms[] = $symptom_name . ' ';
        }
    } else {
        // If no answer provided, treat as negative
        $negative_symptoms[] = '';
    }
}

// Check if diagnosis meets criteria
$required_score = floatval($decision_support['score']);
$condition = $decision_support['conditions'];
$diagnosis_confirmed = false;

if ($condition == 'Greater Than' && $total_score > $required_score) {
    $diagnosis_confirmed = true;
} elseif ($condition == 'Less Than' && $total_score < $required_score) {
    $diagnosis_confirmed = true;
} elseif ($condition == 'Equal To' && $total_score == $required_score) {
    $diagnosis_confirmed = true;
}

// Parse existing data from waiting room
$existing_diagnosis = $waiting_room_data['diagnosis'] ? explode(',', $waiting_room_data['diagnosis']) : array();
$existing_diagnosis_id = $waiting_room_data['diagnosis_id'] ? json_decode($waiting_room_data['diagnosis_id'], true) : array();
$existing_failed_diagnosis_id = $waiting_room_data['failed_diagnosis_id'] ? json_decode($waiting_room_data['failed_diagnosis_id'], true) : array();
$existing_answers_per_diagnosis = $waiting_room_data['answers_per_diagnosis'] ? json_decode($waiting_room_data['answers_per_diagnosis'], true) : array();
$existing_confirmed_having = $waiting_room_data['confirmed_having'] ? $waiting_room_data['confirmed_having'] : '';
$existing_failed_diagnosis = $waiting_room_data['failed_diagnosis'] ? explode(',', $waiting_room_data['failed_diagnosis']) : array();
$existing_chief_complaints = $waiting_room_data['chief_complaints'] ? $waiting_room_data['chief_complaints'] : '';

// Get diagnosis name
$diagnosis_name_query = "SELECT name FROM differential_diagnoses WHERE id = " . $diagnosis_id;
$diagnosis_name_result = mysqli_query($con, $diagnosis_name_query);
$diagnosis_name_row = mysqli_fetch_assoc($diagnosis_name_result);
$diagnosis_name = $diagnosis_name_row['name'];

// Get original symptoms from the form submission in diagnosis-results.php
// This should be passed from the main symptoms that brought patient to diagnosis
$original_symptoms = '';
if (isset($_POST['original_symptoms']) && !empty($_POST['original_symptoms'])) {
    $original_symptoms = $_POST['original_symptoms'];
} elseif (isset($_SESSION['symptomsList']) && is_array($_SESSION['symptomsList'])) {
    $original_symptoms = implode(', ', $_SESSION['symptomsList']);
} else {
    // Fallback: use existing symptoms or set from current context
    $original_symptoms = $waiting_room_data['symptoms'] ? $waiting_room_data['symptoms'] : '';
}

// Set chief_complaints from original symptoms if not already set
if (empty($existing_chief_complaints) && !empty($original_symptoms)) {
    // Smart conversion: preserve complex symptom names like "Cough, Acute"
    $parts = explode(', ', $original_symptoms);
    $symptoms = array();
    $current_symptom = '';
    
    // Common symptom starting words to identify new symptoms
    $common_symptoms = array('Fever', 'Pain', 'Headache', 'Cough', 'Chest', 'Diabetes', 'Hypertension', 'Follow-up', 'Abdominal', 'Nausea', 'Vomiting', 'Dizziness', 'Fatigue', 'Shortness');
    
    foreach ($parts as $i => $part) {
        if ($current_symptom === '') {
            $current_symptom = $part;
        } else {
            // Check if this part starts with a common symptom word (indicating new symptom)
            $is_new_symptom = false;
            foreach ($common_symptoms as $common) {
                if (stripos($part, $common) === 0) {
                    $is_new_symptom = true;
                    break;
                }
            }
            
            if ($is_new_symptom) {
                // This is a new symptom
                $symptoms[] = $current_symptom;
                $current_symptom = $part;
            } else {
                // This is a modifier of the current symptom
                $current_symptom .= ', ' . $part;
            }
        }
    }
    
    // Add the last symptom
    if ($current_symptom !== '') {
        $symptoms[] = $current_symptom;
    }
    
    $existing_chief_complaints = implode('; ', $symptoms);
}

// Update the arrays based on diagnosis result
if ($diagnosis_confirmed) {
    // Add to confirmed diagnoses
    if (!in_array($diagnosis_name, $existing_diagnosis)) {
        $existing_diagnosis[] = $diagnosis_name;
    }
    if (!in_array($diagnosis_id, $existing_diagnosis_id)) {
        $existing_diagnosis_id[] = strval($diagnosis_id);
    }
    
    // Remove from failed if it was there
    $failed_key = array_search(strval($diagnosis_id), $existing_failed_diagnosis_id);
    if ($failed_key !== false) {
        unset($existing_failed_diagnosis_id[$failed_key]);
        $existing_failed_diagnosis_id = array_values($existing_failed_diagnosis_id);
    }
    
    // Remove from failed_diagnosis text field if it was there
    $failed_text_key = array_search($diagnosis_name, $existing_failed_diagnosis);
    if ($failed_text_key !== false) {
        unset($existing_failed_diagnosis[$failed_text_key]);
        $existing_failed_diagnosis = array_values($existing_failed_diagnosis);
    }
    
    // Add positive symptoms to confirmed_having
    $positive_symptoms_clean = array();
    foreach ($positive_symptoms as $symptom) {
        $clean_symptom = trim($symptom);
        if ($clean_symptom !== '') {
            $positive_symptoms_clean[] = $clean_symptom;
        }
    }
    
    if (count($positive_symptoms_clean) > 0) {
        // Parse existing confirmed_having to avoid duplicates
        $existing_symptoms = array();
        if ($existing_confirmed_having) {
            $existing_symptoms = array_map('trim', explode(',', $existing_confirmed_having));
        }
        
        // Add new symptoms that don't already exist
        foreach ($positive_symptoms_clean as $symptom) {
            if (!in_array($symptom, $existing_symptoms)) {
                $existing_symptoms[] = $symptom;
            }
        }
        
        $existing_confirmed_having = implode(' , ', $existing_symptoms);
    }
    
} else {
    // Add to failed diagnoses
    if (!in_array(strval($diagnosis_id), $existing_failed_diagnosis_id)) {
        $existing_failed_diagnosis_id[] = strval($diagnosis_id);
    }
    
    // Add to failed_diagnosis text field
    if (!in_array($diagnosis_name, $existing_failed_diagnosis)) {
        $existing_failed_diagnosis[] = $diagnosis_name;
    }
    
    // Remove from confirmed if it was there
    $confirmed_key = array_search($diagnosis_name, $existing_diagnosis);
    if ($confirmed_key !== false) {
        unset($existing_diagnosis[$confirmed_key]);
        $existing_diagnosis = array_values($existing_diagnosis);
    }
    
    $confirmed_id_key = array_search(strval($diagnosis_id), $existing_diagnosis_id);
    if ($confirmed_id_key !== false) {
        unset($existing_diagnosis_id[$confirmed_id_key]);
        $existing_diagnosis_id = array_values($existing_diagnosis_id);
    }
}

// Update answers per diagnosis - match original format
$existing_answers_per_diagnosis[strval($diagnosis_id)] = array(
    'positives' => $positive_symptoms,
    'negatives' => $negative_symptoms
);

// Prepare update data
$diagnosis_string = implode(', ', $existing_diagnosis);
$diagnosis_id_json = json_encode($existing_diagnosis_id);
$failed_diagnosis_id_json = json_encode($existing_failed_diagnosis_id);
$failed_diagnosis_string = implode(', ', $existing_failed_diagnosis);
$answers_per_diagnosis_json = json_encode($existing_answers_per_diagnosis);
$havingz = $existing_confirmed_having; // Same as confirmed_having

// Ensure symptoms column is set with smart parsing
$symptoms_for_db = '';
if ($original_symptoms) {
    // Apply the same smart parsing logic to symptoms as we do for chief_complaints
    $parts = explode(', ', $original_symptoms);
    $symptoms = array();
    $current_symptom = '';
    
    // Common symptom starting words to identify new symptoms
    $common_symptoms = array('Fever', 'Pain', 'Headache', 'Cough', 'Chest', 'Diabetes', 'Hypertension', 'Follow-up', 'Abdominal', 'Nausea', 'Vomiting', 'Dizziness', 'Fatigue', 'Shortness');
    
    foreach ($parts as $i => $part) {
        if ($current_symptom === '') {
            $current_symptom = $part;
        } else {
            // Check if this part starts with a common symptom word (indicating new symptom)
            $is_new_symptom = false;
            foreach ($common_symptoms as $common) {
                if (stripos($part, $common) === 0) {
                    $is_new_symptom = true;
                    break;
                }
            }
            
            if ($is_new_symptom) {
                // This is a new symptom
                $symptoms[] = $current_symptom;
                $current_symptom = $part;
            } else {
                // This is a modifier of the current symptom
                $current_symptom .= ', ' . $part;
            }
        }
    }
    
    // Add the last symptom
    if ($current_symptom !== '') {
        $symptoms[] = $current_symptom;
    }
    
    $symptoms_for_db = implode(', ', $symptoms); // Use comma-space for symptoms column
} else {
    $symptoms_for_db = $waiting_room_data['symptoms'];
}

// Update waiting room record
$update_query = "UPDATE waiting_room SET 
    diagnosis = '" . mysqli_real_escape_string($con, $diagnosis_string) . "',
    diagnosis_id = '" . mysqli_real_escape_string($con, $diagnosis_id_json) . "',
    failed_diagnosis_id = '" . mysqli_real_escape_string($con, $failed_diagnosis_id_json) . "',
    failed_diagnosis = '" . mysqli_real_escape_string($con, $failed_diagnosis_string) . "',
    answers_per_diagnosis = '" . mysqli_real_escape_string($con, $answers_per_diagnosis_json) . "',
    confirmed_having = '" . mysqli_real_escape_string($con, $existing_confirmed_having) . "',
    havingz = '" . mysqli_real_escape_string($con, $havingz) . "',
    chief_complaints = '" . mysqli_real_escape_string($con, $existing_chief_complaints) . "',
    symptoms = '" . mysqli_real_escape_string($con, $symptoms_for_db) . "',
    acuity = '0'
    WHERE waitingroom_id = " . $waitingroom_id;

$update_result = mysqli_query($con, $update_query);

if (!$update_result) {
    echo json_encode(array(
        'success' => false,
        'error' => 'Failed to update waiting room record: ' . mysqli_error($con)
    ));
    exit;
}

// Return response
echo json_encode(array(
    'success' => true,
    'diagnosis_confirmed' => $diagnosis_confirmed,
    'total_score' => $total_score,
    'required_score' => $required_score,
    'condition' => $condition,
    'diagnosis_name' => $diagnosis_name,
    'message' => $diagnosis_confirmed ? 
        'Diagnosis confirmed: ' . $diagnosis_name : 
        'Diagnosis criteria not met. Moving to next diagnosis.'
));
?>
