<?php

// Set the header to JSON
header('Content-Type: application/json');

// Include the functions file
include('functions.php');

if( isset($_POST['patient_id']) ){

    // Register variables
    $data = array();
    $temp_array = array();
    $output = array();

    // Sanitize the input
    $patient_id = htmlspecialchars($_POST['patient_id'], ENT_QUOTES, 'UTF-8');
    $patient_id = ddxrxDBConnect()->real_escape_string($patient_id);

    $sql = "SELECT * FROM `medical` WHERE `patient_id` = '$patient_id' AND `status` = 'approved'";

    $result = ddxrxDBConnect()->query($sql);

    if ($result->num_rows > 0) {
        // output data of each row
        while($row = $result->fetch_assoc()) {

            $temp_array = array(
                'id' => $row["id"],
                'diagnosis' => $row["diagnosis"]
            );

            // Push array to the data array
            array_push($data, $temp_array);

        }

        // Output the data
        $output = array(
            'status' => true,
            'message' => 'Past medical history found.',
            'data' => $data
        );

    } else {
        $data = array(
            'result' => false,
            'message' => 'No past medical history found.'
        );
    }

    // Close the connection
    ddxrxDBConnect()->close();

}else{

    $output = array(
        'status' => false,
        'message' => 'No patient ID provided.'
    );

}

// Output the data
echo json_encode($output);