<?php

// Turn off error reporting to prevent HTML output
error_reporting(0);
ini_set('display_errors', 0);

// Start output buffering to catch any unwanted output
ob_start();

// Include functions file
include('functions.php');

// Clean any output that might have been generated
ob_clean();

// Set header to JSON
header('Content-Type: application/json');

// Check if POST data exists
$addendum_text = isset($_POST['addendum_text']) ? $_POST['addendum_text'] : '';
$waiting_room_id = isset($_POST['waiting_room_id']) ? $_POST['waiting_room_id'] : '';

// Validate inputs
if (empty($addendum_text)) {
    echo json_encode(array(
        'result' => false,
        'title' => 'Error',
        'message' => 'Addendum cannot be empty.',
        'icon' => 'error'
    ));
    exit;
}

if (empty($waiting_room_id)) {
    echo json_encode(array(
        'result' => false,
        'title' => 'Error',
        'message' => 'Waiting room ID is required.',
        'icon' => 'error'
    ));
    exit;
}

try {
    $conn = ddxrxDBConnect();

    // First, get the current saved_input value
    $selectSql = "SELECT `saved_input` FROM `waiting_room` WHERE `waitingroom_id` = ?";
    
    if ($selectStmt = $conn->prepare($selectSql)) {
        $selectStmt->bind_param("i", $waiting_room_id);
        $selectStmt->execute();
        $result = $selectStmt->get_result();
        
        if ($row = $result->fetch_assoc()) {
            $currentSavedInput = $row['saved_input'];
            
            // Parse existing JSON or create new array
            if (!empty($currentSavedInput)) {
                $savedInputArray = json_decode($currentSavedInput, true);
                if (!is_array($savedInputArray)) {
                    $savedInputArray = array();
                }
            } else {
                $savedInputArray = array();
            }
            
            // Create addendum object
            $addendumObject = array(
                "group" => "Addendum",
                "name" => "addendum_text",
                "date" => date('Y-m-d H:i:s'),
                "value" => $addendum_text,
                "type" => "textarea"
            );
            
            // Check if addendum already exists and remove it
            foreach ($savedInputArray as $key => $item) {
                if (isset($item['group']) && $item['group'] === 'Addendum' && 
                    isset($item['name']) && $item['name'] === 'addendum_text') {
                    unset($savedInputArray[$key]);
                    break;
                }
            }
            
            // Add the new addendum to the end
            $savedInputArray[] = $addendumObject;
            
            // Convert back to JSON
            $updatedSavedInput = json_encode(array_values($savedInputArray));
            
            // Update the waiting_room table
            $updateSql = "UPDATE `waiting_room` SET `saved_input` = ? WHERE `waitingroom_id` = ?";
            
            if ($updateStmt = $conn->prepare($updateSql)) {
                $updateStmt->bind_param("si", $updatedSavedInput, $waiting_room_id);
                
                if ($updateStmt->execute()) {
                    echo json_encode(array(
                        'result' => true,
                        'title' => 'Success',
                        'message' => 'Addendum saved successfully.',
                        'icon' => 'success'
                    ));
                } else {
                    echo json_encode(array(
                        'result' => false,
                        'title' => 'Error',
                        'message' => 'Failed to save addendum.',
                        'icon' => 'error'
                    ));
                }
                
                $updateStmt->close();
            } else {
                echo json_encode(array(
                    'result' => false,
                    'title' => 'Error',
                    'message' => 'Database prepare failed for update.',
                    'icon' => 'error'
                ));
            }
        } else {
            echo json_encode(array(
                'result' => false,
                'title' => 'Error',
                'message' => 'Waiting room record not found.',
                'icon' => 'error'
            ));
        }
        
        $selectStmt->close();
    } else {
        echo json_encode(array(
            'result' => false,
            'title' => 'Error',
            'message' => 'Database prepare failed for select.',
            'icon' => 'error'
        ));
    }
    
    $conn->close();
    
} catch (Exception $e) {
    echo json_encode(array(
        'result' => false,
        'title' => 'Error',
        'message' => 'An error occurred: ' . $e->getMessage(),
        'icon' => 'error'
    ));
}

// End output buffering and flush
ob_end_flush();

?>

