<?php

/**
 * REQUIRE FUNCTIONS
 */
include('process/functions.php');



/**
 * REQUIRE PDF LIBRARY
 * 
 * FPDF is a PHP class which allows to generate PDF files with pure PHP,
 * that is to say without using the PDFlib library. F from FPDF stands for Free:
 * you may use it for any kind of usage and modify it to suit your needs.
 */
require('dashboard/lib/fpdf.php');

if( empty($_GET['patient_id']) && !isset($_GET['patient_id']) ){
    $patient_id = '0';
}else{
    $patient_id = $_GET['patient_id'];
}

if( empty($_GET['month']) && !isset($_GET['month']) ){
    $month = date('m');
}else{
    $month = $_GET['month'];
}

if( empty($_GET['year']) && !isset($_GET['year']) ){
    $year = date('Y');
}else{
    $year = $_GET['year'];
}

class PDF extends FPDF {
    
    // Page header
    function Header() {
        
        // Set font family to Arial bold 
        $this->SetFont('Arial', '', 10);
        
    }
  
    // Page footer
    function Footer() {
          
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
          
        // Arial italic 8
        $this->SetFont('Arial','I',8);
          
        // Page number
        $this->Cell(0,10,'Page ' . $this->PageNo() . '/{nb}',0,0,'C');
    }
    
    // Content
    function contentTable( $patient_id = '0', $month = null, $year = null ){

        $total_time = '';

        if( empty($month) ){
            $month = date('d');
        }

        if( empty($year) ){
            $year = date('Y');
        }

        if( $month == 'all' ){
            $sql = "SELECT * FROM `timer` WHERE `patient_id` = '$patient_id'";
        }else{
            $sql = "SELECT * FROM `timer` WHERE `patient_id` = '$patient_id' AND MONTH(watch_time) = '$month' AND YEAR(watch_time) = '$year'";
        }

        $result = ddxrxDBConnect()->query($sql);

        if ($result->num_rows > 0) {

            // Table Header
            $this->SetFont('Arial','', 9);
            $this->SetTextColor(255,255,255);
            $this->Cell(47, 6, 'Date ', "B", 0, "L", true);
            $this->Cell(47, 6, 'CC Type ', "B", 0, "L", true);
            $this->Cell(47, 6, 'Entry ', "B", 0, "L", true);
            $this->Cell(47, 6, 'Time ', "B", 0, "L", true);
            
            // Line break
            $this->Ln(7);

            while($row = $result->fetch_assoc()) {
                
                // Set Font Color
                $this->SetTextColor(0,0,0);

                // Set date format
                $date_obj = DateTime::createFromFormat('Y-m-d H:i:s', $row['watch_time']);
                $formatted_date = $date_obj->format('F d, Y');

                $this->SetFont('Arial','', 9);
                $this->Cell(47, 7, $formatted_date, "B", 0, "L");
                $this->Cell(47, 7, strtoupper($row['cctype']), "B", 0, "L");
                $this->Cell(47, 7, ucfirst($row['entry']), "B", 0, "L");
                $this->Cell(47, 7, secondsToTime($row['total_time_in_seconds']), "B", 1, "L");

                $total_time = (int)$total_time+(int)$row['total_time_in_seconds'];

            }

            //$this->SetTextColor(255,255,255);
            $this->SetFont('Arial','B', 17);
            $this->Cell(135, 12, 'Total Time', 0, 0, "L");

            $this->SetFont('Arial','', 13);
            $this->Cell(53, 12, secondsToTime($total_time), 0, 0, "R");

        }else{

            $this->SetFont('Arial','', 20);
            $this->Cell(190, 7, 'ERROR: No Timer Data For This Patient or Month', 0, 2, "C");

        }

        ddxrxDBConnect()->close();

    }
    
}


$pdf = new PDF();

// Set Title
$pdf->SetTitle('Patient RPM Data');

// Define alias for number of pages
$pdf->AliasNbPages();
$pdf->AddPage();

// Add Content
$pdf->contentTable( $patient_id, $month, $year );

// Output the file as a PDF
if( isset($_GET['type']) && $_GET['type'] == 'download' ){
    $pdf->Output('D', "Patient-RPM-Data.pdf");
}else{
    $pdf->Output();
}

?>