<?php

error_reporting(1);
ob_start();
session_start();

// Mobile Detect
require_once("mobile_detect.php");
$detect = new Mobile_Detect;

// print_r($_SESSION);
if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
    header("Location: ios-launch.php");
    die();
}

// Inlcudes
// include ('includes/database_include.php');
include ('process/functions.php');

$GLOBALS['mycon'] = ddxrxDBConnect();

$vitalFields = [];
$vitalFields[] = ['fieldName' => 'systolicBP', 'fieldLable' => 'Systolic BP', 'min' => 90, 'max' => 190];
$vitalFields[] = ['fieldName' => 'diastolicBP', 'fieldLable' => 'Diastolic BP', 'min' => 70, 'max' => 100];
$vitalFields[] = ['fieldName' => 'heartRate', 'fieldLable' => 'Heart Rate', 'min' => 0, 'max' => 90];
$vitalFields[] = ['fieldName' => 'respRate', 'fieldLable' => 'Respiratory Rate', 'min' => 0, 'max' => 20];
$vitalFields[] = ['fieldName' => 'pulseOX', 'fieldLable' => 'Pulse Ox', 'min' => 90, 'max' => 0];
$vitalFields[] = ['fieldName' => 'temp', 'fieldLable' => 'Temperature', 'min' => 96.8, 'max' => 100.4];

function medical_diagnosis() {
	$sql = "SELECT * FROM medical WHERE patient_id = '".$_SESSION["patient_id"]."'";
	$result = mysqli_query(ddxrxDBConnect(), $sql);

	if (mysqli_num_rows($result) > 0) {
	    // output data of each row
	    while($row = mysqli_fetch_assoc($result)) {
	        if( $row["status"] == 'pending' ) {
	            $status = 'class="pending"'; $label = '<strong>Pending</strong>'; 
	            
	        }
	        echo '<label '.$status.'><span>'.$row["diagnosis"].'</span>'.$label.'</label>';
	    }
	} else {
	    echo "<p>No History Yet</p>";
	}
}


function surgical_diagnosis() {

	$sql = "SELECT * FROM surgical WHERE patient_id = '".$_SESSION["patient_id"]."'";
	$result = mysqli_query(ddxrxDBConnect(), $sql);

	if (mysqli_num_rows($result) > 0) {
	    // output data of each row
	    while($row = mysqli_fetch_assoc($result)) {

	    	if( $row["status"] == 'pending' ){ $status = 'class="pending"'; $label = '<strong>Pending</strong>'; }
	        echo '<label '.$status.'><span>'.$row["diagnosis"].'</span>'.$label.'</label>';

	    }
	} else {
	    echo "<p>No History Yet</p>";
	}
}

function family_diagnosis() {
	$sql = "SELECT * FROM family WHERE patient_id = '".$_SESSION["patient_id"]."'";
	$result = mysqli_query(ddxrxDBConnect(), $sql);

	if (mysqli_num_rows($result) > 0) {
	    // output data of each row
	    while($row = mysqli_fetch_assoc($result)) {

	    	if( $row["status"] == 'pending' ){ $status = 'class="pending"'; $label = '<strong>Pending</strong>'; }
	        echo '<label '.$status.'><span>'.$row["diagnosis"].'</span>'.$label.'</label>';

	    }
	} else {
	    echo "<p>No History Yet</p>";
	}
}

function allergy_history() {

	$sql = "SELECT * FROM allergies WHERE patient_id = '".$_SESSION["patient_id"]."'";
	$result = mysqli_query(ddxrxDBConnect(), $sql);

	if (mysqli_num_rows($result) > 0) {
	    // output data of each row
	    while($row = mysqli_fetch_assoc($result)) {
	        
	        if( $row["status"] == 'pending' ){ $status = 'class="pending"'; $label = '<strong>Pending</strong>'; }
	        echo '<label '.$status.'><span>'.$row["allergy"].'</span>'.$label.'</label>';

	    }
	} else {
	    echo "<p>No History Yet</p>";
	}
}

function medication_history() {
	$sql = "SELECT * FROM medication WHERE patient_id = '".$_SESSION["patient_id"]."'";
	$result = mysqli_query(ddxrxDBConnect(), $sql);

	if (mysqli_num_rows($result) > 0) {
	    // output data of each row
	    while($row = mysqli_fetch_assoc($result)) {
	        
	        if( $row["status"] == 'pending' ){ $status = 'class="pending"'; $label = '<strong>Pending</strong>'; }
	        echo '<label '.$status.'><span>'.$row["medicine"].'</span>'.$label.'</label>';

	    }
	} else {
	    echo "<p>No History Yet</p>";
	}
}

function social_diagnosis() {

	$sql = "SELECT * FROM social WHERE patient_id = '".$_SESSION["patient_id"]."'";
	$result = mysqli_query(ddxrxDBConnect(), $sql);

	if (mysqli_num_rows($result) > 0) {
	    // output data of each row
	    while($row = mysqli_fetch_assoc($result)) {

	    	echo '<label>Tobacco: <span>'.$row["tobaco"].'</span></label>';
	    	echo '<label>Alcohol: <span>'.$row["alcohol"].'</span></label>';
	    	echo '<label>Drugs: <span>'.$row["drugs"].'</span></label>';
	    	echo '<label>Occupation: <span>'.$row["occupation"].'</span></label>';
	    	echo '<label>Prison: <span>'.$row["prison"].'</span></label>';
	    	echo '<label>Travel: <span>'.$row["travel"].'</span></label>';
	    	echo '<label>Exercise: <span>'.$row["exercise"].'</span></label>';
	    	echo '<label>Firearms: <span>'.$row["firearms"].'</span></label>';

	    }
	} else {
	    echo "<p>No History Yet</p>";
	}
}


function current_social_record( $type = null, $value = null ) {
	$user_id = $_SESSION['userid'];
	$mySQLcon = $GLOBALS['mycon'];

	$sql = "SELECT * FROM social WHERE patient_id = '".$_SESSION["patient_id"]."' LIMIT 1";
	$result = mysqli_query($mySQLcon, $sql) or die('SQL Error :: '.mysqli_error());
	$user = mysqli_fetch_assoc($result);
	
	if( $type == 'tobaco' ){
		if( $user[$type] == $value ){ echo ' selected="selected"'; }
	}elseif( $type == 'alcohol' ){
		if( $user[$type] == $value ){ echo ' selected="selected"'; }
	}elseif( $type == 'drugs' ){
		if( $user[$type] == $value ){ echo ' selected="selected"'; }
	}elseif( $type == 'occupation' ){
		if( $user[$type] == $value ){ echo ' selected="selected"'; }
	}elseif( $type == 'prison' ){
		if( $user[$type] == $value ){ echo ' selected="selected"'; }
	}elseif( $type == 'travel' ){
		if( $user[$type] == $value ){ echo ' selected="selected"'; }
	}elseif( $type == 'exercise' ){
		if( $user[$type] == $value ){ echo ' selected="selected"'; }
	}elseif( $type == 'firearms' ){
		if( $user[$type] == $value ){ echo ' selected="selected"'; }
	}

}

function get_user_vitals() {

	$sql = "SELECT * FROM waiting_room WHERE patient_id = '".$_SESSION["patient_id"]."' ORDER BY checkin_time DESC LIMIT 1";
	$result = mysqli_query(ddxrxDBConnect(), $sql) or die('SQL Error :: '.mysqli_error());
	$user = mysqli_fetch_assoc($result);

	$vitals = $user['vital_json']; // Register Dynamic data into a variable
	$vitals = str_replace("'", '"', $vitals); // Replace single quote with double quote
	$vitals = json_decode($vitals); // Decode Json

	/*
	foreach ($vitals as $vital) {
    	echo $vital, "\n";
    	//echo $vital->systolicBP;
	}
	*/

	if( isset($vitals->systolicBP) ){ echo '<li><span>Systolic BP:</span> '.$vitals->systolicBP.'</li>'; }else{ echo '<li><span>Systolic BP:</span> No Previous Record</li>'; }
	if( isset($vitals->diastolicBP) ){ echo '<li><span>Diastolic BP:</span> '.$vitals->diastolicBP.'</li>'; }else{ echo '<li><span>Diastolic BP:</span> No Previous Record</li>'; }
	if( isset($vitals->heartRate) ){ echo '<li><span>Heart Rate:</span> '.$vitals->heartRate.'</li>'; }else{ echo '<li><span>Heart Rate:</span> No Previous Record</li>'; }
	if( isset($vitals->respRate) ){ echo '<li><span>Respiratory Rate:</span> '.$vitals->respRate.'</li>'; }else{ echo '<li><span>Respiratory Rate:</span> No Previous Record</li>'; }
	if( isset($vitals->pulseOX) ){ echo '<li><span>Pulse OX:</span> '.$vitals->pulseOX.'</li>'; }else{ echo '<li><span>Pulse OX:</span> No Previous Record</li>'; }
	if( isset($vitals->temp) ){ echo '<li><span>Temperature:</span> '.$vitals->temp.'</li>'; }else{ echo '<li><span>Temperature:</span> No Previous Record</li>'; }

}


function free_trial(){ 
    $userid=  $_SESSION['userid'];
    $startdate = $_SESSION['current_patient']['created_at'];
    $expire  = date("Y-m-d H:i:s", strtotime($startdate . ' + 30 days'));
    $today = date("Y-m-d H:i:s");
        
    if($today >= $expire){
        return 'false';
    } else {
        return 'true';
    }
}


?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
	<title>DDXRX Choose Actions</title>
	
	<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
	<script type="text/javascript" src="assets/js/base64converter.js"></script>
	<script type="text/javascript" src="assets/js/autocomplete/jquery.autocomplete.min.js"></script>
	<script type="text/javascript" src="assets/js/mobile.js"></script>
	<script type="text/javascript" src="assets/js/faq.js"></script>
	<script type="text/javascript" src="assets/js/phone-call.js"></script>
	
	<?php if ( $detect->isMobile() ) { ?>
	<script type="text/javascript" src="assets/js/vitals_mobile.js"></script>
	<?php }else{ ?>
	<script type="text/javascript" src="assets/js/vitals.js"></script>
	<?php } ?>
	
	
	<script type="text/javascript">
        var vitalFields = <?php echo json_encode($vitalFields); ?>;
    </script>
    
	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
	<link rel="stylesheet" type="text/css" href="assets/css/grid.css">
	<link rel="stylesheet" type="text/css" href="assets/css/autocomplete/jquery.autocomplete.css"/>
	<link rel="stylesheet" type="text/css" href="assets/css/mobile.css">
	<link rel="stylesheet" type="text/css" href="assets/css/vitals.css">
	<link rel="stylesheet" type="text/css" href="assets/css/faq.css">
	
	<!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-148409281-5"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
    
      gtag('config', 'UA-148409281-5');
    </script>
	
</head>
<body data-patient-id="<?php echo get_patient_id(); ?>">
    
    <div class="loading-screen"></div>
    
    <?php bottom_nav(); ?>
	
	<div class="left">
		<div class="diagnosis-container" data-id="<?php echo $_GET['id']; ?>">
			<h6>Add your history</h6>
			<div class="inner">
							
				<div class="item">
					<p data-hintPosition="top-centered-right">Medical History</p>
					<div class="desc">
						<?php echo medical_diagnosis(); ?>
						<div class="dynamical_entry medical"></div>
						<input type="text" class="textbox txt_medical ac_input symptoms_search_box search_symptom_qry">
						<div class="search-result-container"><ul></ul></div>
						<a href="javascript:;" class="button add_medical">Add New</a>
					</div>
				</div>

				<div class="item">
					<p>Surgical History</p>
					<div class="desc">
						<?php echo surgical_diagnosis(); ?>
						<div class="dynamical_entry surgical"></div>
						<input type="text" class="textbox txt_surgical ac_input symptoms_search_box">
						<a href="javascript:;" class="button add_surgical">Add New</a>
					</div>
				</div>

				<div class="item">
					<p>Social History</p>
					<div class="desc">
						<?php //echo social_diagnosis(); ?>

						<label>Tobacco
							<select class="selectbox social-status" name="tobaco">
								<option value="current" <?php current_social_record('tobaco','current'); ?>>Current</option>
								<option value="prior" <?php current_social_record('tobaco','prior'); ?>>Prior</option>
								<option value="never" <?php current_social_record('tobaco','never'); ?>>Never</option>
							</select>
						</label>

						<label>Alcohol
							<select class="selectbox social-status" name="alcohol">
								<option value="never" <?php current_social_record('alcohol','never'); ?>>Never</option>
								<option value="prior" <?php current_social_record('alcohol','prior'); ?>>Prior</option>
								<option value="occasional" <?php current_social_record('alcohol','occasional'); ?>>Occasional</option>
								<option value="daily" <?php current_social_record('alcohol','daily'); ?>>Daily</option>
							</select>
						</label>

						<label>Illicit Drug
							<select class="selectbox social-status" name="drugs">
								<option value="yes" <?php current_social_record('drugs','yes'); ?>>Yes</option>
								<option value="no" <?php current_social_record('drugs','no'); ?>>No</option>
							</select>
						</label>

						<label>Occupation
							<select class="selectbox social-status" name="occupation">
								<option value="unemployed" <?php current_social_record('occupation','unemployed'); ?>>Unemployed</option>
								<option value="employed" <?php current_social_record('occupation','employed'); ?>>Employed</option>
							</select>
						</label>

						<label>Prison History
							<select class="selectbox social-status" name="prison">
								<option value="yes" <?php current_social_record('prison','yes'); ?>>Yes</option>
								<option value="no" <?php current_social_record('prison','no'); ?>>No</option>
							</select>
						</label>

						<label>Recent Travel
							<select class="selectbox social-status" name="travel">
								<option value="yes" <?php current_social_record('travel','yes'); ?>>Yes</option>
								<option value="no" <?php current_social_record('travel','no'); ?>>No</option>
							</select>
						</label>

						<label>Exercise
							<select class="selectbox social-status" name="exercise">
								<option value="yes" <?php current_social_record('exercise','yes'); ?>>Yes</option>
								<option value="no" <?php current_social_record('exercise','no'); ?>>No</option>
							</select>
						</label>

						<label>Firearms in household
							<select class="selectbox social-status" name="firearms">
								<option value="yes" <?php current_social_record('firearms','yes'); ?>>Yes</option>
								<option value="no" <?php current_social_record('firearms','no'); ?>>No</option>
							</select>
						</label>

					</div>
				</div>

				<div class="item">
					<p>Family History</p>
					<div class="desc">
									
						<?php echo family_diagnosis(); ?>

						<div class="dynamical_entry family"></div>
						<input type="text" class="textbox txt_family ac_input symptoms_search_box">
						<a href="javascript:;" class="button add_family">Add New</a>

					</div>
				</div>

				<div class="item">
					<p>Allergies</p>
					<div class="desc">
									
						<?php echo allergy_history(); ?>

						<div class="dynamical_entry allergy"></div>
						<input type="text" class="textbox txt_allergy ac_input symptoms_search_box">
						<a href="javascript:;" class="button add_allergy">Add New</a>

					</div>
				</div>

				<div class="item">
					<p>Medications</p>
					<div class="desc">
									
						<?php echo medication_history(); ?>

						<div class="dynamical_entry medication"></div>
						<input type="text" class="textbox txt_medication ac_input symptoms_search_box">
						<a href="javascript:;" class="button add_medication">Add New</a>
									
					</div>
				</div>

			</div>
		</div>

		<div class="vitals-container encounter_id" data-vitals-encounter="<?php echo $_SESSION['current_patient']['waitingroom_id']; ?>" style="margin-bottom: 20px;">
			<h6>Add Vital Signs</h6>
			
			<div class="inner">
				<?php //get_user_vitals(); ?>
							
				<?php foreach($vitalFields as $field) { ?>
					<?php $label = $field['fieldLable']; ?>
					<?php $name = $field['fieldName']; ?>
					
					<label>
					<span><?php echo $label; ?></span>
						<input type="number" class="textbox vitals ac_input" name="<?php echo $name; ?>" id="<?php echo $name; ?>">
					</label>
				<?php } ?>
				<button class="button large rounded solid blue" id="saveVitals">SAVE</button>
			</div>
		</div>
	</div>
	
	<div class="rpm-devices">
		<div class="right inner">
			<?php
				$user_id = $_SESSION["userid"];
				$query = "SELECT * FROM ihealth_users WHERE user_id = '$user_id' LIMIT 1";
				$result = mysqli_query(ddxrxDBConnect(), $query) or die(mysqli_error(ddxrxDBConnect()));
				$data = mysqli_fetch_assoc($result);
				//echo 'User ID '.$data['patient_id'];
			?>
				
			<?php if( !empty($data['patient_id']) ){ ?>
				<div class="ihealth-connect">
					<h6>Ihealth Monitoring</h6>
					<p>Connection Status: <span class="connected">Connected</span></p>
					<a href="ihealth-api-patient/disconnect.php" class="button red">Disconnect and remove data</a>
					<!--<a href="ihealth-api-patient/refresh.php">Refresh</a>-->
				</div>
			<?php }else{ ?>
				<div class="ihealth-connect">
					<h6>Ihealth Monitoring</h6>
					<p>Connection Status: <span class="disconnected">Not Connected</span></p>
					<a href="ihealth-api-patient/index.php" class="button blue">Connect and sync data</a>
				</div>
			<?php } ?>
				
			<?php
				$patient_id = get_patient_id();
				$sql = "SELECT * FROM cardiowell_users WHERE patient_id = '$patient_id' AND type = 'bp' LIMIT 1";
				$result = mysqli_query(ddxrxDBConnect(), $sql);
				$row = mysqli_fetch_assoc($result);
				
				if( $row['imei'] != '' ){
					$status = 'Connected';
					$class = 'connected';
					$buttonClass = 'red connected';
					$buttonLabel = 'Disconnect and remove data';
				}else{
					$status = 'Not Connected';
					$class = 'disconnected';
					$buttonClass = 'blue disconnected';
					$buttonLabel = 'Connect and sync data';
				}
			?>
				
			<div class="ihealth-connect cardiowell bloodpressure">
				<h6>Cellular Monitoring: Blood Pressure Machine</h6>
				<p>Connection Status: <span class="status <?php echo $class; ?>"><?php echo $status; ?></span></p>
				<a href="javascript:;" class="button <?php echo $buttonClass; ?>" data-machine="bp" data-imei="<?php echo $row['imei']; ?>"><?php echo $buttonLabel; ?></a>
			</div>
				
			<?php mysqli_close(ddxrxDBConnect()); ?>
				
			<?php
				$patient_id = get_patient_id();
				$sql = "SELECT * FROM cardiowell_users WHERE patient_id = '$patient_id' AND type = 'weight' LIMIT 1";
				$result = mysqli_query(ddxrxDBConnect(), $sql);
				$row = mysqli_fetch_assoc($result);
				
				if( $row['imei'] != '' ){
					$status = 'Connected';
					$class = 'connected';
					$buttonClass = 'red connected';
					$buttonLabel = 'Disconnect and remove data';
				}else{
					$status = 'Not Connected';
					$class = 'disconnected';
					$buttonClass = 'blue disconnected';
					$buttonLabel = 'Connect and sync data';
				}
			?>
				
			<div class="ihealth-connect cardiowell weighingscale">
				<h6>Cellular Monitoring: Weighing Scale</h6>
				<p>Connection Status: <span class="status <?php echo $class; ?>"><?php echo $status; ?></span></p>
				<a href="javascript:;" class="button <?php echo $buttonClass; ?>" data-machine="weight" data-imei="<?php echo $row['imei']; ?>"><?php echo $buttonLabel; ?></a>
			</div>

		</div>
	</div>
            
    <?php mysqli_close(ddxrxDBConnect()); ?>
            
    <div style="width: 100%; height: 80px;"></div>    
</body>
</html>