$(document).ready(function(){
    
    // Enter key function
    $.fn.pressEnter = function(fn){
        return this.each(function() {  
            $(this).bind('enterPress', fn);
            $(this).keyup(function(e){
                if(e.keyCode == 13){
                    $(this).trigger("enterPress");
                }
            });
        });  
    };
    
    // Enter key pressed
    $('.msg-box').pressEnter(function(){
        $('.sendfaqchat').click();
    });
    
    // F.A.Q Chat Bot
    $('.sidebar-chat-bot .chat-button, .chat-button').click(function(){
        var i = 0;
        $('.chat-widget').addClass('show');
        
        var sendData = {
            "payload" : "0"
        };
        
        $.ajax({
            type: "POST",
            //url: 'https://waitingroom.ai/faq',
            url: 'process/api-data.php?target=faq&parameter=faq',
            data: JSON.stringify(sendData),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            beforeSend: function() {},
            success: function(data) {
            	
            	let result = data;
            	for( let botResponse of result ){
            	    
            	    i++;
            	    
            	    setTimeout(function(){
            	        
            	        // Show Text
            	        $('.sidebar-chat-bot .chat-widget .inner').append('<img src="assets/images/bot-chat-head.png" class="chat-head"><div class="item text bot"><p>'+botResponse.text+'</p></div><div class="clear"></div>');
            	        
            	        // Show buttons
            	        if( botResponse.buttons != undefined ){
            	            
                            $('.sidebar-chat-bot .chat-widget .inner').append('<div class="buttons-container"></div>');
            	            
            	            let buttonResult = botResponse.buttons;
            	            for( let getButton of buttonResult ){
            	                $('.sidebar-chat-bot .chat-widget .inner .buttons-container').append('<a href="javascript:;" data-action="'+getButton.payload+'" class="faq-button">'+getButton.text+'</a>');
            	            }
            	            
            	        }
            	        
            	        // Scroll to bottom of chat
                        $('.sidebar-chat-bot .chat-widget .inner').scrollTop($('.sidebar-chat-bot .chat-widget .inner')[0].scrollHeight);
            	        
            	    }, 1500 * i );
            	    
            	}
                
            },  
            fail: function(response){
                // Do Something
            }
        });
        
    });
    
    
    // F.A.Q Chat Bot Button clicked
    $('body').on('click', '.sidebar-chat-bot .chat-widget .inner .faq-button', function() {
        
        var i = 0;
        var payload = $(this).attr('data-action');
        var sendData = {
            "payload" : payload,
            'query' : ''
        };
        var selectedOption = $(this).text();
        
        $('.sidebar-chat-bot .chat-widget .inner').append('<div class="item text human"><p>'+selectedOption+'</p></div><div class="clear"></div>');
        
        // Scroll to bottom of chat
        $('.sidebar-chat-bot .chat-widget .inner').scrollTop($('.sidebar-chat-bot .chat-widget .inner')[0].scrollHeight);
        
        $.ajax({
            type: "POST",
            //url: 'https://waitingroom.ai/faq',
            //url: 'https://waitingroom.ai/faq_combine',
            url: 'process/api-data.php?target=faq&parameter=faq_combine',
            data: JSON.stringify(sendData),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            
            success: function(data) {
            	
            	let result = data;
            	for( let botResponse of result ){
            	    
            	    i++;
            	    
            	    setTimeout(function(){
            	       
                        // Remove previous buttons
                        $('.sidebar-chat-bot .chat-widget .inner .buttons-container').remove();

            	        // Show Text
            	        $('.sidebar-chat-bot .chat-widget .inner').append('<img src="assets/images/bot-chat-head.png" class="chat-head"><div class="item text bot"><p>'+botResponse.text+'</p></div><div class="clear"></div>');
            	        
            	        // Show buttons
            	        if( botResponse.buttons != undefined ){
            	            
                            // Generate button container
                            $('.sidebar-chat-bot .chat-widget .inner').append('<div class="buttons-container"></div>');

            	            let buttonResult = botResponse.buttons;
            	            for( let getButton of buttonResult ){
            	                $('.sidebar-chat-bot .chat-widget .inner .buttons-container').append('<a href="javascript:;" data-action="'+getButton.payload+'" class="faq-button">'+getButton.text+'</a>');
            	            }
            	            
            	        }
            	        
            	        // Scroll to bottom of chat
                        $('.sidebar-chat-bot .chat-widget .inner').scrollTop($('.sidebar-chat-bot .chat-widget .inner')[0].scrollHeight);
            	        
            	    }, 1500 * i );
            	    
            	}
            	
                
            }

        });
        
    });
    
    // Send text to bot
    $('body').on('click', '.sendfaqchat', function() {
        
        var i = 0;
        var msgText = $('.msg-box').val();
        var sendData = {
            "payload" : 'text',
            'query' : msgText
        };
        
        // Reset textbox
        $('.msg-box').val('');
        
        // Display value in chat
        $('.sidebar-chat-bot .chat-widget .inner').append('<div class="item text human"><p>'+msgText+'</p></div><div class="clear"></div>');
        
        // Scroll to bottom of chat
        $('.sidebar-chat-bot .chat-widget .inner').scrollTop($('.sidebar-chat-bot .chat-widget .inner')[0].scrollHeight);
        
        $.ajax({
            type: "POST",
            //url: 'https://waitingroom.ai/faq',
            //url: 'https://waitingroom.ai/faq_combine',
            url: 'process/api-data.php?target=faq&parameter=faq_combine',
            data: JSON.stringify(sendData),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            
            success: function(data) {
            	
            	let result = data;
            	for( let botResponse of result ){
            	    
            	    i++;
            	    
            	    setTimeout(function(){
            	        
            	        // Show Text
            	        $('.sidebar-chat-bot .chat-widget .inner').append('<img src="assets/images/bot-chat-head.png" class="chat-head"><div class="item text bot"><p>'+botResponse.text+'</p></div><div class="clear"></div>');
            	        
            	        // Show buttons
            	        if( botResponse.buttons != undefined ){
            	            
            	            // Remove previous buttons
                            $('.sidebar-chat-bot .chat-widget .inner .buttons-container').remove();
            	            
            	            //$('.sidebar-chat-bot .chat-widget .inner').append('<div style="width:100%; height: 30px;"></div>');
                            $('.sidebar-chat-bot .chat-widget .inner').append('<div class="buttons-container"></div>');
            	            
            	            let buttonResult = botResponse.buttons;
            	            for( let getButton of buttonResult ){
            	                $('.sidebar-chat-bot .chat-widget .inner .buttons-container').append('<a href="javascript:;" data-action="'+getButton.payload+'" class="faq-button">'+getButton.text+'</a>');
            	            }
            	            
            	        }
            	        
            	        // Scroll to bottom of chat
                        $('.sidebar-chat-bot .chat-widget .inner').scrollTop($('.sidebar-chat-bot .chat-widget .inner')[0].scrollHeight);
            	        
            	    }, 1500 * i );
            	    
            	}
                
            }

        });
        
    });
    
    $('.sidebar-chat-bot .chat-widget .titlebar img').click(function(){
        $('.chat-widget').removeClass('show');
        $('.sidebar-chat-bot .chat-widget .inner').html(''); 
    });
    
    $('.tab.home').click(function(){
        
        $('.tab').removeClass('active');
        $(this).addClass('active');
        $('.hidden-content').removeClass('show');
        $('.hidden-content.from-home').addClass('show');
            
    });
    
    $('.tab.hospital').click(function(){
        
        $('.tab').removeClass('active');
        $(this).addClass('active');
        $('.hidden-content').removeClass('show');
        $('.hidden-content.from-hospital').addClass('show');
            
    });
    
});