$(document).ready(function(){
    
    // Process Image Upload
    function ProcessFileUpload(uploadtype, user_id, imageUrl){
        
        if( uploadtype != '' && user_id != '' && imageUrl != '' ){
        
            $.ajax({
    			type: 'POST',
    			url: 'process/patientprofileupload.php?uploadtype='+uploadtype,
    
    			data: {
    			    user_id:user_id,
    				imageUrl:imageUrl
    			},
    
    			beforeSend: function() {
    					
    			},
    			success: function(response) {
                        
                    Swal.fire({
                        icon: response.rstatus,
                        title: response.rstatus,
                        text: response.desc,
                    });
                    
                    $('.image-loading-screen').removeClass('show');  
                        
    			},	
    			fail: function(response){
    				// Do Something
    			}
    
    		});
    		// End Ajax
		
        }else{
            
            Swal.fire({
                icon: 'error',
                title: 'Internal Error',
                text: "There seems to be an internal server error.",
            });
            
        }
		
    }
    
    
    
    /* ================================================================== */
    // Profile Upload
    /* ================================================================== */
    
    $(document).on('change', '#upload_profile', function(){
        var upload_image = new FormData();
        var name = document.getElementById("upload_profile").files[0].name;
        var encounter_id = '0000001';
        var user_id = $('body').data('user-id');
        
        upload_image.append('encounter_id', encounter_id);
        upload_image.append('imageFile', $("#upload_profile")[0].files[0]);

        $.ajax({
            //
            url: 'https://ddxrx.com/imageprocessing/index.php',
            // url: 'data.php',
            method:"POST",
            data: upload_image,
            contentType: false,
            cache: false,
            processData: false,
            //
            beforeSend: function() {
                $('#ProfilePicturePlaceholder').append('<div class="loading"></div>');
            },
            success: function(data) {
                
                if( data.upload_status == 'success' ){
                    
                    $('#ProfilePicturePlaceholder').html('<img src="'+data.image_url+'">');
                    ProcessFileUpload('profile', user_id, data.image_url);
                    
                }else{
                    Swal.fire({
                        icon: 'error',
                        title: 'Upload Failed',
                        text: "image uploading failed.",
                    });
                }
                
            },  
            fail: function(response){
                // Do Something
            }

        });
        // End Ajax

    });
	
	
	/* ================================================================== */
    // License Upload
    /* ================================================================== */
    $(document).on('change', '#upload_license', function(){
        var upload_image = new FormData();
        var name = document.getElementById("upload_license").files[0].name;
        var encounter_id = '0000001';
        var user_id = $('body').data('user-id');
        
        upload_image.append('encounter_id', encounter_id);
        upload_image.append('imageFile', $("#upload_license")[0].files[0]);

        $.ajax({
            //
            url: 'https://ddxrx.com/imageprocessing/index.php',
            // url: 'data.php',
            method:"POST",
            data: upload_image,
            contentType: false,
            cache: false,
            processData: false,
            //
            beforeSend: function() {
                $('#LicensePicturePlaceholder').append('<div class="loading"></div>');
            },
            success: function(data) {
                
                if( data.upload_status == 'success' ){
                    
                    $('#LicensePicturePlaceholder').html('<img src="'+data.image_url+'">');
                    ProcessFileUpload('license', user_id, data.image_url);
                    
                }else{
                    Swal.fire({
                        icon: 'error',
                        title: 'Upload Failed',
                        text: "image uploading failed.",
                    });
                }
                
            },  
            fail: function(response){
                // Do Something
            }

        });
        // End Ajax

    });
	
	
	
	/* ================================================================== */
    // Insurance Upload
    /* ================================================================== */
    $(document).on('change', '#upload_insurance', function(){
        var upload_image = new FormData();
        var name = document.getElementById("upload_insurance").files[0].name;
        var encounter_id = '0000001';
        var user_id = $('body').data('user-id');
        
        upload_image.append('encounter_id', encounter_id);
        upload_image.append('imageFile', $("#upload_insurance")[0].files[0]);

        $.ajax({
            //
            url: 'https://ddxrx.com/imageprocessing/index.php',
            // url: 'data.php',
            method:"POST",
            data: upload_image,
            contentType: false,
            cache: false,
            processData: false,
            //
            beforeSend: function() {
                $('#InsurancePicturePlaceholder').append('<div class="loading"></div>');
            },
            success: function(data) {
                
                if( data.upload_status == 'success' ){
                    
                    $('#InsurancePicturePlaceholder').html('<img src="'+data.image_url+'">');
                    ProcessFileUpload('insurance', user_id, data.image_url);
                    
                }else{
                    Swal.fire({
                        icon: 'error',
                        title: 'Upload Failed',
                        text: "image uploading failed.",
                    });
                }
                
            },  
            fail: function(response){
                // Do Something
            }

        });
        // End Ajax

    });
	
});