// Loading Screen
$(document).ready(function() {
    $('.loading-screen').fadeOut();
});

$(document).ready(function(){
    
    /* ================================================================== */
    // Append instuction text to element
    /* ================================================================== */
    $('<div class="notice arrow-down" style="text-transform: uppercase">Tap if answer is yes</div>').insertAfter(".symptom-list-container h6");
    
    /* ================================================================== */
    // Set Minimum height of screen
    /* ================================================================== */
    var min_height = $(window).height();
    $('.login-container').css('height' , min_height);
    
    /* ================================================================== */
    // Floating Menu
    /* ================================================================== */
    $('.floating-menu-container').hide();
    
    // Open Nav
    $('.floating-menu-icon').click(function(){
         $('.floating-menu-container').fadeIn();
    });
    // CLose Nav
    $('.floating-menu-icon.close, .home_menu_login').click(function(){
         $('.floating-menu-container').fadeOut();
         $('.floating-menu-container ul li .pricing-box').fadeOut();
    });
    
    // Show Menu Pricing Box
    $('.floating-menu-container ul li').click(function(){
        $('.floating-menu-container ul li .pricing-box').fadeOut();
        $('.pricing-box',this).fadeIn();
    });
    
    // Initialize Custom Scroll Bar
    //$(".floating-menu-container .inner").customScrollbar();
    var scroll_height = min_height-150;
    $('.floating-menu-container .inner').css('height' , scroll_height);
    
    
    
    
    
    /* ================================================================== */
    // Hide/Show Elements
    /* ================================================================== */
    $('.ddx_reports .icon-container').fadeIn();
    $('.search_dd .icon-container').fadeIn();
    
    $('.ddx_reports .anatomy-form').fadeOut();
    //$('.search_dd .anatomy-form').fadeOut();
    
    $('.ddx_reports .main-slider-container').fadeOut();
    //$('.search_dd .main-slider-container').fadeOut();
    
    $('.ddx_reports .search-form-container').fadeOut();
    $('.search_dd .search-form-container').fadeOut();
    
    $('.ddx_reports .medical-history').fadeOut();
    
    
    
    
    
    
    
    /* ================================================================== */
    // search_dd buttons
    /* ================================================================== */
    
    // Search Box
    $('.mobile-menu-container.search_page a.search, a.search').click(function(){
        $('.icon-container.form_box').css({ "opacity": "0", "position": "fixed", "left": "-120%", "top": "0px" });
        $('.main-slider-container.form_box').css({ "opacity": "0", "position": "fixed", "left": "-120%", "top": "0px" });
        
        setTimeout(function() {
            $('.anatomy-form.form_box').css({ "opacity": "1", "position": "relative", "left": "0px" });
        }, 500);
    });
    
    // System Icons
    $('.mobile-menu-container.search_page a.browse, a.browse').click(function(){
        $('.anatomy-form.form_box').css({ "position": "fixed", "left": "-120%", "top": "0px", "opacity": "0" });
        $('.main-slider-container.form_box').css({ "position": "fixed", "left": "-120%", "top": "0px", "opacity": "0" });
        
        setTimeout(function() {
            $('.icon-container.form_box').css({ "opacity": "1", "position": "relative", "left": "0px" });
        }, 500);
    });
    
    
    $('.icon-list li').click(function(){
    
        $('.anatomy-form.form_box').css({ "position": "fixed", "left": "-120%", "top": "0px", "opacity": "0" });
        $('.icon-container.form_box').css({ "opacity": "0", "position": "fixed", "left": "-120%", "top": "0px" });
        
        $('.icon_result').hide();
        $('.icon_result.'+$(this).attr('class')).show();
        
        setTimeout(function() {
            $('.main-slider-container.form_box').css({ "opacity": "1", "position": "relative", "left": "0px" });
        }, 500);
        
    });
    
    
    /* ================================================================== */
    // ddx_reports buttons
    /* ================================================================== */
    
    // EMR
    $('.mobile-menu-container.reports_page a.emr,a.emr').click(function(){
        $('.search-form-container').fadeOut();
        $('.results_list_container').fadeOut();
        $('.medical-history').fadeIn();
    });
    
    // Browse
    $('.mobile-menu-container.reports_page a.browse,a.browse').click(function(){
        $('.medical-history').fadeOut();
        $('.search-form-container').fadeOut();
        $('.results_list_container').fadeIn();
    });
    
    // Search
    $('.mobile-menu-container.reports_page a.search,a.search').click(function(){
        $('.medical-history').fadeOut();
        $('.results_list_container').fadeOut();
        $('.search-form-container').fadeIn();
        $('.anatomy-form').fadeIn();
    });
    
    // upload
    $('.mobile-menu-container.reports_page a.upload_button,a.upload_button').on({ 'touchstart click' : function(){
        $('#symptom_photo').click();
    }});
    
    // upload
    $('#camera_picture').on({ 'touchstart click' : function(){
        $('#symptom_photo').click();
    }});
    
    
    /* ================================================================== */
    // Sweet Alert
    /* ================================================================== */
    $(".symptom-list li a").click(function(){
        
        var counter = 0;
        
        if( $(this).parent().attr('class') == 'sub-2' ){
        	var symptom = "";
        }else{
            
            // Start
            if( $(this).data('symptom') != undefined ){
                
                /*
                Swal.fire({
                    position: 'top-center',
                    icon: 'success',
                    title: $(this).data('symptom')+' Added',
                    text: "Add another symptom",
                    showConfirmButton: true,
                });
                */
                
                $(".anatomy-form .textbox").each(function(){
                    
                    if( $(this).val() != '' ){
                       counter++;
                       
                       if( counter == 1 ){
                           Swal.fire({
                                position: 'top-center',
                                icon: 'success',
                                title: 'Add 2nd symptom',
                                text: $(this).val()+" Added",
                                showConfirmButton: true,
                            });
                       }else if(counter == 2){
                            Swal.fire({
                                title: 'Three symptoms improves accuracy',
                                text: "Do you want to click on search to find diagnoses or add more symptoms?",
                                icon: 'warning',
                                showCancelButton: true,
                                confirmButtonColor: '#3085d6',
                                cancelButtonColor: '#FF0033',
                                confirmButtonText: 'Search',
                                cancelButtonText: 'Add More'
                                    }).then((result) => {
                                        if (result.value) {
                                            $('.search-submit-btn').click();
                                    }
                            });
                       }else if(counter == 3){
                            Swal.fire({
                                title: 'Third symptom added',
                                text: "Do you want to click on search to find diagnoses or add more symptoms?",
                                icon: 'warning',
                                showCancelButton: true,
                                confirmButtonColor: '#3085d6',
                                cancelButtonColor: '#FF0033',
                                confirmButtonText: 'Search',
                                cancelButtonText: 'Add More'
                                }).then((result) => {
                                    if (result.value) {
                                        $('.search-submit-btn').click();
                                }
                            });
                       }else if(counter == 4){
                            Swal.fire({
                                title: 'Fourth symptom added',
                                text: "Do you want to click on search to find diagnoses or add more symptoms?",
                                icon: 'warning',
                                showCancelButton: true,
                                confirmButtonColor: '#3085d6',
                                cancelButtonColor: '#FF0033',
                                confirmButtonText: 'Search',
                                cancelButtonText: 'Add More'
                                }).then((result) => {
                                    if (result.value) {
                                        $('.search-submit-btn').click();
                                }
                            });
                       }else if(counter == 5){
                            Swal.fire({
                                title: 'Fourth symptom added',
                                text: "Do you want to click on search to find diagnoses or add more symptoms?",
                                icon: 'warning',
                                showCancelButton: true,
                                confirmButtonColor: '#3085d6',
                                cancelButtonColor: '#FF0033',
                                confirmButtonText: 'Search',
                                cancelButtonText: 'Add More'
                                }).then((result) => {
                                    if (result.value) {
                                        $('.search-submit-btn').click();
                                }
                            });
                       }
                       
                    }
                });
                
                //alert(counter);
                
            } // End
            
            //$('.form_box').fadeOut();
            //$('.icon-container.form_box').fadeIn();
        	
        }

	});
    
    /* ================================================================== */
    // Subscribe Alert
    /* ================================================================== */
    $(".subscribe-notice").click(function(){
        Swal.fire({
            icon: 'warning',
            title: 'EMR is for premium users only',
            text: "Please subscribe to access EMR features",
        });
	});
	
	
	$(".save_and_connect_button").click(function(){
    	Swal.fire({
            title: 'Submit to Doctor is for premium users only',
            text: "Please subscribe to access this feature",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Subscribe Now',
            cancelButtonText: 'Continue free trial',
        }).then((result) => {
            if (result.value) {
                window.location.href = "subscription.php";
            }
        });
	});
    
    
    /* ================================================================== */
    // Slider button check
    /* ================================================================== */
    $('#search_placeholder').click(function(){
        $('#searchddx').click();
    });
    
    
    
    /* ================================================================== */
    // Custom Upload Button for Profile
    /* ================================================================== */
    $('.imageplaceholder').on({ 'touchstart click' : function(){
        $('input:file',this).click();
    }});
    
    
    /* ================================================================== */
    // Login Disclaimer Popup
    /* ================================================================== */
    $('.login_trigger, #provider_login').click(function(){
        $('#login-content').hide();
        $('.disclaimer-popup-container').fadeIn();
    });
    
    $('.i_disagree').click(function(){
        $('#login-content').show();
        $('.disclaimer-popup-container').fadeOut();
    });
    
    
    
    /* ================================================================== */
    // Back button for symptom's list
    /* ================================================================== */
    $('.main-slider-container img.back').on({ 'touchstart click' : function(){
        $('.anatomy-form.form_box').css({ "position": "fixed", "left": "-120%", "top": "0px", "opacity": "0" });
        $('.main-slider-container.form_box').css({ "position": "fixed", "left": "-120%", "top": "0px", "opacity": "0" });
        
        setTimeout(function() {
            $('.icon-container.form_box').css({ "opacity": "1", "position": "relative", "left": "0px" });
        }, 500);
    }});
    
    
    /* ================================================================== */
    // Show Loading Screen when button clicked
    /* ================================================================== */
    $('.home-screen a').on({ 'touchstart click' : function(){
        $('.loading-screen').fadeIn();
        window.location.href = $(this).attr('href');
    }});
    
    $('.mobile-menu-container li.home a').on({ 'touchstart click' : function(){
        $('.loading-screen').fadeIn();
        window.location.href = $(this).attr('href');
    }});
    
    $('#searchddx').on({ 'touchstart click' : function(){
        $('.loading-screen').fadeIn();
    }});
    
    $('.mobile-menu-container .back-link').on({ 'touchstart click' : function(){
        $('.loading-screen').fadeIn();
        window.location.href = $(this).attr('href');
    }});
    
    $('slicknav_nav li a').on({ 'touchstart click' : function(){
        $('.loading-screen').fadeIn();
        window.location.href = $(this).attr('href');
    }});
    
    $('.no-loading').click(function(){
        
        $('.loading-screen').fadeOut();
        
    });
    
    
    /* ================================================================== */
    // Change Notice Value for chronic care visit and acute care visit
    /* ================================================================== */
    $('.button-container #new_patient').click(function(){
        $('.form_box .notice.arrow-down').html('Tap if answer is yes');
    });
    
    $('.button-container #follow_up').click(function(){
        $('.form_box .notice').html('Click any diagnosis you want to follow up or click "Add All to Search" to include all diagnoses');
    });
    
    
    
    // ==================================================== //
    // Upload Symptoms Photo
    // ==================================================== //
    
    // Process Image Upload
    function process_upload(patient_id,encounter_id,imageFile){
        
        $.ajax({
			type: 'POST',
			url: 'process/image_upload_symptom.php',

			data: {
			    patient_id:patient_id,
				encounter_id:encounter_id,
				imageFile:imageFile
			},

			beforeSend: function() {
					
			},
			success: function(response) {
                    
                Swal.fire({
                    icon: 'success',
                    title: 'Upload Complete',
                    text: "Image has been uploaded to the server",
                });
                
                $('.image-loading-screen').removeClass('show');  
                    
			},	
			fail: function(response){
				// Do Something
			}

		});
		// End Ajax
		
    }
    
    $(document).on('change', '#symptom_photo', function(){
        var name = document.getElementById("symptom_photo").files[0].name;
        var upload_image = new FormData();
        var encounter_id = $('.mobile-menu-container.reports_page').data('vitals-encounter');
        var patient_id = $('.mobile-menu-container.reports_page').data('patient-id');
        upload_image.append('encounter_id', encounter_id);
        upload_image.append('imageFile', $("#symptom_photo")[0].files[0]);

        $.ajax({
            //
            url: 'https://ddxrx.com/imageprocessing/index.php',
            // url: 'data.php',
            method:"POST",
            data: upload_image,
            contentType: false,
            cache: false,
            processData: false,
            //
            beforeSend: function() {
                $('.image-loading-screen').addClass('show');
            },
            success: function(data) {

                if( data.upload_status == 'success' ){
                    process_upload( patient_id, encounter_id, data.image_url );
                }else{
                    Swal.fire({
                        icon: 'error',
                        title: 'Upload Failed',
                        text: "image uploading failed.",
                    });
                }
                
            },  
            fail: function(response){
                // Do Something
            }

        });
        // End Ajax

    });
    
    // Cancel upload
    $('.image-loading-screen a.cancel').click(function(){
        $('.image-loading-screen').removeClass('show');
    });
    
    // Temporary Video Call Message
    $('#video_call').click(function(){
         Swal.fire({
            icon:  'warning',
            title: 'Video Call',
            text:  "Please click on the chat and request to activate video call.",
        });
    });
    
    
    $('.home-screen .item.rating').click(function(){
        $('.feedback-container').fadeIn(); 
    });
    
    $('.send_feedback').click(function(){
        Swal.fire({
            icon: 'success',
            title: 'Thank you for your feedback',
            //text: "Thank you for your feedback, we take your comments and suggestions seriously and apply it to our app if necessesary.",
        });
        $('.feedback-container').fadeOut();
    });
    
    $('.feedback-container .star-1').click(function(){
        $('.ratings').val('1');
        $('.feedback-container .star').attr('src','assets/images/star.png');
        
        $('.feedback-container .star-1').attr('src','assets/images/star-color.png');
    });
    
    $('.feedback-container .star-2').click(function(){
        $('.ratings').val('2');
        $('.feedback-container .star').attr('src','assets/images/star.png');
        
        $('.feedback-container .star-1').attr('src','assets/images/star-color.png');
        $('.feedback-container .star-2').attr('src','assets/images/star-color.png');
    });
    
    $('.feedback-container .star-3').click(function(){
        $('.ratings').val('3');
        $('.feedback-container .star').attr('src','assets/images/star.png');
        
        $('.feedback-container .star-1').attr('src','assets/images/star-color.png');
        $('.feedback-container .star-2').attr('src','assets/images/star-color.png');
        $('.feedback-container .star-3').attr('src','assets/images/star-color.png');
    });
    
    $('.feedback-container .star-4').click(function(){
        $('.ratings').val('4');
        $('.feedback-container .star').attr('src','assets/images/star.png');
        
        $('.feedback-container .star-1').attr('src','assets/images/star-color.png');
        $('.feedback-container .star-2').attr('src','assets/images/star-color.png');
        $('.feedback-container .star-3').attr('src','assets/images/star-color.png');
        $('.feedback-container .star-4').attr('src','assets/images/star-color.png');
    });
    
    $('.feedback-container .star-5').click(function(){
        $('.ratings').val('5');
        $('.feedback-container .star').attr('src','assets/images/star.png');
        
        $('.feedback-container .star-1').attr('src','assets/images/star-color.png');
        $('.feedback-container .star-2').attr('src','assets/images/star-color.png');
        $('.feedback-container .star-3').attr('src','assets/images/star-color.png');
        $('.feedback-container .star-4').attr('src','assets/images/star-color.png');
        $('.feedback-container .star-5').attr('src','assets/images/star-color.png');
    });
    
    $('.cancel_feedback').click(function(){
        $('.feedback-container').fadeOut();
    });
    
    
    
    
    
    // Open Chat
    $('body').on('touchstart click', '.chat-center', function() {
        $('.patient_chat_widget').addClass('show');
    });
    $('body').on('touchstart click', '.open-chat', function() {
        $('.loading-screen').fadeOut();
        $('.patient_chat_widget').addClass('show');
    });
    
    
    $('body').on('touchstart click', '.close-message', function() {
        $('.patient_chat_widget').removeClass('show');
    });
    
    // Scroll to bottom
    function scrollToBottom(){
        $(".sidebar-chat-bot .chat-widget .inner").scrollTop($(".sidebar-chat-bot .chat-widget .inner")[0].scrollHeight);
    }
    
    // F.A.Q Chat Bot
    /*
    $('.sidebar-chat-bot .chat-button').click(function(){
        
        var i = 0;
        $('.chat-widget').addClass('show');
        
        var sendData = {
            "payload" : "0"
        };
        
        $.ajax({
            type: "POST",
            //url: 'https://ddxrx.ai/faq',
            url:'https://waitingroom.ai/faq',
            data: JSON.stringify(sendData),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            
            beforeSend: function() {
                
            },
            success: function(data) {
            	
            	let result = data;
            	for( let botResponse of result ){
            	    
            	    i++;
            	    
            	    setTimeout(function(){
            	        
            	        // Show Text
            	        $('.sidebar-chat-bot .chat-widget .inner').append('<div class="item text bot"><p>'+botResponse.text+'</p></div><div class="clear"></div>');
            	        
            	        // Show buttons
            	        if( botResponse.buttons != undefined ){
            	            
            	            $('.sidebar-chat-bot .chat-widget .inner').append('<div style="width:100%; height: 30px;"></div>');
            	            
            	            let buttonResult = botResponse.buttons;
            	            for( let getButton of buttonResult ){
            	                //scrollToBottom();
            	                $('.sidebar-chat-bot .chat-widget .inner').append('<a href="javascript:;" data-action="'+getButton.payload+'" class="faq-button">'+getButton.text+'</a>');
            	            }
            	            
            	        }
            	        
            	        // Scroll to bottom of chat bot
            	        scrollToBottom();
            	        
            	    }, 1500 * i );
            	    
            	}
            	
                
            },  
            fail: function(response){
                // Do Something
            }

        });
        
    });
    */
    
    // F.A.Q Chat Bot Button clicked
    /*
    $('body').on('click', '.sidebar-chat-bot .chat-widget .inner .faq-button', function() {
        
        var i = 0;
        var payload = $(this).attr('data-action');
        
        var sendData = {
            "payload" : payload
        };
        
        $.ajax({
            type: "POST",
            //url: 'https://ddxrx.ai/faq',
            url: 'https://waitingroom.ai/faq',
            data: JSON.stringify(sendData),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            
            success: function(data) {
            	
            	let result = data;
            	for( let botResponse of result ){
            	    
            	    i++;
            	    
            	    setTimeout(function(){
            	        
            	        // Show Text
            	        $('.sidebar-chat-bot .chat-widget .inner').append('<div class="item text bot"><p>'+botResponse.text+'</p></div><div class="clear"></div>');
            	        
            	        // Show buttons
            	        if( botResponse.buttons != undefined ){
            	            
            	            $('.sidebar-chat-bot .chat-widget .inner').append('<div style="width:100%; height: 30px;"></div>');
            	            $('.sidebar-chat-bot .chat-widget .inner').append('<div>');
            	            
            	            let buttonResult = botResponse.buttons;
            	            for( let getButton of buttonResult ){
            	                //scrollToBottom();
            	                $('.sidebar-chat-bot .chat-widget .inner').append('<a href="javascript:;" data-action="'+getButton.payload+'" class="faq-button">'+getButton.text+'</a>');
            	            }
            	            
            	            $('.sidebar-chat-bot .chat-widget .inner').append('</div>');
            	            
            	        }
            	        
            	        // Scroll to bottom of chat bot
            	        scrollToBottom();
            	        
            	    }, 1500 * i );
            	    
            	}
            	
                
            }

        });
        
    });
    */
    /*
    $('.sidebar-chat-bot .chat-widget .titlebar img').click(function(){
        $('.chat-widget').removeClass('show');
        $('.sidebar-chat-bot .chat-widget .inner').html(''); 
    });
    */
});