<?php

    session_start();
    if( $_SESSION['userType'] != 'doctor' && $_SESSION['userType'] != 'nurse' ) {
        header("Location: provider_login.php");
        die();
    }
    
    date_default_timezone_set('America/Chicago');
    
    include('process/functions.php');
    include('includes/database_include.php');
    
    function get_user_info( $patient_id, $field = null ){
        
        //$patient_id = $_GET["patient_id"];
        $servername = "localhost";
        $username = "ddxrx_patient";
        $password = "Coastpcp%003";
        $dbname = "telemedicine";
                            
        // Create connection
        $mysqli = new mysqli($servername, $username, $password, $dbname);
        
        // Check connection
        if ($mysqli->connect_error) {
            die("Connection failed: " . $mysqli->connect_error);
        }
    
        $query = "SELECT * FROM patients WHERE patient_id = '$patient_id' limit 1";
        
        $results = array();
        
        if ($result = $mysqli->query($query)) {
    
            /* fetch associative array */
            while ($row = $result->fetch_assoc()) {
                $results[] = $row;
            }
    
            /* free result set */
            $result->free();
        }
        
        /* close connection */
        $mysqli->close();
        
        /* print json object*/
        return $results[0][$field];
        
    }
    
?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
	<title>Patient Vital Dashboard</title>
	
	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
    <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
    <link rel="stylesheet" type="text/css" href="assets/css/vitals_history.css">
    <link rel="stylesheet" type="text/css" href="assets/css/sweetalert2.min.css">
    <link rel="stylesheet" type="text/css" href="assets/css/dashboard_responsive.css">
	<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css">
	
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
	<script type="text/javascript" src="assets/js/sweetalert2.min.js"></script>
	<script type="text/javascript" src="//cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js"></script>
	<script type="text/javascript" src="assets/js/vitals_history.js"></script>
	
	<script type="text/javascript">
	    $(document).ready(function(){
	        
	        // Load DataTable JS
            $('#myTable').DataTable({
                "pageLength": 20,
                "bSort": false
            });
            
        });
	</script>
	
</head>
<body>
    
    <!-- Popup -->
    <div class="popup-container">
        <div class="popup">
            <h6>Add Vital Information</h6>
            <div class="padded">
                
                <input type="hidden" id="hidden_patient_id" value="<?php echo $_GET['patient_id']; ?>">
                
                <div class="col-md-6">
                    <label>
                        <span>Systolic BP</span>
                        <input type="text" class="textbox" id="systolicBP" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Diastolic BP</span>
                        <input type="text" class="textbox" id="diastolicBP" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Heart Rate</span>
                        <input type="text" class="textbox" id="heartRate" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Respiratory Rate</span>
                        <input type="text" class="textbox" id="respRate" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Pulse OX</span>
                        <input type="text" class="textbox" id="pulseOX" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Temperature</span>
                        <input type="text" class="textbox" id="temp" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Glucose</span>
                        <input type="text" class="textbox" id="glucose" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Weight</span>
                        <input type="text" class="textbox" id="weight" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 50px;"></div>
                
                <div class="col-md-12">
                    <a href="javascript:;" class="button blue add_vitals">Add Vitals</a>
                    <a href="javascript:;" class="button red cancel">Cancel</a>
                    <div class="clear"></div>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
            </div>
        </div>
    </div>
    <!-- Popup -->
    
    <!-- Header -->
    <div class="header">
        <div class="container">
            
            <div class="padded">
                <div class="patient-info">
                    <h3 class="tabtitle">Billing Dashboard</h3>
                    <div class="clear"></div>
                </div>
            </div>
            
            
            
        </div>
        
        <div class="menu-container">
            <?php include('nurse_dashboard_nav.php'); ?>
            <div class="clear"></div>
        </div>
        
    </div>
    <!-- Header -->
    
    <div class="container">
        <div class="TableContainer">
            <table id="myTable">
            	<thead>
                    <tr>
                        <td>First Name</td>
                        <td>Last Name</td>
                        <td>Gender</td>
                        <td>DOB</td>
                        <td>CPT Code</td>
                        <td>Date of service</td>
                    </tr>
                </thead>
    
                <tbody>
                    
                    <?php
                    $groupid = get_version();
                    $sql = "SELECT * FROM billing_code INNER JOIN patients ON billing_code.patient_id = patients.patient_id WHERE billing_code.groupid = '$groupid'";
                    $result = ddxrxDBConnect()->query($sql);
                    
                    if ($result->num_rows > 0) {
                        // output data of each row
                        while($row = $result->fetch_assoc()) {
                            
                            if( $row["patient_gender"] == 'm' || $row["patient_gender"] == 'M' ){
                                $gender = 'Male';
                            }elseif( $row["patient_gender"] == 'f' || $row["patient_gender"] == 'F' ){
                                $gender = 'Female';
                            }
                            
                            echo '<tr>';
                            echo '<td>'.$row["patient_fname"].'</td>';
                            echo '<td>'.$row["patient_lname"].'</td>';
                            echo '<td>'.$gender.'</td>';
                            echo '<td>'.$row["patient_dob"].'</td>';
                            
                            echo '<td>'.$row["cpt_code"].'</td>';
                            echo '<td>'.$row["date_of_service"].'</td>';
                            echo '</tr>';
                            
                        }
                    } else {
                        echo "0 results";
                    }
                    
                    ddxrxDBConnect()->close();
                    ?>
                    
                </tbody>
            </table>
            
            <a href="process/export_billing_code.php" target="_blank" style="background: #2ecc71; color: #FFFFFF; padding: 10px; padding-left: 15px; padding-right: 15px; border-radius: 3px; font-weight: 600; display: inline-block; margin-top: 20px; text-decoration: none">Export</a>
            
        </div>
    </div>
    
    <?php provider_bottom_nav(); ?>
    
</body>
</html>