<?php 
    ob_start();
    error_reporting(0);
    session_start();

    unset($_SESSION['checkbox_selected']);
    unset($_SESSION['dataArray']);
    unset($_SESSION['review']);
    unset($_SESSION['vital']);
    unset($_SESSION['physical_exam']);
    
    include ('includes/database_include.php');
    include ('analytics.php');
    
    foreach (array_unique($_SESSION['names']) as $key => $value) {
        unset($_SESSION[$value]);
    }
    
    unset($_SESSION['names']);
    unset($_SESSION['denied']);
    unset($_SESSION['deniedfinal']);
    unset($_SESSION['visitor_info_id']);
?>
<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Artificial Intelligence Software for Medicine: DDxRx Software</title>
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
<link rel="stylesheet" href="css/jquery.autocomplete.css" type="text/css" />
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<script type="text/javascript" src="js/jquery.autocomplete.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
<script type="text/javascript" src="js/jquery.validate.min.js"></script> 
<script type="text/javascript">
	$(document).ready(function(){
		<?php 
		if (strlen($varSSLists)<=100)
		{
			$varSSLists="";
			$result = mysqli_query($con, "SELECT distinct(symptom_name) FROM drugs");
			while($row = mysqli_fetch_array( $result )) {
				$varSSLists=$varSSLists.$row['symptom_name']."*";
			}
		}
		?>
		var data = "<?php echo $varSSLists;?>".split("*");
		// $("#symptom_0").autocomplete(data, {mustMatch: false,autoFill: false,matchContains: "word", max :"40", scrollHeight:"400px"});
		// $("#symptom_1").autocomplete(data, {mustMatch: false,autoFill: false,matchContains: "word", max :"40", scrollHeight:"400px"});
		// $("#symptom_2").autocomplete(data, {mustMatch: false,autoFill: false,matchContains: "word", max :"40", scrollHeight:"400px"});
		// $("#symptom_3").autocomplete(data, {mustMatch: false,autoFill: false,matchContains: "word", max :"40", scrollHeight:"400px"});
		// $("#symptom_4").autocomplete(data, {mustMatch: false,autoFill: false,matchContains: "word", max :"40", scrollHeight:"400px"});	
	});
    
	$(document).ready(function() {
        var accessToken;
        var serviceUri;
        <?php if(isset($_SESSION['token'])) { ?>
        
            accessToken = "<?php echo $_SESSION['token']; ?>";
            serviceUri = "<?php echo $_SESSION['serviceUri']; ?>";
            
        <?php } else if( isset($_GET['code']) && isset($_GET['state']) ) { ?>
        
            // get the URL parameters received from the authorization server
            var state = getUrlParameter("state");  // session key
            var code = getUrlParameter("code");    // authorization code
            console.log(state+" "+code);
            // load the app parameters stored in the session
            var params = JSON.parse(sessionStorage[state]);  // load app session
            var tokenUri = params.tokenUri;
            var clientId = params.clientId;
            var secret = params.secret;
            var redirectUri = params.redirectUri;
            serviceUri = params.serviceUri;
            
            // Prep the token exchange call parameters
            var data = {
                code: code,
                grant_type: 'authorization_code',
                redirect_uri: redirectUri
            };
            var options;
            if (!secret) {
                data['client_id'] = clientId;
            }
            options = {
                url: tokenUri,
                type: 'POST',
                data: data
            };
            if (secret) {
                options['headers'] = {'Authorization': 'Basic ' + btoa(clientId + ':' + secret)};
            }
            // obtain authorization token from the authorization service using the authorization code
            $.ajax(options).done(function(res){
                console.log("res",res);
                accessToken = res.access_token;
                
                $.ajax({
                    url: "token.php",
                    type: "POST",
                    data: {token:accessToken, serviceUri:serviceUri},
                    success: function(data) {
                        console.log("response storing token",data);
                    }
                });
            });
        <?php } ?>
        
		$('div#show_all').hide();
		$('div#show_ten').hide();
        
		$("#searchddx").click( function() {
			data = {
				symptoms: [$("#symptom_0").val(), $("#symptom_1").val(), $("#symptom_2").val(), $("#symptom_3").val(), $("#symptom_4").val()]
			}
			$.post("new_ddx_reports.php", data, function(data, status) {
					$("#ajax_output").html(data);
					$('#ajax_output').trigger('create');		
			});
		});
	});
	
	function clearfield() {
		$(".symptoms").val("");
	}
	
	$(function() {
		$('.final_selections li').on('click', function() {
			if ( $("#symptom_0").val().length == 0 ) {
				$("#symptom_0").val($(this).html());
				return false;
			}
			if ( $("#symptom_1").val().length == 0 ) {
				$("#symptom_1").val($(this).html());
				return false;
			}
			if ( $("#symptom_2").val().length == 0 ) {
				$("#symptom_2").val($(this).html());
				return false;
			}
			if ( $("#symptom_3").val().length == 0 ) {
				$("#symptom_3").val($(this).html());
				return false;
			}
			if ( $("#symptom_4").val().length == 0 ) {
				$("#symptom_4").val($(this).html());
				return false;
			}
		});
	});
</script>
<style>
    .input-group-addon {
        padding:0px !important;
    }
    .form-inline .row {
        padding-bottom:15px;
    }
    #options button {
        margin-bottom:15px;
    }
    .final_selections {
        padding-left: 2px;
    }
    .topSpace {
        margin-top : 10px;
    }
    .final_selections li {
        text-decoration: none;
        list-style: none;
        height: 32px;
        line-height: 25px;
        background: #eee;
        margin-bottom: 2px;
        border-radius: 2px;
        padding: 5px 10px;
        cursor:pointer;
    }
</style>
</head>
<body>
    <?php 
    // if ($_SESSION['logged_user']=='UserLoggedEddm') {
        include('new_nav.php'); 
    // }
    ?>
    <div class="container">
        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6">
                <form class="form-inline" onSubmit="return search(event);">
                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-12">
                            <div class="input-group col-xs-12 col-sm-12 col-md-12">
                                <span class="input-group-addon"><i class="glyphicon glyphicon-search"></i></span>
                                <input class="form-control symptoms" name="symptoms[0]" type="search" id="symptom_0" value="" class="required" placeholder="Use star button on right to find common signs and symptoms">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-12">
                            <div class="input-group col-xs-12 col-sm-12 col-md-12">
                                <span class="input-group-addon"><i class="glyphicon glyphicon-search"></i></span>
                                <input class="form-control symptoms" name="symptoms[1]" type="search" id="symptom_1" value="" class="required" placeholder="Enter at least two signs or symptoms">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-12">
                            <div class="input-group col-xs-12 col-sm-12 col-md-12">
                                <span class="input-group-addon"><i class="glyphicon glyphicon-search"></i></span>
                                <input class="form-control symptoms" name="symptoms[2]" type="search" id="symptom_2" value="" class="required" placeholder="Use three signs or symptoms for better outcome">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-12">
                            <div class="input-group col-xs-12 col-sm-12 col-md-12">
                                <span class="input-group-addon"><i class="glyphicon glyphicon-search"></i></span>
                                <input class="form-control symptoms" name="symptoms[3]" type="search" id="symptom_3" value="" class="required" placeholder="Use fourth if high probability DD not available">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-12">
                            <div class="input-group col-xs-12 col-sm-12 col-md-12">
                                <span class="input-group-addon"><i class="glyphicon glyphicon-search"></i></span>
                                <input class="form-control symptoms" name="symptoms[4]" type="search" id="symptom_4" value="" class="required" placeholder="Must select from drop down box, while free text typing">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-6 col-sm-6 col-md-6">
                            <input class="col-xs-12 col-md-12 btn" type="button" value="Refresh" onClick="javascript: clearfield();" />
                        </div>
                        <div class="col-xs-6 col-sm-6 col-md-6">
                            <input class="col-xs-12 col-md-12 btn btn-primary" type="button" id="searchddx" value="Search"/>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-xs-12 col-sm-6 col-md-6" id="options">
                <button class="btn btn-primary" data-toggle="modal" data-target="#genaral">General</button>
                <!-- Modal -->
                <div id="genaral" class="modal fade" role="dialog">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-body">
                                <div class="panel-group" id="accordion">
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h4 class="panel-title">
                                                <a data-toggle="collapse" data-parent="#accordion" href="#fever">Fever</a>
                                            </h4>
                                        </div>
                                        <div id="fever" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <ul class="final_selections">
                                                    <li>Fever</li>
                                                    <li>Fever Of Unknown Origin</li>
                                                    <li>Fever (TRAVELER)</li>
                                                    <li>Fever (IMMUNOCOMPROMISED)</li>
                                                    <li>Fever (HOSPITAL-ACQUIRED)</li>
                                                    <li>Fever (POSTOPERATIVE)</li>
                                                    <li>Fever (POSTPARTUM)</li>
                                                    <li>Fever (RELAPSING)</li>
                                                    <li>Fever and jaundice</li>
                                                    <li>Fever and rash</li>
                                                    <li>IV drug user and fever</li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h4 class="panel-title">
                                                <a data-toggle="collapse" data-parent="#accordion" href="#headache">Headache</a>
                                            </h4>
                                        </div>
                                        <div id="headache" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <ul class="final_selections">
                                                    <li>Headache</li>
                                                    <li>Headache precipitates by stress, hunger, foods</li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <ul class="final_selections topSpace">
                                        <li>Weight Loss</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <button class="btn btn-primary">Respiratory tract</button>
                <button class="btn btn-primary">Cardiovascular System</button>
                <button class="btn btn-primary">Skeletal System</button>
                <button class="btn btn-primary">Gastrointestinal system</button>
                <button class="btn btn-primary">Hematopoietic</button>
                <button class="btn btn-primary">Urinary tract</button>
                <button class="btn btn-primary">Nervous system</button>
                <button class="btn btn-primary">Endocrine system</button>
                <button class="btn btn-primary">Skins</button>
                <button class="btn btn-primary">Psychologic status</button>
                <button class="btn btn-primary">Head and face</button>
                <button class="btn btn-primary">Ears</button>
                <button class="btn btn-primary">Eyes</button>
                <button class="btn btn-primary">Mouth and throat</button>
                <button class="btn btn-primary">Nose and sinuses</button>
                <button class="btn btn-primary">Breasts</button>
                <button class="btn btn-primary">Genital Tract (Female)</button>
                <button class="btn btn-primary">Genital Tract (Male)</button>
                <button class="btn btn-primary">Common Diseases</button>
            </div>
            <div class="col-xs-12 col-sm-6 col-md-6" style="display:none">
                <div class="panel-group" id="accordion">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h4 class="panel-title">
                                <a data-toggle="collapse" data-parent="#accordion" href="#collapse1">General</a>
                            </h4>
                        </div>
                        <div id="collapse1" class="panel-collapse collapse">
                            <div class="panel-body">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <a data-toggle="collapse" data-parent="#collapse1" href="#fever">Fever</a>
                                        </h4>
                                    </div>
                                    <div id="fever" class="panel-collapse collapse">
                                        <div class="panel-body">
                                        </div>
                                    </div>
                                </div>
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <a data-toggle="collapse" data-parent="#collapse1" href="#headache">Headache</a>
                                        </h4>
                                    </div>
                                    <div id="headache" class="panel-collapse collapse">
                                        <div class="panel-body">
                                            Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h4 class="panel-title">
                                <a data-toggle="collapse" data-parent="#accordion" href="#collapse2">Collapsible Group 2</a>
                            </h4>
                        </div>
                        <div id="collapse2" class="panel-collapse collapse">
                            <div class="panel-body">
                                Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.
                            </div>
                        </div>
                    </div>
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h4 class="panel-title">
                                <a data-toggle="collapse" data-parent="#accordion" href="#collapse3">Collapsible Group 3</a>
                            </h4>
                        </div>
                        <div id="collapse3" class="panel-collapse collapse">
                            <div class="panel-body">
                                Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="ajax_output">
        </div>
        <div id="note_output">
        </div>
    </div>
    <?php
    include ('footer_m.php');
    ?>
</body>
</html>
