<?php

    session_start();
    if( $_SESSION['userType'] != 'doctor' && $_SESSION['userType'] != 'nurse' ) {
        header("Location: provider_login.php");
        die();
    }
    date_default_timezone_set('America/Chicago');
    
    include('process/functions.php');
    include('includes/database_include.php');
    
    function get_user_info( $patient_id, $field = null ){
        
        //$patient_id = $_GET["patient_id"];
        $servername = "localhost";
        $username = "ddxrx_patient";
        $password = "Coastpcp%003";
        $dbname = "telemedicine";
                            
        // Create connection
        $mysqli = new mysqli($servername, $username, $password, $dbname);
        
        // Check connection
        if ($mysqli->connect_error) {
            die("Connection failed: " . $mysqli->connect_error);
        }
    
        $query = "SELECT * FROM patients WHERE patient_id = '$patient_id' limit 1";
        
        $results = array();
        
        if ($result = $mysqli->query($query)) {
    
            /* fetch associative array */
            while ($row = $result->fetch_assoc()) {
                $results[] = $row;
            }
    
            /* free result set */
            $result->free();
        }
        
        /* close connection */
        $mysqli->close();
        
        /* print json object*/
        return $results[0][$field];
        
    }

?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
	<title>Patient Vital History</title>
	
	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
    <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
    <link rel="stylesheet" type="text/css" href="assets/css/jquery-ui.min.css">
    <link rel="stylesheet" type="text/css" href="assets/css/vitals_history.css">
    <link rel="stylesheet" type="text/css" href="assets/css/dashboard_responsive.css">
	<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css">
	
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
	<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
	<script type="text/javascript" src="//cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js"></script>
	<script type="text/javascript" src="assets/js/jquery-ui-drag-and-drop.min.js"></script>
	<script type="text/javascript" src="assets/js/vitals_history.js"></script>
	
	<script type="text/javascript">
	    $(document).ready(function(){
	        
	        // Load DataTable JS
            $('#myTable').DataTable({
                "pageLength": 100,
                "order": [[ 0, "desc" ]]
            });
            
        });
	</script>
	
</head>
<?php

if( isset($_GET['cctype']) || $_GET['cctype'] != '' ){
    $cctype = $_GET['cctype'];
}else{
    $cctype = 'none';
}
?>
<body data-patient-id="<?php if( isset($_GET['patient_id']) ){ echo $_GET['patient_id']; } ?>" data-user-type="<?php echo $_SESSION['user_type']; ?>" <?php if( $_SESSION['user_type'] == 'nurse' ){ echo 'data-nurse-id="'.$_SESSION['userid'].'"'; } ?> <?php if( $_SESSION['user_type'] == 'doctor' ){ echo 'data-physician-id="'.$_SESSION['userid'].'"'; } ?> data-cctype="<?php echo $cctype; ?>">
    
    <!-- Billing Code Popup -->
    <div class="billing-code-popup">
        <div class="billing-form">
            <div class="inner">
                
                <a href="javascript:;" class="close">Close</a>
                
                <h4>Select RPM CPT Code</h4>
                
                <?php
                /*
                $sql = "SELECT * FROM billing_code WHERE";
                $result = ddxrxDBConnect()->query($sql);
                
                // Associative array
                $row = $result -> fetch_assoc();
                */
                ?>
                
                <label>
                    <input type="checkbox" class="checkbox" id="cpt_1" name="cpt_1" value="99453" <?php //if( $row['cpt_code'] == '99453' ){ echo 'checked disabled'; } ?>>
                    <span>99453</span>
                    <div class="clear"></div>
                </label>
                
                <label>
                    <input type="checkbox" class="checkbox" id="cpt_2" name="cpt_2" value="99454" checked <?php //if( $row['cpt_code'] == '99454' ){ echo 'disabled'; } ?>>
                    <span>99454</span>
                    <div class="clear"></div>
                </label>
                
                <label>
                    <input type="checkbox" class="checkbox" id="cpt_3" name="cpt_3" value="99457" checked <?php //if( $row['cpt_code'] == '99457' ){ echo 'disabled'; } ?>>
                    <span>99457</span>
                    <div class="clear"></div>
                </label>
                
                <label>
                    <input type="checkbox" class="checkbox" id="cpt_4" name="cpt_4" value="99458" <?php //if( $row['cpt_code'] == '99458' ){ echo 'checked disabled'; } ?>>
                    <span>99458</span>
                    <div class="clear"></div>
                </label>
                
                <h4>Select CCM CPT Code</h4>
                
                <label>
                    <input type="checkbox" class="checkbox" id="cpt_1" name="cpt_1" value="99490" <?php //if( $row['cpt_code'] == '99490' ){ echo 'checked disabled'; } ?>>
                    <span>99490</span>
                    <div class="clear"></div>
                </label>
                
                <label>
                    <input type="checkbox" class="checkbox" id="cpt_2" name="cpt_2" value="99491" <?php //if( $row['cpt_code'] == '99491' ){ echo 'checked disabled'; } ?>>
                    <span>99491</span>
                    <div class="clear"></div>
                </label>
                
                <label>
                    <input type="checkbox" class="checkbox" id="cpt_3" name="cpt_3" value="99487" <?php //if( $row['cpt_code'] == '99487' ){ echo 'checked disabled'; } ?>>
                    <span>99487</span>
                    <div class="clear"></div>
                </label>
                
                <a href="javascript:;" class="button submit">Submit</a>
                
                <?php
                /*
                $result -> free_result();
                
                ddxrxDBConnect() -> close();
                */
                ?>
                
            </div>
        </div>
    </div>
    <!-- Billing Code Popup -->
    
    <!-- Popup: Vitals -->
    <div class="popup-container">
        <div class="popup">
            <h6>Add Vital Information</h6>
            <div class="padded">
                
                <input type="hidden" id="hidden_patient_id" value="<?php echo $_GET['patient_id']; ?>">
                
                <div class="col-md-6">
                    <label>
                        <span>Systolic BP</span>
                        <input type="text" class="textbox" id="systolicBP" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Diastolic BP</span>
                        <input type="text" class="textbox" id="diastolicBP" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Heart Rate</span>
                        <input type="text" class="textbox" id="heartRate" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Respiratory Rate</span>
                        <input type="text" class="textbox" id="respRate" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Pulse OX</span>
                        <input type="text" class="textbox" id="pulseOX" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Temperature</span>
                        <input type="text" class="textbox" id="temp" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Glucose</span>
                        <input type="text" class="textbox" id="glucose" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Weight</span>
                        <input type="text" class="textbox" id="weight" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 50px;"></div>
                
                <div class="col-md-12">
                    <a href="javascript:;" class="button blue add_vitals">Add Vitals</a>
                    <a href="javascript:;" class="button red cancel">Cancel</a>
                    <div class="clear"></div>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
            </div>
        </div>
    </div>
    <!-- Popup: Vitals -->
    
    <!-- Sticky -->
    <div class="popup-sticky-container" style="display: none">
        
        <!-- Item -->
        <div class="item">
            Test
        </div>
        <!-- Item -->
        
    </div>
    <!-- Sticky -->
    
    <!-- Header -->
    <div class="header">
        <div class="container">
            
            <div class="padded">
                <div class="patient-info">
                    <ul>
                        <li>Patient Name:<span><?php echo get_user_info($_GET['patient_id'], 'patient_fname').' '.get_user_info($_GET['patient_id'], 'patient_lname'); ?></span></li>
                        <li>Gender:<span><?php echo get_user_info($_GET['patient_id'], 'patient_gender'); ?></span></li>
                        <li>Age:<span><?php echo get_user_info($_GET['patient_id'], 'patient_dob'); ?></span></li>
                        <li>Phone Number:<span><a href="tel:<?php echo get_user_info($_GET['patient_id'], 'cell'); ?>"><?php echo get_user_info($_GET['patient_id'], 'cell'); ?></a></span></li>
                        <div class="clear"></div>
                    </ul>
                    
                    <script>
                        function secondsTimeSpanToHMS(s) {
                            var h = Math.floor(s/3600); //Get whole hours
                            s -= h*3600;
                            var m = Math.floor(s/60); //Get remaining minutes
                            s -= m*60;
                            return h+":"+(m < 10 ? '0'+m : m)+":"+(s < 10 ? '0'+s : s); //zero padding on minutes and seconds
                        }
                        
                        
                        localStorage.setItem("storedTime", "0");
                        
                        var c = 0;
                        
                        function standardTime( resetTime ) {
                            
                        	var counter = setInterval(function() {
                        	    
                            	var currentTime = 0;
                            	var time = ++c;
                            	  	
                            	currentTime = Number(currentTime)+1;
                            	  	
                            	// Store Values in local storage
                                localStorage.setItem("storedTime", currentTime);
                            	  	
                            	// Increment Number In DOM
                            	$('#time-counter').html( secondsTimeSpanToHMS(time) );
                                
                                var totaltime = localStorage.getItem("storedTime");
                            
                                $.ajax({
                                    type: 'POST',
                                    url: 'process/synctime.php',
                                        
                                    data: {
                                        cctype: "<?php echo $_GET['cctype']; ?>",
                                        provider_id: "<?php echo $_SESSION['userid']; ?>",
                                        provider_type: "<?php echo $_SESSION['user_type']; ?>",
                                    	patient_id: "<?php echo $_GET['patient_id']; ?>",
                                    	totaltime: totaltime
                                    },
                                    success: function(response) {
                                        
                                    },
                                });
                                
                          	}, 1000);
                            
                        	return counter;
                        }
                        
                        standardTime();
                        
                        
                        $('body').on('click', '#stopTime', function() {
                            
                            var totaltime = localStorage.getItem("storedTime");
                            
                            $.ajax({
                                type: 'POST',
                                url: 'process/synctime.php',
                                    
                                data: {
                                    cctype: "<?php echo $_GET['cctype']; ?>",
                                    provider_id: "<?php echo $_SESSION['userid']; ?>",
                                    provider_type: "<?php echo $_SESSION['user_type']; ?>",
                                	patient_id: "<?php echo $_GET['patient_id']; ?>",
                                	totaltime: totaltime
                                },
                                success: function(response) {
                                    
                                    if( response.rstatus == 'success' ){
                                        localStorage.setItem("storedTime", "0");
                                        $('#stopTime').hide();
                                        $('#startTime').show();
                                    }
                                    
                                },
                            });
                            
                        });
                        
                        $('body').on('click', '#startTime', function() {
                            $('#startTime').hide();
                            $('#stopTime').show();
                        });
                        
                    </script>
                    
                    <div class="timer">
                        <div class="total-time">
                            <span><?php echo file_get_contents('https://'.$_SERVER['SERVER_NAME'].'/process/time_report.php?type=current_month&patient_id='.$_GET['patient_id'].'&cctype='.$_GET['cctype'] ); ?></span>
                            <select class="selectbox">
                                
                                <?php
                                $current_month = date('n');
                                
                                for( $i = $current_month; $i >= 1; $i = $i-1 ){
                                    
                                    $dt = DateTime::createFromFormat('!m', $i);
                                    echo $dt->format('F');
                                    echo '<option value="custom" data-type="last_month" data-target="https://'.$_SERVER['SERVER_NAME'].'/process/time_report.php?type=custom_month&patient_id='.$_GET['patient_id'].'&month='.$i.'&cctype='.$_GET['cctype'].'">'.$dt->format('F').'</option>';
                                    
                                }
                                echo $current_month;
                                ?>
                                
                                
                                <option value="total-time" data-type="total_time" data-target="https://<?php echo $_SERVER['SERVER_NAME'] ?>/process/time_report.php?type=total_time&patient_id=<?php echo $_GET['patient_id'].'&cctype='.$_GET['cctype']; ?>">Total Time</option>
                                <!--<option value="custom-date" data-type="custom_range">Custom Range</option>-->
                            </select>
                        </div>
                        
                        <div id="time-counter" data-seconds="" style="display: inline-block;">0:00:00</div>
                        <!--
                        <img src="assets/images/play-button.png" onClick="myTimer = standardTime();" id="startTime" class="button play">
                        <img src="assets/images/pause.png" onClick="clearInterval(myTimer);" id="stopTime" class="button pause" style="display: none">
                        -->
                        <div class="clear"></div>
                        
                    </div>
                    
                    <div class="clear"></div>
                </div>
            </div>
            
        </div>
        
        <div class="menu-container">
            <ul>
                <li><a href="javascript:;" class="popup_vitals">Add Vitals</a></li>
                <li><a href="javascript:;" class="popup_new_notes">New Note</a></li>
                
                <?php if( $cctype == 'rpm' ){ ?>
                    <li><a href="notes_rpm.php?id=<?php echo $_GET['patient_id']; ?>">Prior Notes</a></li>
                <?php }elseif( $cctype == 'ccm' ){ ?>
                    <li><a href="notes_ccm.php?id=<?php echo $_GET['patient_id']; ?>">Prior Notes</a></li>
                <?php } ?>
                
                <li><a href="javascript:;" class="popup_billing_codes">Submit Billing Codes</a></li>
                <li class="right"><a href="dashboard.php">Main Dashboard</a></li>
                <li class="right"><a href="vitals_dashboard.php">Chronic Care Dashboard</a></li>
            </ul>
            <div class="clear"></div>
        </div>
        
    </div>
    <!-- Header -->
    
    <div class="container" style="position: relative">
        <div class="TableContainer">
            
            <div class="syncContainer"></div>
            
            <table id="myTable" class="single_user_data">
            	<thead>
                    <tr>
                        <td>Date</td>
                        <td>Systolic</td>
                        <td>Diastolic</td>
                        <td>Heartrate</td>
                        <td>Rhythm</td>
                        <td>Pulse OX</td>
                        <td>Temp</td>
                        <td>Glucose</td>
                        <td>Weight</td>
                        <td>Data Type</td>
                    </tr>
                </thead>
    
                <tbody>
                    
                <?php
                    include('includes/database_include.php');
                        
                    $patient_id = $_GET['patient_id'];
                    $servername = "localhost";
                    $username = "ddxrx_patient";
                    $password = "Coastpcp%003";
                    $dbname = "telemedicine";
                        
                    // Create connection
                    $conn = new mysqli($servername, $username, $password, $dbname);
                    
                    // Check connection
                    if ($conn->connect_error) {
                        die("Connection failed: " . $conn->connect_error);
                    }
                        
                    $sql = "SELECT * FROM vitals_history WHERE patient_id = '$patient_id' ORDER by date_added DESC";
                    $result = $conn->query($sql);
                    
                    if( $row["respiratory"] == 0 ){
                        $respiratory = 'Regular';
                    }else{
                        $respiratory = "Irregular";
                    }
                    
                    if ($result->num_rows > 0) {
                        while($row = $result->fetch_assoc()) {
                                
                            echo '<tr>';
                            // $row["date_added"]
                            echo '<td>' . explode(" ", $row["date_added"])[0] . '</td>';
                            echo '<td>' . $row["systolic"] . '</td>';
                            echo '<td>' . $row["diastolic"] . '</td>';
                            echo '<td>' . $row["heartrate"] . '</td>';
                            echo '<td>' . $respiratory . '</td>';
                            echo '<td>' . $row["pulseox"] . '</td>';
                            echo '<td>' . $row["temp"] . '</td>';
                            echo '<td>' . $row["glucose"] . '</td>';
                            echo '<td>' . $row["weight"] . '</td>';
                            echo '<td>' . $row["dataSource"] . '</td>';
                            
                            echo '</tr>';
                                
                        }
                    } else {
                        //echo "0 results";
                    }
                    $conn->close();
                ?>
                    
                </tbody>
            </table>
        </div>
    </div>
    
    <?php provider_bottom_nav(); ?>
    
</body>
</html>