jQuery(document).ready(function($){
	$('.hard-reset-username').click(function(){

		var user_id = $('body').data('user-id');
		var new_user = $('.textbox.new_user').val();
        
        // Validate if the username is empty or not
        if( new_user !== '' ){
        
    		$.ajax({
    			type: 'POST',
    			url: 'process/reset_username.php',
    
    			data: {
    				user_id:user_id,
    				new_user:new_user
    			},
    
    			beforeSend: function() {
    			    // Do Something
    			},
    			success: function(response) {
    			    if( response == 'success' ){
        				Swal.fire({
        					type: 'success',
        				  	title: 'Success',
        				  	text: 'Username has been reset to: '+new_user+'',
        				});
    			    }else{
    			        Swal.fire({
        					type: 'error',
        				  	title: 'Oops...',
        				  	text: 'Username change failed!',
    				    });
    			    }
    			},
    			
    			fail: function(response){
    				Swal.fire({
    					type: 'error',
    				  	title: 'Oops...',
    				  	text: 'Username change failed!',
    				});
    			}
    
    		});
		
		// if its not empty then show error message
        }else{
            
            Swal.fire({
    			type: 'error',
    			title: 'Invalid Username',
    			text: 'Username field cannot be empty',
    		});
            
        }
		

	});
});