$(document).ready(function(){
    
    // Add Invoice Record
    $('body').on('click', '.verification.enabled #add-record', function() {
        
        var clinicname = $('.clinicname').val();
        var month = $('.month').val();
        var year = $('.year').val();
        var amount = $('.amount').val();
        
        var no_patient_paid = $('.no_patient_paid').val();
        var no_patient = $('.no_patient').val();
        var no_enrollment = $('.no_enrollment').val();
        var monthly_rate = $('.monthly_rate').val();
        
        var share_partner = $('.share_partner').val();
        var partner_address = $('.partner_address').val();
        var ssn = $('.ssn').val();
        var patient_per_month = $('.patient_per_month').val();
        
        $.ajax({
			type: 'POST',
			url: 'process/add-record.php',

			data: {
			    clinicname:clinicname,
				no_patient_paid:no_patient_paid,
				share_partner:share_partner,
				month:month,
				no_patient:no_patient,
				partner_address:partner_address,
				year:year,
				no_enrollment:no_enrollment,
				ssn:ssn,
				amount:amount,
				monthly_rate:monthly_rate,
				patient_per_month:patient_per_month
			},
			beforeSend: function() {
					
			},
			success: function(response) {
                    
                Swal.fire({
                    icon: 'success',
                    title: "Record Added",
                    text: "Record have successfully been added to our database",
                });
                    
			},	
			fail: function(response){
				// Do Something
			}

		});
		// End Ajax
        
    });
    
    // Add Clinic Data
    $('body').on('click', '#add-clinic-data', function() {
        
        var clinic_name = $('.clinic_name').val();
        var monthly_rate = $('.monthly_rate').val();
        var number_of_device_sent = $('.number_of_device_sent').val();
        var clinic_address = $('.clinic_address').val();
        var owner_name = $('.owner_name').val();
        var owner_cell = $('.owner_cell').val();
        var owner_email = $('.owner_email').val();
        
        if( clinic_name != '' && monthly_rate != '' && number_of_device_sent != '' && clinic_address != '' && owner_name != '' && owner_cell != '' && owner_email != '' ){
        
            $.ajax({
    			type: 'POST',
    			url: 'process/add-clinic-data.php',
    
    			data: {
    			    clinic_name:clinic_name,
    				monthly_rate:monthly_rate,
    				number_of_device_sent:number_of_device_sent,
    				clinic_address:clinic_address,
    				owner_name:owner_name,
    				owner_cell:owner_cell,
    				owner_email:owner_email
    			},
    			beforeSend: function() {
    					
    			},
    			success: function(response) {
                        
                    Swal.fire({
                        icon: 'success',
                        title: "Record Added",
                        text: "Record have successfully been added to our database",
                    });
                        
    			},	
    			fail: function(response){
    				// Do Something
    			}
    
    		});
		
        }else{
            
            Swal.fire({
                icon: 'error',
                title: "Empty Fields",
                text: "All fields cannot be empty, please fill them up before sending.",
            });
            
        }
        
    });
    
    // Disabled Forms
    $('body').on('click', '.verification.disabled', function() {
        $('.form-control.clinicname').effect('highlight');
        $('.form-control.clinicname').effect('shake');
    });
    
    // Enable Forms when selecbox has values
    $('.form-control.clinicname').on('change', function() {
        
        if( $(this).find(":selected").val() != '' ){
            
            $('.verification').removeClass('disabled');
            $('.verification').addClass('enabled');
            
            $('.form-control').prop("disabled", false);
            
        }else{
            
            $('.verification').addClass('disabled');
            $('.verification').removeClass('enabled');
            
            $('.form-control').prop("disabled", false);
            $('.form-control.clinicname').prop("disabled", true);
            
        }
        
    });
    
});